/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.feign.plugin.reporter;

import com.tencent.cloud.rpc.enhancement.AbstractPolarisReporterAdapter;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignContext;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPlugin;
import com.tencent.cloud.rpc.enhancement.feign.plugin.EnhancedFeignPluginType;
import com.tencent.cloud.rpc.enhancement.feign.plugin.reporter.ReporterUtils;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import feign.Request;
import feign.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class SuccessPolarisReporter
extends AbstractPolarisReporterAdapter
implements EnhancedFeignPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessPolarisReporter.class);
    private final ConsumerAPI consumerAPI;

    public SuccessPolarisReporter(RpcEnhancementReporterProperties properties, ConsumerAPI consumerAPI) {
        super(properties);
        this.consumerAPI = consumerAPI;
    }

    @Override
    public String getName() {
        return SuccessPolarisReporter.class.getName();
    }

    @Override
    public EnhancedFeignPluginType getType() {
        return EnhancedFeignPluginType.POST;
    }

    @Override
    public void run(EnhancedFeignContext context) {
        if (!this.reportProperties.isEnabled()) {
            return;
        }
        if (this.consumerAPI != null) {
            Request request = context.getRequest();
            Response response = context.getResponse();
            RetStatus retStatus = RetStatus.RetSuccess;
            if (this.apply(HttpStatus.resolve((int)response.status()))) {
                retStatus = RetStatus.RetFail;
            }
            LOG.debug("Will report result of {}. Request=[{}]. Response=[{}].", new Object[]{retStatus.name(), request, response});
            ServiceCallResult resultRequest = ReporterUtils.createServiceCallResult(request, retStatus);
            this.consumerAPI.updateServiceCallResult(resultRequest);
            resultRequest.setMethod("");
            this.consumerAPI.updateServiceCallResult(resultRequest);
        }
    }

    @Override
    public void handlerThrowable(EnhancedFeignContext context, Throwable throwable) {
        Request request = context.getRequest();
        Response response = context.getResponse();
        LOG.error("SuccessPolarisReporter runs failed. Request=[{}]. Response=[{}].", new Object[]{request, response, throwable});
    }

    public int getOrder() {
        return -2147483647;
    }
}

