/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.rpc.enhancement.resttemplate;

import com.tencent.cloud.common.constant.ContextConstant;
import com.tencent.cloud.common.metadata.MetadataContext;
import com.tencent.cloud.common.metadata.MetadataContextHolder;
import com.tencent.cloud.rpc.enhancement.AbstractPolarisReporterAdapter;
import com.tencent.cloud.rpc.enhancement.config.RpcEnhancementReporterProperties;
import com.tencent.polaris.api.core.ConsumerAPI;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.Service;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.rpc.ServiceCallResult;
import com.tencent.polaris.api.utils.CollectionUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.web.client.ResponseErrorHandler;

public class EnhancedRestTemplateReporter
extends AbstractPolarisReporterAdapter
implements ResponseErrorHandler,
ApplicationContextAware {
    static final String HEADER_HAS_ERROR = "X-SCT-Has-Error";
    private static final Logger LOGGER = LoggerFactory.getLogger(EnhancedRestTemplateReporter.class);
    private final ConsumerAPI consumerAPI;
    private ResponseErrorHandler delegateHandler;

    public EnhancedRestTemplateReporter(RpcEnhancementReporterProperties properties, ConsumerAPI consumerAPI) {
        super(properties);
        this.consumerAPI = consumerAPI;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        String[] handlerBeanNames = applicationContext.getBeanNamesForType(ResponseErrorHandler.class);
        if (handlerBeanNames.length == 1) {
            return;
        }
        for (String beanName : handlerBeanNames) {
            if (StringUtils.equalsIgnoreCase((String)"enhancedRestTemplateReporter", (String)beanName)) continue;
            this.delegateHandler = (ResponseErrorHandler)applicationContext.getBean(beanName);
        }
    }

    public boolean hasError(@NonNull ClientHttpResponse response) throws IOException {
        if (this.delegateHandler != null) {
            boolean hasError = this.delegateHandler.hasError(response);
            response.getHeaders().add(HEADER_HAS_ERROR, String.valueOf(hasError));
        }
        return true;
    }

    public void handleError(@NonNull ClientHttpResponse response) throws IOException {
        if (this.realHasError(response).booleanValue()) {
            this.delegateHandler.handleError(response);
        }
        this.clear(response);
    }

    public void handleError(@NonNull URI url, @NonNull HttpMethod method, @NonNull ClientHttpResponse response) throws IOException {
        if (this.reportProperties.isEnabled()) {
            this.reportResult(url, response);
        }
        this.invokeDelegateHandler(url, method, response);
    }

    private void reportResult(URI url, ClientHttpResponse response) {
        ServiceCallResult resultRequest = this.createServiceCallResult(url);
        try {
            List labels;
            Map loadBalancerContext = MetadataContextHolder.get().getLoadbalancerMetadata();
            String targetHost = (String)loadBalancerContext.get("host");
            String targetPort = (String)loadBalancerContext.get("port");
            if (StringUtils.isBlank((String)targetHost) || StringUtils.isBlank((String)targetPort)) {
                LOGGER.warn("Can not get target host or port from metadata context. host = {}, port = {}", (Object)targetHost, (Object)targetPort);
                return;
            }
            resultRequest.setHost(targetHost);
            resultRequest.setPort(Integer.parseInt(targetPort));
            if (this.apply(response.getStatusCode())) {
                resultRequest.setRetStatus(RetStatus.RetFail);
            }
            if (CollectionUtils.isNotEmpty((Collection)(labels = response.getHeaders().get((Object)"internal-router-label")))) {
                String label = (String)labels.get(0);
                try {
                    label = URLDecoder.decode(label, ContextConstant.UTF_8);
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("unsupported charset exception " + ContextConstant.UTF_8, (Throwable)e);
                }
                resultRequest.setLabels(this.convertLabel(label));
            }
            LOGGER.debug("Will report result of {}. URL=[{}]. Response=[{}].", new Object[]{resultRequest.getRetStatus().name(), url, response});
            this.consumerAPI.updateServiceCallResult(resultRequest);
            resultRequest.setMethod("");
            this.consumerAPI.updateServiceCallResult(resultRequest);
        }
        catch (Exception e) {
            LOGGER.error("RestTemplate response reporter execute failed of {} url {}", new Object[]{response, url, e});
        }
    }

    private String convertLabel(String label) {
        label = label.replaceAll("\"|\\{|\\}", "").replaceAll(",", "|");
        return label;
    }

    private void invokeDelegateHandler(URI url, HttpMethod method, ClientHttpResponse response) throws IOException {
        if (this.realHasError(response).booleanValue()) {
            this.delegateHandler.handleError(url, method, response);
        }
        this.clear(response);
    }

    private Boolean realHasError(ClientHttpResponse response) {
        if (this.delegateHandler == null) {
            return false;
        }
        String hasErrorHeader = response.getHeaders().getFirst(HEADER_HAS_ERROR);
        if (StringUtils.isBlank((String)hasErrorHeader)) {
            return false;
        }
        return Boolean.parseBoolean(hasErrorHeader);
    }

    private void clear(ClientHttpResponse response) {
        if (!response.getHeaders().containsKey((Object)HEADER_HAS_ERROR)) {
            return;
        }
        response.getHeaders().remove((Object)HEADER_HAS_ERROR);
    }

    private ServiceCallResult createServiceCallResult(URI uri) {
        ServiceCallResult resultRequest = new ServiceCallResult();
        String serviceName = uri.getHost();
        resultRequest.setService(serviceName);
        resultRequest.setNamespace(MetadataContext.LOCAL_NAMESPACE);
        resultRequest.setMethod(uri.getPath());
        resultRequest.setRetStatus(RetStatus.RetSuccess);
        String sourceNamespace = MetadataContext.LOCAL_NAMESPACE;
        String sourceService = MetadataContext.LOCAL_SERVICE;
        if (StringUtils.isNotBlank((String)sourceNamespace) && StringUtils.isNotBlank((String)sourceService)) {
            resultRequest.setCallerService((Service)new ServiceKey(sourceNamespace, sourceService));
        }
        return resultRequest;
    }

    public void setDelegateHandler(ResponseErrorHandler delegateHandler) {
        this.delegateHandler = delegateHandler;
    }
}

