/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.devops.leaf.plugin;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.base.Preconditions;
import com.tencent.devops.leaf.exception.InitException;
import com.tencent.devops.leaf.plugin.LeafSpringBootProperties;
import com.tencent.devops.leaf.plugin.util.LeafSpringContextUtil;
import com.tencent.devops.leaf.segment.dao.IDAllocDao;
import com.tencent.devops.leaf.segment.dao.impl.IDAllocDaoImpl;
import com.tencent.devops.leaf.service.SegmentService;
import com.tencent.devops.leaf.service.SnowflakeService;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={LeafSpringBootProperties.class})
public class LeafSpringBootStarterAutoConfigure {
    private final Logger logger = LoggerFactory.getLogger(LeafSpringBootStarterAutoConfigure.class);
    @Autowired
    private LeafSpringBootProperties properties;

    @Bean
    public LeafSpringContextUtil leafSpringContextUtil() {
        return new LeafSpringContextUtil();
    }

    @Bean
    @DependsOn(value={"leafSpringContextUtil"})
    public SegmentService initLeafSegmentStarter() throws Exception {
        LeafSpringBootProperties.Segment segment = this.properties.getSegment();
        if (this.properties != null && segment != null && segment.isEnable()) {
            String allocStrategyDaoBeanName = segment.getAllocStrategyDaoBeanName();
            IDAllocDao allocDao = null;
            if (!StringUtils.isEmpty((Object)allocStrategyDaoBeanName)) {
                allocDao = LeafSpringContextUtil.getBean(allocStrategyDaoBeanName, IDAllocDao.class);
            } else {
                String url = segment.getUrl();
                String username = segment.getUsername();
                String pwd = segment.getPassword();
                Preconditions.checkNotNull((Object)url, (Object)"database url can not be null");
                Preconditions.checkNotNull((Object)username, (Object)"username can not be null");
                Preconditions.checkNotNull((Object)pwd, (Object)"password can not be null");
                DruidDataSource dataSource = new DruidDataSource();
                dataSource.setUrl(url);
                dataSource.setUsername(username);
                dataSource.setPassword(pwd);
                dataSource.init();
                allocDao = new IDAllocDaoImpl((DataSource)dataSource);
            }
            return new SegmentService(allocDao);
        }
        this.logger.warn("init leaf segment ignore properties is {}", (Object)this.properties);
        return null;
    }

    @Bean
    public SnowflakeService initLeafSnowflakeStarter() throws InitException {
        if (this.properties != null && this.properties.getSnowflake() != null && this.properties.getSnowflake().isEnable()) {
            return new SnowflakeService(this.properties.getSnowflake().getAddress(), this.properties.getSnowflake().getPort());
        }
        this.logger.warn("init leaf snowflake ignore properties is {}", (Object)this.properties);
        return null;
    }
}

