package com.tencent.imsdk.group;

import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.message.DraftMessage;
import java.io.Serializable;

public class TopicInfo implements Serializable {
    private int errorCode;
    private String errorMessage;
    private GroupInfo groupInfo = new GroupInfo();
    private Conversation conversation;
    private String draftText;

    public int getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public GroupInfo getGroupInfo() {
        return groupInfo;
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    public Conversation getConversation() {
        return conversation;
    }

    public void setConversation(Conversation conversation) {
        this.conversation = conversation;
    }

    public void setTempDraft(String draftText) {
        this.draftText = draftText;
    }

    public String getTempDraft() {
        return this.draftText;
    }

    public String getDraftText() {
        if (conversation == null) {
            return null;
        }
        DraftMessage draftMessage = conversation.getDraftMessage();
        if (draftMessage == null) {
            return null;
        }
        byte[] draftData = draftMessage.getUserDefinedData();
        if (draftData != null) {
            return new String(draftData);
        }
        return null;
    }
}
