package com.tencent.imsdk.message;

import android.text.TextUtils;

import com.tencent.imsdk.group.GroupInfoChangeItem;
import com.tencent.imsdk.group.GroupMemberInfo;
import com.tencent.imsdk.group.GroupMemberInfoChangeItem;
import com.tencent.imsdk.relationship.UserInfo;

import java.util.ArrayList;
import java.util.List;

public class GroupTipsElement extends MessageBaseElement {
    public static final int GROUP_TIPS_TYPE_NONE                        = 0;
    public static final int GROUP_TIPS_TYPE_JOIN                        = 1;
    public static final int GROUP_TIPS_TYPE_QUIT                        = 2;
    public static final int GROUP_TIPS_TYPE_KICK                        = 3;
    public static final int GROUP_TIPS_TYPE_GRANT_ADMINISTRATOR         = 4;
    public static final int GROUP_TIPS_TYPE_REVOKE_ADMINISTRATOR        = 5;
    public static final int GROUP_TIPS_TYPE_GROUP_INFO_CHANGE           = 6;
    public static final int GROUP_TIPS_TYPE_GROUP_MEMBER_INFO_CHANGE    = 7;

    private int groupTipsType;
    private String groupID;
    private String groupType;

    // 操作者信息
    private String operatorUserID;
    private UserInfo operatorUserInfo;
    private GroupMemberInfo operatorGroupMemberInfo;

    // 被操作者信息
    private List<String> targetUserIDList = new ArrayList<>();
    private List<UserInfo> targetUserInfoList = new ArrayList<>();
    private List<GroupMemberInfo> targetGroupMemberInfoList = new ArrayList<>();

    // 群资料变更项
    private List<GroupInfoChangeItem> groupInfoChangeItemList = new ArrayList<>();

    // 群成员资料变更项
    private List<GroupMemberInfoChangeItem> groupMemberInfoChangeItemList = new ArrayList<>();

    private int groupMemberCount;
    private String operatorPlatForm;

    public int getGroupTipsType() {
        return groupTipsType;
    }

    public String getGroupID() {
        return groupID;
    }

    public String getGroupType() {
        return groupType;
    }

    public String getOperatorUserID() {
        return operatorUserID;
    }

    public UserInfo getOperatorUserInfo() {
        return operatorUserInfo;
    }

    public GroupMemberInfo getOperatorGroupMemberInfo() {
        return operatorGroupMemberInfo;
    }

    public List<String> getTargetUserIDList() {
        return targetUserIDList;
    }

    void addTargetUserID(String userID) {
        if (TextUtils.isEmpty(userID)) {
            return;
        }
        targetUserIDList.add(userID);
    }

    public List<GroupMemberInfo> getTargetGroupMemberInfoList() {
        return targetGroupMemberInfoList;
    }

    void addTargetGroupMemberInfo(GroupMemberInfo groupMemberInfo) {
        if (groupMemberInfo == null) {
            return;
        }
        targetGroupMemberInfoList.add(groupMemberInfo);
    }

    public List<UserInfo> getTargetUserInfoList() {
        return targetUserInfoList;
    }

    void addTargetUserInfo(UserInfo userInfo) {
        targetUserInfoList.add(userInfo);
    }

    public List<GroupInfoChangeItem> getGroupInfoChangeItemList() {
        return groupInfoChangeItemList;
    }

    void addGroupInfoChangeItem(GroupInfoChangeItem groupInfoChangeItem) {
        if (groupInfoChangeItem == null) {
            return;
        }
        groupInfoChangeItemList.add(groupInfoChangeItem);
    }

    public List<GroupMemberInfoChangeItem> getGroupMemberInfoChangeItemList() {
        return groupMemberInfoChangeItemList;
    }

    void addGroupMemberInfoChangeItem(GroupMemberInfoChangeItem groupMemberInfoChangeItem) {
        if (groupMemberInfoChangeItem == null) {
            return;
        }
        groupMemberInfoChangeItemList.add(groupMemberInfoChangeItem);
    }

    public int getGroupMemberCount() {
        return groupMemberCount;
    }

    public String getOperatorPlatForm() {
        return operatorPlatForm;
    }
}
