package com.tencent.imsdk.signaling;

import java.util.List;

public abstract class SignalingListener {
    public void onReceiveNewInvitation(String inviteID, String inviter, String groupID, List<String> inviteeList, String data) {}

    public void onInviteeAccepted(String inviteID, String invitee, String data) {}

    public void onInviteeRejected(String inviteID, String invitee, String data) {}

    public void onInvitationCancelled(String inviteID, String inviter, String data) {}

    public void onInvitationTimeout(String inviteID, List<String> inviteeList) {}

    public void onInvitationModified(String inviteID, String data) {}
}
