/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.conversation;

import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.common.IMContext;
import com.tencent.imsdk.conversation.Conversation;
import com.tencent.imsdk.conversation.ConversationKey;
import com.tencent.imsdk.conversation.ConversationListFilter;
import com.tencent.imsdk.conversation.ConversationListener;
import com.tencent.imsdk.conversation.ConversationResult;
import com.tencent.imsdk.manager.BaseManager;
import com.tencent.imsdk.message.DraftMessage;
import java.util.List;

public class ConversationManager {
    private static final String TAG = "ConversationManager";
    private ConversationListener mInternalConversationListener;
    private ConversationListener mConversationListener;

    public static ConversationManager getInstance() {
        return ConversationManagerHolder.conversationManager;
    }

    public void init() {
        this.initInternalConversationListener();
    }

    private void initInternalConversationListener() {
        if (this.mInternalConversationListener == null) {
            this.mInternalConversationListener = new ConversationListener(){

                @Override
                public void onSyncServerStart() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerStart();
                            }
                        }
                    });
                }

                @Override
                public void onSyncServerFinish() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerFinish();
                            }
                        }
                    });
                }

                @Override
                public void onSyncServerFailed() {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onSyncServerFailed();
                            }
                        }
                    });
                }

                @Override
                public void onNewConversation(final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onNewConversation(conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationChanged(final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationChanged(conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onTotalUnreadMessageCountChanged(final long totalUnreadCount) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onTotalUnreadMessageCountChanged(totalUnreadCount);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupCreated(final String groupName, final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationGroupCreated(groupName, conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupDeleted(final String groupName) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationGroupDeleted(groupName);
                            }
                        }
                    });
                }

                @Override
                public void onConversationGroupNameChanged(final String oldName, final String newName) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationGroupNameChanged(oldName, newName);
                            }
                        }
                    });
                }

                @Override
                public void onConversationsAddedToGroup(final String groupName, final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationsAddedToGroup(groupName, conversationList);
                            }
                        }
                    });
                }

                @Override
                public void onConversationsDeletedFromGroup(final String groupName, final List<Conversation> conversationList) {
                    IMContext.getInstance().runOnMainThread(new Runnable(){

                        @Override
                        public void run() {
                            if (ConversationManager.this.mConversationListener != null) {
                                ConversationManager.this.mConversationListener.onConversationsDeletedFromGroup(groupName, conversationList);
                            }
                        }
                    });
                }
            };
        }
        this.nativeSetConversationListener(this.mInternalConversationListener);
    }

    public void setConversationListener(ConversationListener conversationListener) {
        this.mConversationListener = conversationListener;
    }

    public void getConversationList(long nextSeq, int count, IMCallback<ConversationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationList(nextSeq, count, callback);
    }

    public void getConversationListByFilter(ConversationListFilter filter, IMCallback<ConversationResult> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationListByFilter(filter, callback);
    }

    public void getConversationList(List<ConversationKey> conversationKeyList, IMCallback<List<Conversation>> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversations(conversationKeyList, callback);
    }

    public void getConversationInfo(ConversationKey conversationKey, IMCallback<Conversation> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationInfo(conversationKey, callback);
    }

    public void deleteConversation(ConversationKey conversationKey, boolean clearCloudMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversation(conversationKey, clearCloudMessage, callback);
    }

    public void setConversationDraft(ConversationKey conversationKey, DraftMessage draftMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetConversationDraft(conversationKey, draftMessage, callback);
    }

    public void pinConversation(ConversationKey conversationKey, boolean isPinned, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativePinConversation(conversationKey, isPinned, callback);
    }

    public void getTotalUnreadMessageCount(IMCallback<Long> callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetTotalUnreadMessageCount(callback);
    }

    public void setCosSaveRegionForConversation(ConversationKey conversationKey, String cosSaveRegion, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetCosSaveRegionForConversation(conversationKey, cosSaveRegion, callback);
    }

    public void clearUnreadMessage(boolean clearC2CUnreadMessage, boolean clearGroupUnreadMessage, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeClearUnreadMessage(clearC2CUnreadMessage, clearGroupUnreadMessage, callback);
    }

    public void markConversation(List<ConversationKey> conversationKeyList, long mark_type, boolean enable_mark, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeMarkConversation(conversationKeyList, mark_type, enable_mark, callback);
    }

    public void setConversationCustomData(List<ConversationKey> conversationKeyList, String customData, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeSetConversationCustomData(conversationKeyList, customData, callback);
    }

    public void createConversationGroup(String group_name, List<ConversationKey> conversationKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeCreateConversationGroup(group_name, conversationKeyList, callback);
    }

    public void getConversationGroupList(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeGetConversationGroupList(callback);
    }

    public void deleteConversationGroup(String group_name, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversationGroup(group_name, callback);
    }

    public void renameConversationGroup(String old_name, String new_name, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeRenameConversationGroup(old_name, new_name, callback);
    }

    public void addConversationsToGroup(String group_name, List<ConversationKey> conversationKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeAddConversationsToGroup(group_name, conversationKeyList, callback);
    }

    public void deleteConversationsFromGroup(String group_name, List<ConversationKey> conversationKeyList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(6013, "sdk not init");
            }
            return;
        }
        this.nativeDeleteConversationsFromGroup(group_name, conversationKeyList, callback);
    }

    protected native void nativeSetConversationListener(ConversationListener var1);

    protected native void nativeGetConversationList(long var1, int var3, IMCallback var4);

    protected native void nativeGetConversationListByFilter(ConversationListFilter var1, IMCallback var2);

    protected native void nativeGetConversations(List<ConversationKey> var1, IMCallback var2);

    protected native void nativeGetConversationInfo(ConversationKey var1, IMCallback var2);

    protected native void nativeDeleteConversation(ConversationKey var1, boolean var2, IMCallback var3);

    protected native void nativeSetConversationDraft(ConversationKey var1, DraftMessage var2, IMCallback var3);

    protected native void nativePinConversation(ConversationKey var1, boolean var2, IMCallback var3);

    protected native void nativeGetTotalUnreadMessageCount(IMCallback var1);

    protected native void nativeSetCosSaveRegionForConversation(ConversationKey var1, String var2, IMCallback var3);

    protected native void nativeClearUnreadMessage(boolean var1, boolean var2, IMCallback var3);

    protected native void nativeMarkConversation(List<ConversationKey> var1, long var2, boolean var4, IMCallback var5);

    protected native void nativeSetConversationCustomData(List<ConversationKey> var1, String var2, IMCallback var3);

    protected native void nativeCreateConversationGroup(String var1, List<ConversationKey> var2, IMCallback var3);

    protected native void nativeGetConversationGroupList(IMCallback var1);

    protected native void nativeDeleteConversationGroup(String var1, IMCallback var2);

    protected native void nativeRenameConversationGroup(String var1, String var2, IMCallback var3);

    protected native void nativeAddConversationsToGroup(String var1, List<ConversationKey> var2, IMCallback var3);

    protected native void nativeDeleteConversationsFromGroup(String var1, List<ConversationKey> var2, IMCallback var3);

    private static class ConversationManagerHolder {
        private static final ConversationManager conversationManager = new ConversationManager();

        private ConversationManagerHolder() {
        }
    }
}

