/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.relationship.FriendInfo;
import com.tencent.imsdk.relationship.UserInfo;
import com.tencent.imsdk.v2.V2TIMUserFullInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class V2TIMFriendInfo
implements Serializable {
    private static final String FRIEND_PROFILE_TYPE_KEY_REMARK = "Tag_SNS_IM_Remark";
    private static final String FRIEND_PROFILE_TYPE_KEY_CUSTOM_PREFIX = "Tag_SNS_Custom_";
    public static final int V2TIM_FRIEND_TYPE_SINGLE = 1;
    public static final int V2TIM_FRIEND_TYPE_BOTH = 2;
    private FriendInfo friendInfo = new FriendInfo();
    private HashMap<String, Object> modifyFriendProfileHashMap = new HashMap();

    protected void setFriendInfo(FriendInfo friendInfo) {
        this.friendInfo = friendInfo;
    }

    HashMap<String, Object> getModifyFriendInfo() {
        return this.modifyFriendProfileHashMap;
    }

    public String getUserID() {
        return this.friendInfo.getUserInfo().getUserID();
    }

    public void setUserID(String userID) {
        this.friendInfo.getUserInfo().setUserID(userID);
    }

    public String getFriendRemark() {
        return this.friendInfo.getRemark();
    }

    public void setFriendRemark(String friendRemark) {
        this.friendInfo.setRemark(friendRemark);
        this.modifyFriendProfileHashMap.put(FRIEND_PROFILE_TYPE_KEY_REMARK, friendRemark);
    }

    public long getFriendAddTime() {
        return this.friendInfo.getAddTime();
    }

    public List<String> getFriendGroups() {
        return this.friendInfo.getFriendGroups();
    }

    public HashMap<String, byte[]> getFriendCustomInfo() {
        return this.friendInfo.getFriendCustomInfo();
    }

    public void setFriendCustomInfo(HashMap<String, byte[]> customHashMap) {
        if (customHashMap == null || customHashMap.size() == 0) {
            return;
        }
        if (this.modifyFriendProfileHashMap == null) {
            this.modifyFriendProfileHashMap = new HashMap();
        }
        if (customHashMap.entrySet() != null) {
            for (Map.Entry<String, byte[]> entry : customHashMap.entrySet()) {
                if (entry.getKey().contains(FRIEND_PROFILE_TYPE_KEY_CUSTOM_PREFIX)) {
                    this.modifyFriendProfileHashMap.put(entry.getKey(), new String(entry.getValue()));
                    continue;
                }
                this.modifyFriendProfileHashMap.put(FRIEND_PROFILE_TYPE_KEY_CUSTOM_PREFIX + entry.getKey(), new String(entry.getValue()));
            }
        }
    }

    public V2TIMUserFullInfo getUserProfile() {
        UserInfo userInfo = this.friendInfo.getUserInfo();
        V2TIMUserFullInfo v2TIMUserFullInfo = new V2TIMUserFullInfo();
        v2TIMUserFullInfo.setUserInfo(userInfo);
        return v2TIMUserFullInfo;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("V2TIMFriendInfo--->");
        HashMap<String, byte[]> friendCustomMap = this.getFriendCustomInfo();
        StringBuilder friendCustomInfoStringBuild = new StringBuilder();
        if (friendCustomMap != null) {
            friendCustomInfoStringBuild.append("\n");
            for (Map.Entry<String, byte[]> entry : friendCustomMap.entrySet()) {
                friendCustomInfoStringBuild.append(" |key:" + entry.getKey() + ", value:" + new String(entry.getValue())).append("\n");
            }
        }
        stringBuilder.append("userID:").append(this.getUserID()).append(", remark:").append(this.getFriendRemark()).append(", groupNames:").append(this.getFriendGroups()).append(", friendCustomInfo:").append(friendCustomInfoStringBuild.toString()).append(", V2TIMUserFullInfo:").append(this.getUserProfile() == null ? "" : this.getUserProfile().toString());
        return stringBuilder.toString();
    }
}

