package com.tencent.qcloud.tim.uikit.modules.search.model;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.List;

public class SearchDataBean implements Parcelable {
    private String title;
    private String subTitle;
    private String iconPath;
    private List<Object> converstionIcons;
    private int type;
    private int isSubTextMatch;

    private String userID;
    private String nickname;
    private String remark;
    private int isGroup;

    public SearchDataBean()
    {}

    public SearchDataBean(String title, String subTitle, String iconPath, List<Object> converstionIcons, int type, String userID, String nickname, String remark, int isGroup, int isSubTextMatch)
    {
        this.title = title;
        this.subTitle = subTitle;
        this.iconPath = iconPath;
        this.converstionIcons = converstionIcons;
        this.type = type;

        this.userID = userID;
        this.nickname = nickname;
        this.remark = remark;
        this.isGroup = isGroup;
        this.isSubTextMatch = isSubTextMatch;
    }

    public SearchDataBean(Parcel source) {
        title = source.readString();
        subTitle = source.readString();
        iconPath = source.readString();
        userID = source.readString();
        nickname = source.readString();
        remark = source.readString();

        type = source.readInt();
        isGroup = source.readInt();
        isSubTextMatch = source.readInt();

        // 读取list集合时,一定要先判断是否为Null.如果不判断,会出现null指针
        if (converstionIcons == null) {
            converstionIcons = new ArrayList<>();
        }
        source.readList(converstionIcons, SearchDataBean.class.getClassLoader());
    }

    public String getSubTitle()
    {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle)
    {
        this.subTitle = subTitle;
    }

    public String getIconPath()
    {
        return this.iconPath;
    }

    public void setIconPath(String iconPath)
    {
        this.iconPath = iconPath;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<Object> getConverstionIcons() {
        return converstionIcons;
    }

    public void setConverstionIcons(List<Object> converstionIcons) {
        this.converstionIcons = converstionIcons;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public String getUserID() {
        return userID;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public int getIsGroup() {
        return isGroup;
    }

    public void setIsGroup(int isGroup) {
        this.isGroup = isGroup;
    }

    public int getIsSubTextMatch() {
        return isSubTextMatch;
    }

    public void setSubTextMatch(int isSubTextMatch) {
        this.isSubTextMatch = isSubTextMatch;
    }

    @Override public int describeContents() {

        return 0;
    }
    //2、实现Parcelable接口的public void writeToParcel(Parcel dest, int flags)方法
    //通常进行重写
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        //把数据写入Parcel
        dest.writeString(title);
        dest.writeString(subTitle);
        dest.writeString(iconPath);
        dest.writeString(userID);
        dest.writeString(nickname);
        dest.writeString(remark);

        dest.writeInt(type);
        dest.writeInt(isGroup);
        dest.writeInt(isSubTextMatch);

        dest.writeList(converstionIcons);

    }
    //3、自定义类型中必须含有一个名称为CREATOR的静态成员，该成员对象要求实现Parcelable.Creator接口及其方法
    public static final Creator<SearchDataBean> CREATOR = new Creator<SearchDataBean>() {
        @Override
        public SearchDataBean createFromParcel(Parcel source) {
            //从Parcel中读取数据
            //此处read顺序依据write顺序
            /*final SearchDataBean searchDataBean = new SearchDataBean(source.readString(), source.readString(), source.readInt(), source.readString(), source.readList(SearchDataBean.class.getClassLoader()));
            return searchDataBean;*/

            return new SearchDataBean(source);
        }
        @Override
        public SearchDataBean[] newArray(int size) {

            return new SearchDataBean[size];
        }

    };
}
