/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxItemDecoration;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.tencent.imsdk.v2.V2TIMGroupMemberFullInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfoResult;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.liteav.login.ProfileManager;
import com.tencent.liteav.login.UserModel;
import com.tencent.liteav.trtcaudiocalldemo.ui.TRTCAudioCallActivity;
import com.tencent.liteav.trtcvideocalldemo.ui.TRTCVideoCallActivity;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.utils.SoftKeyBoardUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SelectContactActivity
extends AppCompatActivity {
    private static final String TAG = SelectContactActivity.class.getSimpleName();
    private static final String GROUP_ID = "group_id";
    private static final String CALL_TYPE = "call_type";
    public static final int RADIUS = 10;
    private TextView mCompleteBtn;
    private Toolbar mToolbar;
    private EditText mSearchEt;
    private RelativeLayout mGroupMemberLoadingView;
    private RecyclerView mSelectedMemberRv;
    private SelectedMemberListAdapter mSelectedMemberListAdapter;
    private List<UserModel> mSelectedModelList = new ArrayList<UserModel>();
    private Map<String, UserModel> mUserModelMap = new HashMap<String, UserModel>();
    private RecyclerView mGroupMemberListRv;
    private GroupMemberListAdapter mGroupMemberListAdapter;
    private List<ContactEntity> mUserModelList = new ArrayList<ContactEntity>();
    private Map<String, ContactEntity> mGroupMemberList = new HashMap<String, ContactEntity>();
    private UserModel mSelfModel;
    private String mGroupId;
    private int mCallType = 1;

    public static void start(Context context, String groupId, int type) {
        Intent starter = new Intent(context, SelectContactActivity.class);
        starter.putExtra(GROUP_ID, groupId);
        starter.putExtra(CALL_TYPE, type);
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.audiocall_activity_select_contact);
        this.mGroupId = this.getIntent().getStringExtra(GROUP_ID);
        this.mCallType = this.getIntent().getIntExtra(CALL_TYPE, 1);
        if (TextUtils.isEmpty((CharSequence)this.mGroupId)) {
            ToastUtil.toastShortMessage(this.getString(R.string.group_id_null));
            this.finish();
            return;
        }
        this.initView();
        this.mSelfModel = ProfileManager.getInstance().getUserModel();
        this.loadRecentSearch();
    }

    protected void onDestroy() {
        super.onDestroy();
    }

    private void initView() {
        this.mCompleteBtn = (TextView)this.findViewById(R.id.btn_complete);
        this.mToolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.mSearchEt = (EditText)this.findViewById(R.id.et_search);
        this.mGroupMemberLoadingView = (RelativeLayout)this.findViewById(R.id.rl_group_member_loading);
        this.mSelectedMemberRv = (RecyclerView)this.findViewById(R.id.rv_selected_member);
        FlexboxLayoutManager manager = new FlexboxLayoutManager((Context)this);
        FlexboxItemDecoration itemDecoration = new FlexboxItemDecoration((Context)this);
        itemDecoration.setDrawable(this.getResources().getDrawable(R.drawable.bg_divider));
        this.mSelectedMemberRv.addItemDecoration((RecyclerView.ItemDecoration)itemDecoration);
        this.mSelectedMemberRv.setLayoutManager((RecyclerView.LayoutManager)manager);
        this.mSelectedMemberListAdapter = new SelectedMemberListAdapter((Context)this, this.mSelectedModelList, new OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                if (position < SelectContactActivity.this.mSelectedModelList.size() && position >= 0) {
                    UserModel userModel = (UserModel)SelectContactActivity.this.mSelectedModelList.get(position);
                    SelectContactActivity.this.removeContact(userModel.userId);
                }
                SelectContactActivity.this.completeBtnEnable();
            }
        });
        this.mSelectedMemberRv.setAdapter((RecyclerView.Adapter)this.mSelectedMemberListAdapter);
        this.mGroupMemberListRv = (RecyclerView)this.findViewById(R.id.rv_group_member_list);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration((Context)this, 1);
        this.mGroupMemberListRv.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
        this.mGroupMemberListRv.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mGroupMemberListAdapter = new GroupMemberListAdapter((Context)this, this.mUserModelList, new OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                if (position < SelectContactActivity.this.mUserModelList.size() && position >= 0) {
                    ContactEntity entity = (ContactEntity)SelectContactActivity.this.mUserModelList.get(position);
                    if (!entity.isSelected) {
                        SelectContactActivity.this.addContact(entity);
                    } else {
                        SelectContactActivity.this.removeContact(entity.mUserModel.userId);
                    }
                    SelectContactActivity.this.completeBtnEnable();
                }
            }
        });
        this.mGroupMemberListRv.setAdapter((RecyclerView.Adapter)this.mGroupMemberListAdapter);
        this.mSearchEt.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    SelectContactActivity.this.search(v.getText().toString());
                    return true;
                }
                return false;
            }
        });
        this.mSearchEt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                SelectContactActivity.this.search(s.toString());
            }
        });
        this.mCompleteBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SelectContactActivity.this.mSelectedModelList.isEmpty()) {
                    ToastUtil.toastShortMessage(SelectContactActivity.this.getString(R.string.select_call_user));
                    return;
                }
                if (SelectContactActivity.this.mCallType == 1) {
                    TRTCAudioCallActivity.startCallSomePeople((Context)SelectContactActivity.this, SelectContactActivity.this.mSelectedModelList, SelectContactActivity.this.mGroupId);
                } else {
                    TRTCVideoCallActivity.startCallSomePeople((Context)SelectContactActivity.this, SelectContactActivity.this.mSelectedModelList, SelectContactActivity.this.mGroupId);
                }
                SelectContactActivity.this.finish();
            }
        });
        this.completeBtnEnable();
        this.mToolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectContactActivity.this.finish();
            }
        });
    }

    protected void onPause() {
        super.onPause();
        SoftKeyBoardUtil.hideKeyBoard(this.mSearchEt);
    }

    private void loadRecentSearch() {
        this.mGroupMemberListRv.setVisibility(8);
        this.mGroupMemberLoadingView.setVisibility(0);
        this.loadGroupMembers(0L, new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                SelectContactActivity.this.mGroupMemberListRv.setVisibility(0);
                SelectContactActivity.this.mGroupMemberLoadingView.setVisibility(8);
                SelectContactActivity.this.mUserModelList.clear();
                SelectContactActivity.this.mUserModelList.addAll(SelectContactActivity.this.mGroupMemberList.values());
                SelectContactActivity.this.mGroupMemberListAdapter.notifyDataSetChanged();
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                SelectContactActivity.this.mGroupMemberListRv.setVisibility(0);
                SelectContactActivity.this.mGroupMemberLoadingView.setVisibility(8);
                SelectContactActivity.this.mUserModelList.clear();
                SelectContactActivity.this.mGroupMemberListAdapter.notifyDataSetChanged();
                TUIKitLog.e(TAG, "loadGroupMembers failed, module:" + module + "|errCode:" + errCode + "|errMsg:" + errMsg);
            }
        });
    }

    public void loadGroupMembers(long nextSeq, final IUIKitCallBack callBack) {
        V2TIMManager.getGroupManager().getGroupMemberList(this.mGroupId, 0, nextSeq, (V2TIMValueCallback)new V2TIMValueCallback<V2TIMGroupMemberInfoResult>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "loadGroupMembers failed, code: " + code + "|desc: " + desc);
                callBack.onError(SelectContactActivity.this.mGroupId, code, desc);
            }

            public void onSuccess(V2TIMGroupMemberInfoResult v2TIMGroupMemberInfoResult) {
                for (int i = 0; i < v2TIMGroupMemberInfoResult.getMemberInfoList().size(); ++i) {
                    V2TIMGroupMemberFullInfo info = (V2TIMGroupMemberFullInfo)v2TIMGroupMemberInfoResult.getMemberInfoList().get(i);
                    if (TextUtils.equals((CharSequence)info.getUserID(), (CharSequence)((SelectContactActivity)SelectContactActivity.this).mSelfModel.userId)) continue;
                    UserModel userModel = new UserModel();
                    userModel.userId = info.getUserID();
                    userModel.userName = TextUtils.isEmpty((CharSequence)info.getNameCard()) ? info.getUserID() : info.getNameCard();
                    userModel.userAvatar = info.getFaceUrl();
                    ContactEntity entity = new ContactEntity();
                    entity.isSelected = false;
                    entity.mUserModel = userModel;
                    SelectContactActivity.this.mGroupMemberList.put(entity.mUserModel.userId, entity);
                }
                if (v2TIMGroupMemberInfoResult.getNextSeq() != 0L) {
                    SelectContactActivity.this.loadGroupMembers(v2TIMGroupMemberInfoResult.getNextSeq(), callBack);
                } else {
                    callBack.onSuccess(SelectContactActivity.this.mGroupId);
                }
            }
        });
    }

    private void search(String id2) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            this.mUserModelList.clear();
            this.mUserModelList.addAll(this.mGroupMemberList.values());
            this.mGroupMemberListAdapter.notifyDataSetChanged();
            return;
        }
        id2 = id2.toLowerCase();
        this.mUserModelList.clear();
        for (ContactEntity entity : this.mGroupMemberList.values()) {
            if (!entity.mUserModel.userName.toLowerCase().contains(id2) && !entity.mUserModel.userId.toLowerCase().contains(id2)) continue;
            this.mUserModelList.add(entity);
        }
        this.mGroupMemberListAdapter.notifyDataSetChanged();
    }

    private void removeContact(String userId) {
        if (this.mUserModelMap.containsKey(userId)) {
            UserModel model = this.mUserModelMap.remove(userId);
            this.mSelectedModelList.remove(model);
            ContactEntity recentEntity = this.mGroupMemberList.get(userId);
            if (recentEntity != null) {
                recentEntity.isSelected = false;
            }
            for (ContactEntity entity : this.mUserModelList) {
                if (!entity.mUserModel.userId.equals(userId)) continue;
                entity.isSelected = false;
                break;
            }
        }
        this.mGroupMemberListAdapter.notifyDataSetChanged();
        this.mSelectedMemberListAdapter.notifyDataSetChanged();
    }

    private void completeBtnEnable() {
        this.mCompleteBtn.setEnabled(!this.mSelectedModelList.isEmpty());
    }

    private void addContact(ContactEntity entity) {
        String userId = entity.mUserModel.userId;
        if (userId.equals(this.mSelfModel.userId)) {
            ToastUtil.toastShortMessage(this.getString(R.string.add_no_me));
            return;
        }
        if (!this.mUserModelMap.containsKey(userId)) {
            this.mUserModelMap.put(userId, entity.mUserModel);
            this.mSelectedModelList.add(entity.mUserModel);
        }
        entity.isSelected = true;
        this.mGroupMemberListAdapter.notifyDataSetChanged();
        this.mSelectedMemberListAdapter.notifyDataSetChanged();
    }

    public static class ContactEntity {
        public UserModel mUserModel;
        public boolean isSelected;
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }

    public static class GroupMemberListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private static final String TAG = GroupMemberListAdapter.class.getSimpleName();
        private Context context;
        private List<ContactEntity> list;
        private OnItemClickListener onItemClickListener;

        public GroupMemberListAdapter(Context context, List<ContactEntity> list, OnItemClickListener onItemClickListener) {
            this.context = context;
            this.list = list;
            this.onItemClickListener = onItemClickListener;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            Context context = parent.getContext();
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            View view = inflater.inflate(R.layout.audiocall_item_select_contact, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            ContactEntity item = this.list.get(position);
            holder.bind(item, this.onItemClickListener);
        }

        public int getItemCount() {
            return this.list.size();
        }

        public static class ViewHolder
        extends RecyclerView.ViewHolder {
            private Button mContactCb;
            private ImageView mAvatarImg;
            private TextView mUserNameTv;

            public ViewHolder(View itemView) {
                super(itemView);
                this.mContactCb = (Button)itemView.findViewById(R.id.cb_contact);
                this.mAvatarImg = (ImageView)itemView.findViewById(R.id.img_avatar);
                this.mUserNameTv = (TextView)itemView.findViewById(R.id.tv_user_name);
            }

            public void bind(ContactEntity model, final OnItemClickListener listener) {
                GlideEngine.loadCornerImage(this.mAvatarImg, model.mUserModel.userAvatar, null, 10.0f);
                this.mUserNameTv.setText((CharSequence)model.mUserModel.userName);
                if (model.isSelected) {
                    this.mContactCb.setActivated(true);
                } else {
                    this.mContactCb.setActivated(false);
                }
                this.mContactCb.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        listener.onItemClick(ViewHolder.this.getLayoutPosition());
                    }
                });
                this.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        listener.onItemClick(ViewHolder.this.getLayoutPosition());
                    }
                });
            }
        }
    }

    public static class SelectedMemberListAdapter
    extends RecyclerView.Adapter<ViewHolder> {
        private static final String TAG = SelectedMemberListAdapter.class.getSimpleName();
        private Context context;
        private List<UserModel> list;
        private OnItemClickListener onItemClickListener;

        public SelectedMemberListAdapter(Context context, List<UserModel> list, OnItemClickListener onItemClickListener) {
            this.context = context;
            this.list = list;
            this.onItemClickListener = onItemClickListener;
        }

        public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            Context context = parent.getContext();
            LayoutInflater inflater = LayoutInflater.from((Context)context);
            View view = inflater.inflate(R.layout.audiocall_item_selected_contact, parent, false);
            return new ViewHolder(view);
        }

        public void onBindViewHolder(ViewHolder holder, int position) {
            UserModel item = this.list.get(position);
            holder.bind(item, this.onItemClickListener);
        }

        public int getItemCount() {
            return this.list.size();
        }

        public static class ViewHolder
        extends RecyclerView.ViewHolder {
            private ImageView mAvatarImg;

            public ViewHolder(View itemView) {
                super(itemView);
                this.initView(itemView);
            }

            public void bind(UserModel model, final OnItemClickListener listener) {
                GlideEngine.loadCornerImage(this.mAvatarImg, model.userAvatar, null, 10.0f);
                this.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        listener.onItemClick(ViewHolder.this.getLayoutPosition());
                    }
                });
            }

            private void initView(@NonNull View itemView) {
                this.mAvatarImg = (ImageView)itemView.findViewById(R.id.img_avatar);
            }
        }
    }
}

