/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.model;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMSignalingInfo;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CallModel
implements Cloneable,
Serializable {
    private static final String TAG = CallModel.class.getSimpleName();
    public static final int VIDEO_CALL_ACTION_ERROR = -1;
    public static final int VIDEO_CALL_ACTION_UNKNOWN = 0;
    public static final int VIDEO_CALL_ACTION_DIALING = 1;
    public static final int VIDEO_CALL_ACTION_SPONSOR_CANCEL = 2;
    public static final int VIDEO_CALL_ACTION_REJECT = 3;
    public static final int VIDEO_CALL_ACTION_SPONSOR_TIMEOUT = 4;
    public static final int VIDEO_CALL_ACTION_HANGUP = 5;
    public static final int VIDEO_CALL_ACTION_LINE_BUSY = 6;
    public static final int VIDEO_CALL_ACTION_ACCEPT = 7;
    public static String SIGNALING_EXTRA_VALUE_BUSINESS_ID = "av_call";
    public static String SIGNALING_EXTRA_KEY_BUSINESS_ID = "businessID";
    public static String SIGNALING_EXTRA_KEY_CALL_TYPE = "call_type";
    public static String SIGNALING_EXTRA_KEY_ROOM_ID = "room_id";
    public static String SIGNALING_EXTRA_KEY_LINE_BUSY = "line_busy";
    public static String SIGNALING_EXTRA_KEY_CALL_END = "call_end";
    public static String SIGNALING_EXTRA_KEY_VERSION = "version";
    @SerializedName(value="businessID")
    public String bussinessID;
    @SerializedName(value="version")
    public int version = 0;
    @SerializedName(value="call_id")
    public String callId;
    @SerializedName(value="room_id")
    public int roomId = 0;
    @SerializedName(value="group_id")
    public String groupId = "";
    @SerializedName(value="action")
    public int action = 0;
    @SerializedName(value="call_type")
    public int callType = 0;
    @SerializedName(value="invited_list")
    public List<String> invitedList;
    @SerializedName(value="duration")
    public int duration = 0;
    @SerializedName(value="code")
    public int code = 0;
    public long timestamp;
    public String sender;
    public int timeout;
    public String data;

    public Object clone() {
        CallModel callModel = null;
        try {
            callModel = (CallModel)super.clone();
            if (this.invitedList != null) {
                callModel.invitedList = new ArrayList<String>(this.invitedList);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            TUIKitLog.w(TAG, "clone: " + e.getLocalizedMessage());
        }
        return callModel;
    }

    public static CallModel convert2VideoCallData(V2TIMMessage msg) {
        V2TIMSignalingInfo signalingInfo = V2TIMManager.getSignalingManager().getSignalingInfo(msg);
        if (signalingInfo == null) {
            return null;
        }
        CallModel callModel = new CallModel();
        try {
            Map extraMap = (Map)new Gson().fromJson(signalingInfo.getData(), Map.class);
            if (extraMap != null && extraMap.containsKey(SIGNALING_EXTRA_KEY_VERSION) && ((Double)extraMap.get(SIGNALING_EXTRA_KEY_VERSION)).intValue() > TUIKitConstants.version) {
                callModel.action = 0;
                return callModel;
            }
            callModel.data = signalingInfo.getData();
            if (extraMap != null) {
                callModel.bussinessID = (String)extraMap.get(SIGNALING_EXTRA_KEY_BUSINESS_ID);
            }
            if (signalingInfo.getActionType() == 1 && extraMap != null) {
                callModel.groupId = signalingInfo.getGroupID();
                callModel.timestamp = msg.getTimestamp();
                callModel.version = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_VERSION)).intValue();
                if (extraMap.containsKey(SIGNALING_EXTRA_KEY_CALL_END)) {
                    callModel.action = 5;
                    callModel.duration = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_CALL_END)).intValue();
                } else {
                    callModel.action = 1;
                    callModel.callId = signalingInfo.getInviteID();
                    callModel.sender = signalingInfo.getInviter();
                    callModel.invitedList = signalingInfo.getInviteeList();
                    callModel.callType = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_CALL_TYPE)).intValue();
                    callModel.roomId = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_ROOM_ID)).intValue();
                }
            } else if (signalingInfo.getActionType() == 2) {
                callModel.action = 2;
                callModel.groupId = signalingInfo.getGroupID();
                callModel.callId = signalingInfo.getInviteID();
                callModel.version = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_VERSION)).intValue();
            } else if (signalingInfo.getActionType() == 4 && extraMap != null) {
                callModel.groupId = signalingInfo.getGroupID();
                callModel.callId = signalingInfo.getInviteID();
                callModel.invitedList = signalingInfo.getInviteeList();
                callModel.version = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_VERSION)).intValue();
                callModel.action = extraMap.containsKey(SIGNALING_EXTRA_KEY_LINE_BUSY) ? 6 : 3;
            } else if (signalingInfo.getActionType() == 5) {
                callModel.action = 4;
                callModel.groupId = signalingInfo.getGroupID();
                callModel.callId = signalingInfo.getInviteID();
                callModel.invitedList = signalingInfo.getInviteeList();
            } else if (signalingInfo.getActionType() == 3) {
                callModel.action = 7;
                callModel.groupId = signalingInfo.getGroupID();
                callModel.callId = signalingInfo.getInviteID();
                callModel.invitedList = signalingInfo.getInviteeList();
                callModel.version = ((Double)extraMap.get(SIGNALING_EXTRA_KEY_VERSION)).intValue();
            }
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "convert2VideoCallData exception:" + e);
        }
        return callModel;
    }

    public String toString() {
        return "CallModel{version=" + this.version + ", callId='" + this.callId + '\'' + ", roomId=" + this.roomId + ", groupId='" + this.groupId + '\'' + ", action=" + this.action + ", callType=" + this.callType + ", invitedList=" + this.invitedList + ", duration=" + this.duration + ", code=" + this.code + ", timestamp=" + this.timestamp + ", sender=" + this.sender + '}';
    }
}

