/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.model;

import android.text.TextUtils;
import com.google.gson.Gson;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMSignalingInfo;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.Serializable;
import java.util.Map;
import org.json.JSONObject;

public class LiveModel
implements Cloneable,
Serializable {
    private static final String TAG = LiveModel.class.getSimpleName();
    public static final String KEY_VERSION = "version";
    public static final String KEY_ACTION = "action";
    public static final String KEY_BUSINESS_ID = "businessID";
    public static final String VALUE_PROTOCOL_VERSION = "1.0.0";
    public static final String VALUE_BUSINESS_ID = "liveRoom";
    public static final int CODE_UNKNOWN = 0;
    public static final int CODE_REQUEST_JOIN_ANCHOR = 100;
    public static final int CODE_RESPONSE_JOIN_ANCHOR = 101;
    public static final int CODE_KICK_OUT_JOIN_ANCHOR = 102;
    public static final int CODE_RESPONSE_KICK_OUT_JOIN_ANCHOR = 103;
    public static final int CODE_CANCEL_REQUEST_JOIN_ANCHOR = 104;
    public static final int CODE_NOTIFY_JOIN_ANCHOR_STREAM = 105;
    public static final int CODE_REQUEST_ROOM_PK = 200;
    public static final int CODE_RESPONSE_PK = 201;
    public static final int CODE_QUIT_ROOM_PK = 202;
    public static final int CODE_RESPONSE_QUIT_ROOM_PK = 203;
    public static final int CODE_CANCEL_REQUEST_ROOM_PK = 204;
    public static final int CODE_ROOM_TEXT_MSG = 300;
    public static final int CODE_ROOM_CUSTOM_MSG = 301;
    public static final int CODE_UPDATE_GROUP_INFO = 400;
    public int actionType;
    public String message;
    public String data;
    public String version;

    public static LiveModel convert2LiveData(V2TIMMessage msg) {
        V2TIMSignalingInfo signalingInfo = V2TIMManager.getSignalingManager().getSignalingInfo(msg);
        if (signalingInfo == null) {
            return null;
        }
        LiveModel liveModel = new LiveModel();
        liveModel.message = TUIKit.getAppContext().getString(R.string.invalid_command);
        try {
            int actionType;
            Map extraMap = (Map)new Gson().fromJson(signalingInfo.getData(), Map.class);
            liveModel.data = signalingInfo.getData();
            liveModel.version = (String)extraMap.get(KEY_VERSION);
            int code = ((Double)extraMap.get(KEY_ACTION)).intValue();
            liveModel.actionType = actionType = signalingInfo.getActionType();
            switch (code) {
                case 100: {
                    liveModel.message = TUIKit.getAppContext().getString(R.string.request_online);
                    break;
                }
                case 101: {
                    if (actionType == 4) {
                        liveModel.message = TUIKit.getAppContext().getString(R.string.reject_request_online);
                        break;
                    }
                    if (actionType != 3) break;
                    liveModel.message = TUIKit.getAppContext().getString(R.string.agree_request_online);
                    break;
                }
                case 102: {
                    liveModel.message = TUIKit.getAppContext().getString(R.string.request_close_online);
                    break;
                }
                case 103: {
                    liveModel.message = TUIKit.getAppContext().getString(R.string.close_online);
                    break;
                }
                case 200: {
                    if (actionType != 1) break;
                    liveModel.message = TUIKit.getAppContext().getString(R.string.request_pk);
                    break;
                }
                case 201: {
                    if (actionType == 4) {
                        liveModel.message = TUIKit.getAppContext().getString(R.string.reject_request_pk);
                        break;
                    }
                    if (actionType != 3) break;
                    liveModel.message = TUIKit.getAppContext().getString(R.string.agree_request_pk);
                    break;
                }
                case 202: {
                    liveModel.message = TUIKit.getAppContext().getString(R.string.exit_pk);
                }
            }
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "convert2LiveData exception:" + e);
        }
        return liveModel;
    }

    public static boolean isLiveRoomSignal(String data) {
        if (TextUtils.isEmpty((CharSequence)data)) {
            return false;
        }
        try {
            JSONObject object = new JSONObject(data);
            String businessId = object.getString(KEY_BUSINESS_ID);
            return VALUE_BUSINESS_ID.equals(businessId);
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "isLiveRoomSignal exception:" + e);
            return false;
        }
    }
}

