/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.model;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMOfflinePushInfo;
import com.tencent.imsdk.v2.V2TIMSendCallback;
import com.tencent.imsdk.v2.V2TIMSignalingListener;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.model.CallModel;
import com.tencent.liteav.model.ITRTCAVCall;
import com.tencent.liteav.model.TRTCAVCallListener;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.chat.base.OfflineMessageBean;
import com.tencent.qcloud.tim.uikit.modules.chat.base.OfflineMessageContainerBean;
import com.tencent.qcloud.tim.uikit.modules.message.MessageCustom;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.json.JSONObject;

public class TRTCAVCallImpl
implements ITRTCAVCall {
    private static final String TAG = "TRTCAVCallImpl";
    public static final int TIME_OUT_COUNT = 30;
    private static final int ROOM_ID_MIN = 1;
    private static final int ROOM_ID_MAX = Integer.MAX_VALUE;
    private static ITRTCAVCall sITRTCAVCall;
    private final Context mContext;
    private TRTCCloud mTRTCCloud;
    private V2TIMManager mTIMManager;
    private String mCurUserId = "";
    private int mSdkAppId;
    private String mCurUserSig;
    private boolean isOnCalling = false;
    private String mCurCallID = "";
    private int mCurRoomID = 0;
    private boolean mIsInRoom = false;
    private long mEnterRoomTime = 0L;
    private List<String> mCurInvitedList = new ArrayList<String>();
    private Set<String> mCurRoomRemoteUserSet = new HashSet<String>();
    private String mCurSponsorForMe = "";
    private boolean mIsRespSponsor = false;
    private int mCurCallType = 0;
    private String mCurGroupId = "";
    private CallModel mLastCallModel = new CallModel();
    private TRTCInteralListenerManager mTRTCInteralListenerManager;
    private boolean mIsUseFrontCamera;
    private boolean mWaitingLastActivityFinished;
    private V2TIMSignalingListener mTIMSignallingListener = new V2TIMSignalingListener(){

        public void onReceiveNewInvitation(String inviteID, String inviter, String groupID, List<String> inviteeList, String data) {
            if (!TRTCAVCallImpl.this.isCallingData(data)) {
                return;
            }
            TRTCAVCallImpl.this.processInvite(inviteID, inviter, groupID, inviteeList, data);
        }

        public void onInviteeAccepted(String inviteID, String invitee, String data) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onInviteeAccepted inviteID:" + inviteID + ", invitee:" + invitee);
            if (!TRTCAVCallImpl.this.isCallingData(data)) {
                return;
            }
            TRTCAVCallImpl.this.mCurInvitedList.remove(invitee);
        }

        public void onInviteeRejected(String inviteID, String invitee, String data) {
            if (!TRTCAVCallImpl.this.isCallingData(data)) {
                return;
            }
            if (TRTCAVCallImpl.this.mCurCallID.equals(inviteID)) {
                try {
                    Map rejectData = (Map)new Gson().fromJson(data, Map.class);
                    TRTCAVCallImpl.this.mCurInvitedList.remove(invitee);
                    if (rejectData != null && rejectData.containsKey(CallModel.SIGNALING_EXTRA_KEY_LINE_BUSY)) {
                        if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                            TRTCAVCallImpl.this.mTRTCInteralListenerManager.onLineBusy(invitee);
                        }
                    } else if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                        TRTCAVCallImpl.this.mTRTCInteralListenerManager.onReject(invitee);
                    }
                    TRTCAVCallImpl.this.preExitRoom(null);
                }
                catch (JsonSyntaxException e) {
                    TUIKitLog.e(TRTCAVCallImpl.TAG, "onReceiveNewInvitation JsonSyntaxException:" + (Object)((Object)e));
                }
            }
        }

        public void onInvitationCancelled(String inviteID, String inviter, String data) {
            if (!TRTCAVCallImpl.this.isCallingData(data)) {
                return;
            }
            if (TRTCAVCallImpl.this.mCurCallID.equals(inviteID)) {
                TRTCAVCallImpl.this.stopCall();
                if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                    TRTCAVCallImpl.this.mTRTCInteralListenerManager.onCallingCancel();
                }
            }
        }

        public void onInvitationTimeout(String inviteID, List<String> inviteeList) {
            if (inviteID != null && !inviteID.equals(TRTCAVCallImpl.this.mCurCallID)) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)TRTCAVCallImpl.this.mCurSponsorForMe)) {
                for (String userID : inviteeList) {
                    if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                        TRTCAVCallImpl.this.mTRTCInteralListenerManager.onNoResp(userID);
                    }
                    TRTCAVCallImpl.this.mCurInvitedList.remove(userID);
                }
            } else {
                if (inviteeList.contains(TRTCAVCallImpl.this.mCurUserId)) {
                    TRTCAVCallImpl.this.stopCall();
                    if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                        TRTCAVCallImpl.this.mTRTCInteralListenerManager.onCallingTimeout();
                    }
                }
                TRTCAVCallImpl.this.mCurInvitedList.removeAll(inviteeList);
            }
            TRTCAVCallImpl.this.preExitRoom(null);
        }
    };
    private TRTCCloudListener mTRTCCloudListener = new TRTCCloudListener(){

        public void onError(int errCode, String errMsg, Bundle extraInfo) {
            TUIKitLog.e(TRTCAVCallImpl.TAG, "onError: " + errCode + " " + errMsg);
            TRTCAVCallImpl.this.stopCall();
            if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                TRTCAVCallImpl.this.mTRTCInteralListenerManager.onError(errCode, errMsg);
            }
        }

        public void onEnterRoom(long result) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onEnterRoom result:" + result);
            if (result < 0L) {
                TRTCAVCallImpl.this.stopCall();
            } else {
                TRTCAVCallImpl.this.mIsInRoom = true;
            }
        }

        public void onExitRoom(int reason) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onExitRoom reason:" + reason);
        }

        public void onRemoteUserEnterRoom(String userId) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onRemoteUserEnterRoom userId:" + userId);
            TRTCAVCallImpl.this.mCurRoomRemoteUserSet.add(userId);
            TRTCAVCallImpl.this.mEnterRoomTime = V2TIMManager.getInstance().getServerTime();
            if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                TRTCAVCallImpl.this.mTRTCInteralListenerManager.onUserEnter(userId);
            }
        }

        public void onRemoteUserLeaveRoom(String userId, int reason) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onRemoteUserLeaveRoom userId:" + userId + ", reason:" + reason);
            TRTCAVCallImpl.this.mCurRoomRemoteUserSet.remove(userId);
            TRTCAVCallImpl.this.mCurInvitedList.remove(userId);
            if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                TRTCAVCallImpl.this.mTRTCInteralListenerManager.onUserLeave(userId);
            }
            TRTCAVCallImpl.this.preExitRoom(userId);
        }

        public void onUserVideoAvailable(String userId, boolean available) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onUserVideoAvailable userId:" + userId + ", available:" + available);
            if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                TRTCAVCallImpl.this.mTRTCInteralListenerManager.onUserVideoAvailable(userId, available);
            }
        }

        public void onUserAudioAvailable(String userId, boolean available) {
            TUIKitLog.d(TRTCAVCallImpl.TAG, "onUserAudioAvailable userId:" + userId + ", available:" + available);
            if (TRTCAVCallImpl.this.mTRTCInteralListenerManager != null) {
                TRTCAVCallImpl.this.mTRTCInteralListenerManager.onUserAudioAvailable(userId, available);
            }
        }

        public void onUserVoiceVolume(ArrayList<TRTCCloudDef.TRTCVolumeInfo> userVolumes, int totalVolume) {
            HashMap<String, Integer> volumeMaps = new HashMap<String, Integer>();
            for (TRTCCloudDef.TRTCVolumeInfo info : userVolumes) {
                String userId = "";
                userId = info.userId == null ? TRTCAVCallImpl.this.mCurUserId : info.userId;
                volumeMaps.put(userId, info.volume);
            }
            TRTCAVCallImpl.this.mTRTCInteralListenerManager.onUserVoiceVolume(volumeMaps);
        }
    };

    public boolean isWaitingLastActivityFinished() {
        return this.mWaitingLastActivityFinished;
    }

    public void setWaitingLastActivityFinished(boolean waiting) {
        this.mWaitingLastActivityFinished = waiting;
    }

    private boolean isCallingData(String data) {
        try {
            JSONObject jsonObject = new JSONObject(data);
            if (jsonObject.has(CallModel.SIGNALING_EXTRA_KEY_BUSINESS_ID) && jsonObject.getString(CallModel.SIGNALING_EXTRA_KEY_BUSINESS_ID).equals(CallModel.SIGNALING_EXTRA_VALUE_BUSINESS_ID)) {
                return true;
            }
            if (jsonObject.has(CallModel.SIGNALING_EXTRA_KEY_CALL_TYPE)) {
                return true;
            }
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "isCallingData json parse error");
        }
        return false;
    }

    public void processInvite(String inviteID, String inviter, String groupID, List<String> inviteeList, String data) {
        CallModel callModel = new CallModel();
        callModel.callId = inviteID;
        callModel.groupId = groupID;
        callModel.action = 1;
        callModel.invitedList = inviteeList;
        Map extraMap = null;
        try {
            extraMap = (Map)new Gson().fromJson(data, Map.class);
            if (extraMap == null) {
                TUIKitLog.e(TAG, "onReceiveNewInvitation extraMap is null, ignore");
                return;
            }
            if (extraMap.containsKey(CallModel.SIGNALING_EXTRA_KEY_VERSION)) {
                callModel.version = ((Double)extraMap.get(CallModel.SIGNALING_EXTRA_KEY_VERSION)).intValue();
            }
            if (extraMap.containsKey(CallModel.SIGNALING_EXTRA_KEY_CALL_TYPE)) {
                this.mCurCallType = callModel.callType = ((Double)extraMap.get(CallModel.SIGNALING_EXTRA_KEY_CALL_TYPE)).intValue();
            }
            if (extraMap.containsKey(CallModel.SIGNALING_EXTRA_KEY_CALL_END)) {
                this.preExitRoom(null);
                return;
            }
            if (extraMap.containsKey(CallModel.SIGNALING_EXTRA_KEY_ROOM_ID)) {
                callModel.roomId = ((Double)extraMap.get(CallModel.SIGNALING_EXTRA_KEY_ROOM_ID)).intValue();
            }
        }
        catch (JsonSyntaxException e) {
            TUIKitLog.e(TAG, "onReceiveNewInvitation JsonSyntaxException:" + (Object)((Object)e));
        }
        this.handleDialing(callModel, inviter);
        if (this.mCurCallID.equals(callModel.callId)) {
            this.mLastCallModel = (CallModel)callModel.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITRTCAVCall sharedInstance(Context context) {
        Class<TRTCAVCallImpl> clazz = TRTCAVCallImpl.class;
        synchronized (TRTCAVCallImpl.class) {
            if (sITRTCAVCall == null) {
                sITRTCAVCall = new TRTCAVCallImpl(context);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sITRTCAVCall;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroySharedInstance() {
        Class<TRTCAVCallImpl> clazz = TRTCAVCallImpl.class;
        synchronized (TRTCAVCallImpl.class) {
            if (sITRTCAVCall != null) {
                sITRTCAVCall.destroy();
                sITRTCAVCall = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public TRTCAVCallImpl(Context context) {
        this.mContext = context;
        this.mTIMManager = V2TIMManager.getInstance();
        this.mTRTCCloud = TRTCCloud.sharedInstance((Context)context);
        this.mTRTCInteralListenerManager = new TRTCInteralListenerManager();
        this.mLastCallModel.version = TUIKitConstants.version;
    }

    private void startCall() {
        this.isOnCalling = true;
    }

    public void stopCall() {
        this.isOnCalling = false;
        this.mIsInRoom = false;
        this.mEnterRoomTime = 0L;
        this.mCurCallID = "";
        this.mCurRoomID = 0;
        this.mCurInvitedList.clear();
        this.mCurRoomRemoteUserSet.clear();
        this.mCurSponsorForMe = "";
        this.mLastCallModel = new CallModel();
        this.mLastCallModel.version = TUIKitConstants.version;
        this.mIsRespSponsor = false;
        this.mCurGroupId = "";
        this.mCurCallType = 0;
    }

    @Override
    public void init() {
    }

    public void handleDialing(CallModel callModel, String user) {
        if (!TextUtils.isEmpty((CharSequence)this.mCurCallID)) {
            if (this.isOnCalling && callModel.invitedList.contains(this.mCurUserId)) {
                this.sendModel(user, 6, callModel);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCurGroupId) && !TextUtils.isEmpty((CharSequence)callModel.groupId) && this.mCurGroupId.equals(callModel.groupId)) {
                this.mCurInvitedList.addAll(callModel.invitedList);
                HashSet<String> set = new HashSet<String>();
                set.addAll(this.mCurInvitedList);
                this.mCurInvitedList = new ArrayList<String>(set);
                if (this.mTRTCInteralListenerManager != null) {
                    this.mTRTCInteralListenerManager.onGroupCallInviteeListUpdate(this.mCurInvitedList);
                }
                return;
            }
        }
        if (!TextUtils.isEmpty((CharSequence)callModel.groupId) && !callModel.invitedList.contains(this.mCurUserId)) {
            return;
        }
        this.startCall();
        this.mCurCallID = callModel.callId;
        this.mCurRoomID = callModel.roomId;
        this.mCurCallType = callModel.callType;
        this.mCurSponsorForMe = user;
        this.mCurGroupId = callModel.groupId;
        String cid = this.mCurCallID;
        callModel.invitedList.remove(this.mCurUserId);
        List<String> onInvitedUserListParam = callModel.invitedList;
        if (!TextUtils.isEmpty((CharSequence)this.mCurGroupId)) {
            this.mCurInvitedList.addAll(callModel.invitedList);
        }
        if (this.mTRTCInteralListenerManager != null) {
            this.mTRTCInteralListenerManager.onInvited(user, onInvitedUserListParam, !TextUtils.isEmpty((CharSequence)this.mCurGroupId), this.mCurCallType);
        }
    }

    @Override
    public void destroy() {
        V2TIMManager.getSignalingManager().removeSignalingListener(this.mTIMSignallingListener);
        this.mTRTCCloud.stopLocalPreview();
        this.mTRTCCloud.stopLocalAudio();
        this.mTRTCCloud.exitRoom();
    }

    @Override
    public void addListener(TRTCAVCallListener listener) {
        this.mTRTCInteralListenerManager.addListenter(listener);
    }

    @Override
    public void removeListener(TRTCAVCallListener listener) {
        this.mTRTCInteralListenerManager.removeListenter(listener);
    }

    @Override
    public void login(int sdkAppId, String userId, String userSign, ITRTCAVCall.ActionCallBack callback) {
        TUIKitLog.i(TAG, "startTUIKitLogin, sdkAppId:" + sdkAppId + " userId:" + userId + " sign is empty:" + TextUtils.isEmpty((CharSequence)userSign));
        if (sdkAppId == 0 || TextUtils.isEmpty((CharSequence)userId) || TextUtils.isEmpty((CharSequence)userSign)) {
            TUIKitLog.e(TAG, "startTUIKitLogin fail. params invalid.");
            if (callback != null) {
                callback.onError(-1, "login fail, params is invalid.");
            }
            return;
        }
        this.mSdkAppId = sdkAppId;
        V2TIMManager.getSignalingManager().addSignalingListener(this.mTIMSignallingListener);
        String loginUser = this.mTIMManager.getLoginUser();
        if (loginUser != null && loginUser.equals(userId)) {
            TUIKitLog.d(TAG, TUIKit.getAppContext().getString(R.string.im_logined) + loginUser);
            this.mCurUserId = loginUser;
            this.mCurUserSig = userSign;
            if (callback != null) {
                callback.onSuccess();
            }
        } else if (callback != null) {
            callback.onError(6014, "not login im");
        }
    }

    @Override
    public void logout(ITRTCAVCall.ActionCallBack callBack) {
        this.stopCall();
        this.exitRoom();
    }

    @Override
    public void call(String userId, int type) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(userId);
        this.internalCall(list, type, "");
    }

    @Override
    public void groupCall(List<String> userIdList, int type, String groupId) {
        if (TRTCAVCallImpl.isCollectionEmpty(userIdList)) {
            return;
        }
        this.internalCall(userIdList, type, groupId);
    }

    private void internalCall(List<String> userIdList, int type, String groupId) {
        boolean isGroupCall;
        boolean bl = isGroupCall = !TextUtils.isEmpty((CharSequence)groupId);
        if (!this.isOnCalling) {
            this.mCurRoomID = TRTCAVCallImpl.generateRoomID();
            this.mCurGroupId = groupId;
            this.mCurCallType = type;
            this.enterTRTCRoom();
            this.startCall();
        }
        if (!TextUtils.equals((CharSequence)this.mCurGroupId, (CharSequence)groupId)) {
            return;
        }
        ArrayList<String> filterInvitedList = new ArrayList<String>();
        for (String id2 : userIdList) {
            if (this.mCurInvitedList.contains(id2)) continue;
            filterInvitedList.add(id2);
        }
        if (TRTCAVCallImpl.isCollectionEmpty(filterInvitedList)) {
            return;
        }
        this.mCurInvitedList.addAll(filterInvitedList);
        TUIKitLog.i(TAG, "groupCall: filter:" + filterInvitedList + " all:" + this.mCurInvitedList);
        this.mLastCallModel.action = 1;
        this.mLastCallModel.invitedList = this.mCurInvitedList;
        this.mLastCallModel.roomId = this.mCurRoomID;
        this.mLastCallModel.groupId = this.mCurGroupId;
        this.mLastCallModel.callType = this.mCurCallType;
        if (!TextUtils.isEmpty((CharSequence)this.mCurGroupId)) {
            this.mCurCallID = this.sendModel("", 1);
        } else {
            for (String userId : filterInvitedList) {
                this.mCurCallID = this.sendModel(userId, 1);
            }
        }
        this.mLastCallModel.callId = this.mCurCallID;
    }

    private void preExitRoom(String leaveUser) {
        TUIKitLog.i(TAG, "preExitRoom: " + this.mCurRoomRemoteUserSet + " " + this.mCurInvitedList);
        if (this.mCurRoomRemoteUserSet.isEmpty() && this.mCurInvitedList.isEmpty() && this.mIsInRoom) {
            if (!TextUtils.isEmpty((CharSequence)leaveUser)) {
                if (TextUtils.isEmpty((CharSequence)this.mCurGroupId)) {
                    this.sendModel(leaveUser, 5);
                } else {
                    this.sendModel("", 5);
                }
            }
            this.exitRoom();
            this.stopCall();
            if (this.mTRTCInteralListenerManager != null) {
                this.mTRTCInteralListenerManager.onCallEnd();
            }
        }
    }

    private void exitRoom() {
        this.mTRTCCloud.stopLocalPreview();
        this.mTRTCCloud.stopLocalAudio();
        this.mTRTCCloud.exitRoom();
    }

    @Override
    public void accept() {
        this.mIsRespSponsor = true;
        this.sendModel(this.mCurSponsorForMe, 7);
        this.enterTRTCRoom();
    }

    private void enterTRTCRoom() {
        if (this.mCurCallType == 2) {
            TXBeautyManager txBeautyManager = this.mTRTCCloud.getBeautyManager();
            txBeautyManager.setBeautyStyle(1);
            txBeautyManager.setBeautyLevel(6);
            TRTCCloudDef.TRTCVideoEncParam encParam = new TRTCCloudDef.TRTCVideoEncParam();
            encParam.videoResolution = 110;
            encParam.videoFps = 15;
            encParam.videoBitrate = 1000;
            encParam.videoResolutionMode = 1;
            encParam.enableAdjustRes = true;
            this.mTRTCCloud.setVideoEncoderParam(encParam);
        }
        TUIKitLog.i(TAG, "enterTRTCRoom: " + this.mCurUserId + " room:" + this.mCurRoomID);
        TRTCCloudDef.TRTCParams TRTCParams2 = new TRTCCloudDef.TRTCParams(this.mSdkAppId, this.mCurUserId, this.mCurUserSig, this.mCurRoomID, "", "");
        TRTCParams2.role = 20;
        this.mTRTCCloud.enableAudioVolumeEvaluation(300);
        this.mTRTCCloud.setAudioRoute(0);
        this.mTRTCCloud.startLocalAudio();
        this.mTRTCCloud.setListener(this.mTRTCCloudListener);
        this.mTRTCCloud.enterRoom(TRTCParams2, 0);
    }

    @Override
    public void reject() {
        this.mIsRespSponsor = true;
        this.sendModel(this.mCurSponsorForMe, 3);
        this.stopCall();
    }

    @Override
    public void hangup() {
        boolean fromGroup;
        if (!this.isOnCalling) {
            this.reject();
            return;
        }
        boolean bl = fromGroup = !TextUtils.isEmpty((CharSequence)this.mCurGroupId);
        if (fromGroup) {
            this.groupHangup();
        } else {
            this.singleHangup();
        }
    }

    private void groupHangup() {
        if (TRTCAVCallImpl.isCollectionEmpty(this.mCurRoomRemoteUserSet)) {
            this.sendModel("", 2);
        }
        this.stopCall();
        this.exitRoom();
    }

    private void singleHangup() {
        for (String id2 : this.mCurInvitedList) {
            this.sendModel(id2, 2);
        }
        this.stopCall();
        this.exitRoom();
    }

    @Override
    public void openCamera(boolean isFrontCamera, TXCloudVideoView txCloudVideoView) {
        if (txCloudVideoView == null) {
            return;
        }
        this.mIsUseFrontCamera = isFrontCamera;
        this.mTRTCCloud.startLocalPreview(isFrontCamera, txCloudVideoView);
    }

    @Override
    public void closeCamera() {
        this.mTRTCCloud.stopLocalPreview();
    }

    @Override
    public void startRemoteView(String userId, TXCloudVideoView txCloudVideoView) {
        if (txCloudVideoView == null) {
            return;
        }
        this.mTRTCCloud.startRemoteView(userId, txCloudVideoView);
    }

    @Override
    public void stopRemoteView(String userId) {
        this.mTRTCCloud.stopRemoteView(userId);
    }

    @Override
    public void switchCamera(boolean isFrontCamera) {
        if (this.mIsUseFrontCamera == isFrontCamera) {
            return;
        }
        this.mIsUseFrontCamera = isFrontCamera;
        this.mTRTCCloud.switchCamera();
    }

    @Override
    public void setMicMute(boolean isMute) {
        this.mTRTCCloud.muteLocalAudio(isMute);
    }

    @Override
    public void setHandsFree(boolean isHandsFree) {
        if (isHandsFree) {
            this.mTRTCCloud.setAudioRoute(0);
        } else {
            this.mTRTCCloud.setAudioRoute(1);
        }
    }

    private String sendModel(String user, int action) {
        return this.sendModel(user, action, null);
    }

    private void sendOnlineMessageWithOfflinePushInfoForGroupCall(CallModel model) {
        V2TIMOfflinePushInfo v2TIMOfflinePushInfo = this.getOfflinePushInfo(model);
        MessageCustom custom = new MessageCustom();
        custom.businessID = "av_call";
        custom.version = TUIKitConstants.version;
        V2TIMMessage message = V2TIMManager.getMessageManager().createCustomMessage(new Gson().toJson((Object)custom).getBytes());
        for (String receiver : model.invitedList) {
            TUIKitLog.i(TAG, "sendOnlineMessage to " + receiver);
            V2TIMManager.getMessageManager().sendMessage(message, receiver, null, 0, true, v2TIMOfflinePushInfo, (V2TIMSendCallback)new V2TIMSendCallback<V2TIMMessage>(){

                public void onError(int code, String desc) {
                    TUIKitLog.e(TRTCAVCallImpl.TAG, "sendOnlineMessage failed, code:" + code + ", desc:" + desc);
                }

                public void onSuccess(V2TIMMessage v2TIMMessage) {
                    TUIKitLog.i(TRTCAVCallImpl.TAG, "sendOnlineMessage msgId:" + v2TIMMessage.getMsgID());
                }

                public void onProgress(int progress) {
                }
            });
        }
    }

    private V2TIMOfflinePushInfo getOfflinePushInfo(CallModel model) {
        OfflineMessageContainerBean containerBean = new OfflineMessageContainerBean();
        OfflineMessageBean entity = new OfflineMessageBean();
        entity.content = new Gson().toJson((Object)model);
        entity.sender = V2TIMManager.getInstance().getLoginUser();
        entity.action = 2;
        entity.sendTime = V2TIMManager.getInstance().getServerTime();
        entity.nickname = TUIKitConfigs.getConfigs().getGeneralConfig().getUserNickname();
        entity.faceUrl = TUIKitConfigs.getConfigs().getGeneralConfig().getUserFaceUrl();
        containerBean.entity = entity;
        entity.chatType = 2;
        V2TIMOfflinePushInfo v2TIMOfflinePushInfo = new V2TIMOfflinePushInfo();
        v2TIMOfflinePushInfo.setExt(new Gson().toJson((Object)containerBean).getBytes());
        v2TIMOfflinePushInfo.setAndroidOPPOChannelID("tuikit");
        v2TIMOfflinePushInfo.setDesc(TUIKit.getAppContext().getString(R.string.offline_call_tip));
        return v2TIMOfflinePushInfo;
    }

    private String getCallId() {
        return this.mCurCallID;
    }

    private String sendModel(String user, int action, CallModel model) {
        boolean isGroup;
        CallModel realCallModel;
        String callID = null;
        if (model != null) {
            realCallModel = (CallModel)model.clone();
            realCallModel.action = action;
        } else {
            realCallModel = this.generateModel(action);
        }
        boolean bl = isGroup = !TextUtils.isEmpty((CharSequence)realCallModel.groupId);
        if (action == 5 && this.mEnterRoomTime != 0L && !isGroup) {
            realCallModel.duration = (int)(V2TIMManager.getInstance().getServerTime() - this.mEnterRoomTime);
            this.mEnterRoomTime = 0L;
        }
        String receiver = "";
        String groupId = "";
        if (isGroup) {
            groupId = realCallModel.groupId;
        } else {
            receiver = user;
        }
        HashMap<String, Object> customMap = new HashMap<String, Object>();
        customMap.put(CallModel.SIGNALING_EXTRA_KEY_VERSION, TUIKitConstants.version);
        customMap.put(CallModel.SIGNALING_EXTRA_KEY_CALL_TYPE, realCallModel.callType);
        customMap.put(CallModel.SIGNALING_EXTRA_KEY_BUSINESS_ID, CallModel.SIGNALING_EXTRA_VALUE_BUSINESS_ID);
        switch (realCallModel.action) {
            case 1: {
                customMap.put(CallModel.SIGNALING_EXTRA_KEY_ROOM_ID, realCallModel.roomId);
                String dialingDataStr = new Gson().toJson(customMap);
                if (isGroup) {
                    callID = V2TIMManager.getSignalingManager().inviteInGroup(groupId, realCallModel.invitedList, dialingDataStr, false, 30, new V2TIMCallback(){

                        public void onError(int code, String desc) {
                            TUIKitLog.e(TRTCAVCallImpl.TAG, "inviteInGroup callID:" + realCallModel.callId + ", error:" + code + " desc:" + desc);
                        }

                        public void onSuccess() {
                            TUIKitLog.d(TRTCAVCallImpl.TAG, "inviteInGroup success:" + realCallModel);
                            realCallModel.callId = TRTCAVCallImpl.this.getCallId();
                            realCallModel.timeout = 30;
                            realCallModel.version = TUIKitConstants.version;
                            TRTCAVCallImpl.this.sendOnlineMessageWithOfflinePushInfoForGroupCall(realCallModel);
                        }
                    });
                    break;
                }
                realCallModel.callId = this.getCallId();
                realCallModel.timeout = 30;
                realCallModel.version = TUIKitConstants.version;
                V2TIMOfflinePushInfo offlinePushInfo = this.getOfflinePushInfo(realCallModel);
                callID = V2TIMManager.getSignalingManager().invite(receiver, dialingDataStr, false, offlinePushInfo, 30, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TRTCAVCallImpl.TAG, "invite  callID:" + realCallModel.callId + ",error:" + code + " desc:" + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.d(TRTCAVCallImpl.TAG, "invite success:" + realCallModel);
                    }
                });
                break;
            }
            case 7: {
                String acceptDataStr = new Gson().toJson(customMap);
                V2TIMManager.getSignalingManager().accept(realCallModel.callId, acceptDataStr, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TRTCAVCallImpl.TAG, "accept callID:" + realCallModel.callId + ", error:" + code + " desc:" + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.d(TRTCAVCallImpl.TAG, "accept success callID:" + realCallModel.callId);
                    }
                });
                break;
            }
            case 3: {
                String rejectDataStr = new Gson().toJson(customMap);
                V2TIMManager.getSignalingManager().reject(realCallModel.callId, rejectDataStr, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TRTCAVCallImpl.TAG, "reject callID:" + realCallModel.callId + ", error:" + code + " desc:" + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.d(TRTCAVCallImpl.TAG, "reject success callID:" + realCallModel.callId);
                    }
                });
                break;
            }
            case 6: {
                customMap.put(CallModel.SIGNALING_EXTRA_KEY_LINE_BUSY, "");
                String lineBusyMapStr = new Gson().toJson(customMap);
                V2TIMManager.getSignalingManager().reject(realCallModel.callId, lineBusyMapStr, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TRTCAVCallImpl.TAG, "reject  callID:" + realCallModel.callId + ", error:" + code + " desc:" + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.d(TRTCAVCallImpl.TAG, "reject success callID:" + realCallModel.callId);
                    }
                });
                break;
            }
            case 2: {
                String cancelMapStr = new Gson().toJson(customMap);
                V2TIMManager.getSignalingManager().cancel(realCallModel.callId, cancelMapStr, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TRTCAVCallImpl.TAG, "cancel callID:" + realCallModel.callId + ", error:" + code + " desc:" + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.d(TRTCAVCallImpl.TAG, "cancel success callID:" + realCallModel.callId);
                    }
                });
                break;
            }
            case 5: {
                customMap.put(CallModel.SIGNALING_EXTRA_KEY_CALL_END, realCallModel.duration);
                String hangupMapStr = new Gson().toJson(customMap);
                if (isGroup) {
                    V2TIMManager.getSignalingManager().inviteInGroup(groupId, realCallModel.invitedList, hangupMapStr, false, 0, new V2TIMCallback(){

                        public void onError(int code, String desc) {
                            TUIKitLog.e(TRTCAVCallImpl.TAG, "inviteInGroup-->hangup callID: " + realCallModel.callId + ", error:" + code + " desc:" + desc);
                        }

                        public void onSuccess() {
                            TUIKitLog.d(TRTCAVCallImpl.TAG, "inviteInGroup-->hangup success callID:" + realCallModel.callId);
                        }
                    });
                    break;
                }
                V2TIMManager.getSignalingManager().invite(receiver, hangupMapStr, false, null, 0, new V2TIMCallback(){

                    public void onError(int code, String desc) {
                        TUIKitLog.e(TRTCAVCallImpl.TAG, "invite-->hangup callID: " + realCallModel.callId + ", error:" + code + " desc:" + desc);
                    }

                    public void onSuccess() {
                        TUIKitLog.d(TRTCAVCallImpl.TAG, "invite-->hangup success callID:" + realCallModel.callId);
                    }
                });
                break;
            }
        }
        if (realCallModel.action != 3 && realCallModel.action != 5 && realCallModel.action != 2 && model == null) {
            this.mLastCallModel = (CallModel)realCallModel.clone();
        }
        return callID;
    }

    private CallModel generateModel(int action) {
        CallModel callModel = (CallModel)this.mLastCallModel.clone();
        callModel.action = action;
        return callModel;
    }

    private static boolean isCollectionEmpty(Collection coll) {
        return coll == null || coll.size() == 0;
    }

    private static String CallModel2Json(CallModel callModel) {
        if (callModel == null) {
            return null;
        }
        return new Gson().toJson((Object)callModel);
    }

    private static int generateRoomID() {
        Random random = new Random();
        return random.nextInt(Integer.MAX_VALUE) + 1;
    }

    private class TRTCInteralListenerManager
    implements TRTCAVCallListener {
        private List<WeakReference<TRTCAVCallListener>> mWeakReferenceList = new ArrayList<WeakReference<TRTCAVCallListener>>();

        public void addListenter(TRTCAVCallListener listener) {
            WeakReference<TRTCAVCallListener> listenerWeakReference = new WeakReference<TRTCAVCallListener>(listener);
            this.mWeakReferenceList.add(listenerWeakReference);
        }

        public void removeListenter(TRTCAVCallListener listener) {
            Iterator<WeakReference<TRTCAVCallListener>> iterator = this.mWeakReferenceList.iterator();
            while (iterator.hasNext()) {
                WeakReference<TRTCAVCallListener> reference = iterator.next();
                if (reference.get() == null) {
                    iterator.remove();
                    continue;
                }
                if (reference.get() != listener) continue;
                iterator.remove();
            }
        }

        @Override
        public void onError(int code, String msg) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onError(code, msg);
            }
        }

        @Override
        public void onInvited(String sponsor, List<String> userIdList, boolean isFromGroup, int callType) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onInvited(sponsor, userIdList, isFromGroup, callType);
            }
        }

        @Override
        public void onGroupCallInviteeListUpdate(List<String> userIdList) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onGroupCallInviteeListUpdate(userIdList);
            }
        }

        @Override
        public void onUserEnter(String userId) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onUserEnter(userId);
            }
        }

        @Override
        public void onUserLeave(String userId) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onUserLeave(userId);
            }
        }

        @Override
        public void onReject(String userId) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onReject(userId);
            }
        }

        @Override
        public void onNoResp(String userId) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onNoResp(userId);
            }
        }

        @Override
        public void onLineBusy(String userId) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onLineBusy(userId);
            }
        }

        @Override
        public void onCallingCancel() {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onCallingCancel();
            }
        }

        @Override
        public void onCallingTimeout() {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onCallingTimeout();
            }
        }

        @Override
        public void onCallEnd() {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onCallEnd();
            }
        }

        @Override
        public void onUserVideoAvailable(String userId, boolean isVideoAvailable) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onUserVideoAvailable(userId, isVideoAvailable);
            }
        }

        @Override
        public void onUserAudioAvailable(String userId, boolean isVideoAvailable) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onUserAudioAvailable(userId, isVideoAvailable);
            }
        }

        @Override
        public void onUserVoiceVolume(Map<String, Integer> volumeMap) {
            for (WeakReference<TRTCAVCallListener> reference : this.mWeakReferenceList) {
                TRTCAVCallListener listener = (TRTCAVCallListener)reference.get();
                if (listener == null) continue;
                listener.onUserVoiceVolume(volumeMap);
            }
        }
    }
}

