/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcaudiocalldemo.ui;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.Group;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMUserFullInfo;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.liteav.login.ProfileManager;
import com.tencent.liteav.login.UserModel;
import com.tencent.liteav.model.ITRTCAVCall;
import com.tencent.liteav.model.IntentParams;
import com.tencent.liteav.model.TRTCAVCallImpl;
import com.tencent.liteav.model.TRTCAVCallListener;
import com.tencent.liteav.trtcaudiocalldemo.ui.audiolayout.TRTCAudioLayout;
import com.tencent.liteav.trtcaudiocalldemo.ui.audiolayout.TRTCAudioLayoutManager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.utils.PermissionUtils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TRTCAudioCallActivity
extends AppCompatActivity {
    private static final String TAG = TRTCAudioCallActivity.class.getName();
    public static final int TYPE_BEING_CALLED = 1;
    public static final int TYPE_BEING_CALLED_FROM_NOTIFICATION = 3;
    public static final int TYPE_CALL = 2;
    public static final String PARAM_GROUP_ID = "group_id";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_USER = "user_model";
    public static final String PARAM_BEINGCALL_USER = "beingcall_user_model";
    public static final String PARAM_OTHER_INVITING_USER = "other_inviting_user_model";
    private static final int MAX_SHOW_INVITING_USER = 2;
    private static final int RADIUS = 30;
    private ImageView mMuteImg;
    private LinearLayout mMuteLl;
    private ImageView mHangupImg;
    private LinearLayout mHangupLl;
    private ImageView mHandsfreeImg;
    private LinearLayout mHandsfreeLl;
    private ImageView mDialingImg;
    private LinearLayout mDialingLl;
    private TRTCAudioLayoutManager mLayoutManagerTrtc;
    private Group mInvitingGroup;
    private LinearLayout mImgContainerLl;
    private TextView mTimeTv;
    private Runnable mTimeRunnable;
    private int mTimeCount;
    private Handler mTimeHandler;
    private HandlerThread mTimeHandlerThread;
    private UserModel mSelfModel;
    private List<UserModel> mCallUserModelList = new ArrayList<UserModel>();
    private Map<String, UserModel> mCallUserModelMap = new HashMap<String, UserModel>();
    private UserModel mSponsorUserModel;
    private List<UserModel> mOtherInvitingUserModelList;
    private int mCallType;
    private ITRTCAVCall mITRTCAVCall;
    private String mGroupId;
    private boolean isHandsFree = true;
    private boolean isMuteMic = false;
    private Vibrator mVibrator;
    private Ringtone mRingtone;
    private TRTCAVCallListener mTRTCAudioCallListener = new TRTCAVCallListener(){

        @Override
        public void onError(int code, String msg) {
            ToastUtil.toastLongMessage(TRTCAudioCallActivity.this.getString(R.string.error) + "[" + code + "]:" + msg);
            TRTCAudioCallActivity.this.finishActivity();
        }

        @Override
        public void onInvited(String sponsor, List<String> userIdList, boolean isFromGroup, int callType) {
        }

        @Override
        public void onGroupCallInviteeListUpdate(List<String> userIdList) {
        }

        @Override
        public void onUserEnter(final String userId) {
            TRTCAudioCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TRTCAudioCallActivity.this.showCallingView();
                    TRTCAudioLayout layout2 = TRTCAudioCallActivity.this.mLayoutManagerTrtc.findAudioCallLayout(userId);
                    if (layout2 != null) {
                        layout2.stopLoading();
                    } else {
                        ProfileManager.getInstance().getUserInfoByUserId(userId, new ProfileManager.GetUserInfoCallback(){

                            @Override
                            public void onSuccess(UserModel model) {
                                TRTCAudioCallActivity.this.mCallUserModelList.add(model);
                                TRTCAudioCallActivity.this.mCallUserModelMap.put(model.userId, model);
                                TRTCAudioCallActivity.this.addUserToManager(model);
                            }

                            @Override
                            public void onFailed(int code, String msg) {
                                ToastUtil.toastLongMessage(TRTCAudioCallActivity.this.getString(R.string.get_user_info_tips_before) + userId + TRTCAudioCallActivity.this.getString(R.string.get_user_info_tips_after));
                                UserModel model = new UserModel();
                                model.userId = userId;
                                model.phone = "";
                                model.userName = userId;
                                model.userAvatar = "";
                                TRTCAudioCallActivity.this.mCallUserModelList.add(model);
                                TRTCAudioCallActivity.this.mCallUserModelMap.put(model.userId, model);
                                TRTCAudioCallActivity.this.addUserToManager(model);
                            }
                        });
                    }
                }
            });
        }

        @Override
        public void onUserLeave(final String userId) {
            TRTCAudioCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TRTCAudioCallActivity.this.mLayoutManagerTrtc.recyclerAudioCallLayout(userId);
                    UserModel userModel = (UserModel)TRTCAudioCallActivity.this.mCallUserModelMap.remove(userId);
                    if (userModel != null) {
                        TRTCAudioCallActivity.this.mCallUserModelList.remove(userModel);
                    }
                }
            });
        }

        @Override
        public void onReject(final String userId) {
            TRTCAudioCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TRTCAudioCallActivity.this.mCallUserModelMap.containsKey(userId)) {
                        TRTCAudioCallActivity.this.mLayoutManagerTrtc.recyclerAudioCallLayout(userId);
                        UserModel userModel = (UserModel)TRTCAudioCallActivity.this.mCallUserModelMap.remove(userId);
                        if (userModel != null) {
                            TRTCAudioCallActivity.this.mCallUserModelList.remove(userModel);
                            ToastUtil.toastLongMessage(userModel.userName + TRTCAudioCallActivity.this.getString(R.string.reject_call));
                        }
                    }
                }
            });
        }

        @Override
        public void onNoResp(final String userId) {
            TRTCAudioCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TRTCAudioCallActivity.this.mCallUserModelMap.containsKey(userId)) {
                        TRTCAudioCallActivity.this.mLayoutManagerTrtc.recyclerAudioCallLayout(userId);
                        UserModel userModel = (UserModel)TRTCAudioCallActivity.this.mCallUserModelMap.remove(userId);
                        if (userModel != null) {
                            TRTCAudioCallActivity.this.mCallUserModelList.remove(userModel);
                            ToastUtil.toastLongMessage(userModel.userName + TRTCAudioCallActivity.this.getString(R.string.no_response));
                        }
                    }
                }
            });
        }

        @Override
        public void onLineBusy(String userId) {
            if (TRTCAudioCallActivity.this.mCallUserModelMap.containsKey(userId)) {
                TRTCAudioCallActivity.this.mLayoutManagerTrtc.recyclerAudioCallLayout(userId);
                UserModel userModel = (UserModel)TRTCAudioCallActivity.this.mCallUserModelMap.remove(userId);
                if (userModel != null) {
                    TRTCAudioCallActivity.this.mCallUserModelList.remove(userModel);
                    ToastUtil.toastLongMessage(userModel.userName + TRTCAudioCallActivity.this.getString(R.string.line_busy));
                }
            }
        }

        @Override
        public void onCallingCancel() {
            if (TRTCAudioCallActivity.this.mSponsorUserModel != null) {
                ToastUtil.toastLongMessage(((TRTCAudioCallActivity)TRTCAudioCallActivity.this).mSponsorUserModel.userName + TRTCAudioCallActivity.this.getString(R.string.cancle_calling));
            }
            TRTCAudioCallActivity.this.finishActivity();
        }

        @Override
        public void onCallingTimeout() {
            if (TRTCAudioCallActivity.this.mSponsorUserModel != null) {
                ToastUtil.toastLongMessage(((TRTCAudioCallActivity)TRTCAudioCallActivity.this).mSponsorUserModel.userName + TRTCAudioCallActivity.this.getString(R.string.call_time_out));
            }
            TRTCAudioCallActivity.this.finishActivity();
        }

        @Override
        public void onCallEnd() {
            TRTCAudioCallActivity.this.finishActivity();
        }

        @Override
        public void onUserAudioAvailable(String userId, boolean isVideoAvailable) {
        }

        @Override
        public void onUserVideoAvailable(String userId, boolean isVideoAvailable) {
        }

        @Override
        public void onUserVoiceVolume(Map<String, Integer> volumeMap) {
            for (Map.Entry<String, Integer> entry : volumeMap.entrySet()) {
                String userId = entry.getKey();
                TRTCAudioLayout layout2 = TRTCAudioCallActivity.this.mLayoutManagerTrtc.findAudioCallLayout(userId);
                if (layout2 == null) continue;
                layout2.setAudioVolume(entry.getValue());
            }
        }
    };

    public static void startCallSomeone(Context context, List<UserModel> models) {
        TUIKitLog.i(TAG, "startCallSomeone");
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance(context)).setWaitingLastActivityFinished(false);
        Intent starter = new Intent(context, TRTCAudioCallActivity.class);
        starter.putExtra(PARAM_TYPE, 2);
        starter.putExtra(PARAM_USER, (Serializable)new IntentParams(models));
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    public static void startCallSomePeople(Context context, List<UserModel> models, String groupId) {
        TUIKitLog.i(TAG, "startCallSomePeople");
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance(context)).setWaitingLastActivityFinished(false);
        Intent starter = new Intent(context, TRTCAudioCallActivity.class);
        starter.putExtra(PARAM_GROUP_ID, groupId);
        starter.putExtra(PARAM_TYPE, 2);
        starter.putExtra(PARAM_USER, (Serializable)new IntentParams(models));
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    public static void startBeingCall(Context context, UserModel beingCallUserModel, List<UserModel> otherInvitingUserModel) {
        TUIKitLog.i(TAG, "startBeingCall");
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance(context)).setWaitingLastActivityFinished(false);
        Intent starter = new Intent(context, TRTCAudioCallActivity.class);
        starter.putExtra(PARAM_TYPE, 1);
        starter.putExtra(PARAM_BEINGCALL_USER, (Serializable)beingCallUserModel);
        starter.putExtra(PARAM_OTHER_INVITING_USER, (Serializable)new IntentParams(otherInvitingUserModel));
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TUIKitLog.i(TAG, "onCreate");
        this.mCallType = this.getIntent().getIntExtra(PARAM_TYPE, 1);
        TUIKitLog.i(TAG, "mCallType: " + this.mCallType);
        if (this.mCallType == 1 && ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance((Context)this)).isWaitingLastActivityFinished()) {
            TUIKitLog.w(TAG, "ignore activity launch");
            this.finishActivity();
            return;
        }
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        if (manager != null) {
            manager.cancelAll();
        }
        this.getWindow().addFlags(128);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.audiocall_activity_call_main);
        PermissionUtils.checkPermission((Context)this, "android.permission.RECORD_AUDIO");
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        this.mRingtone = RingtoneManager.getRingtone((Context)this, (Uri)RingtoneManager.getDefaultUri((int)1));
        this.initView();
        this.initData();
        this.initListener();
    }

    private void finishActivity() {
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance((Context)this)).setWaitingLastActivityFinished(true);
        this.finish();
    }

    public void onResume() {
        super.onResume();
        TUIKitLog.i(TAG, "onResume");
    }

    public void onPause() {
        super.onPause();
        TUIKitLog.i(TAG, "onPause");
    }

    public void onStart() {
        super.onStart();
        TUIKitLog.i(TAG, "onStart");
    }

    public void onStop() {
        super.onStop();
        TUIKitLog.i(TAG, "onStop");
    }

    public void onBackPressed() {
        TUIKitLog.i(TAG, "onBackPressed");
        this.mITRTCAVCall.hangup();
        super.onBackPressed();
    }

    protected void onDestroy() {
        TUIKitLog.i(TAG, "onDestroy");
        super.onDestroy();
        if (this.mVibrator != null) {
            this.mVibrator.cancel();
        }
        if (this.mRingtone != null) {
            this.mRingtone.stop();
        }
        if (this.mITRTCAVCall != null) {
            this.mITRTCAVCall.removeListener(this.mTRTCAudioCallListener);
        }
        this.stopTimeCount();
        if (this.mTimeHandlerThread != null) {
            this.mTimeHandlerThread.quit();
        }
    }

    private void initListener() {
        this.mMuteLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCAudioCallActivity.this.isMuteMic = !TRTCAudioCallActivity.this.isMuteMic;
                TRTCAudioCallActivity.this.mITRTCAVCall.setMicMute(TRTCAudioCallActivity.this.isMuteMic);
                TRTCAudioCallActivity.this.mMuteImg.setActivated(TRTCAudioCallActivity.this.isMuteMic);
                ToastUtil.toastLongMessage(TRTCAudioCallActivity.this.isMuteMic ? TRTCAudioCallActivity.this.getString(R.string.open_silent) : TRTCAudioCallActivity.this.getString(R.string.close_silent));
            }
        });
        this.mHandsfreeLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCAudioCallActivity.this.isHandsFree = !TRTCAudioCallActivity.this.isHandsFree;
                TRTCAudioCallActivity.this.mITRTCAVCall.setHandsFree(TRTCAudioCallActivity.this.isHandsFree);
                TRTCAudioCallActivity.this.mHandsfreeImg.setActivated(TRTCAudioCallActivity.this.isHandsFree);
                ToastUtil.toastLongMessage(TRTCAudioCallActivity.this.isHandsFree ? TRTCAudioCallActivity.this.getString(R.string.use_speakers) : TRTCAudioCallActivity.this.getString(R.string.use_handset));
            }
        });
        this.mMuteImg.setActivated(this.isMuteMic);
        this.mHandsfreeImg.setActivated(this.isHandsFree);
    }

    private void initData() {
        this.mITRTCAVCall = TRTCAVCallImpl.sharedInstance((Context)this);
        this.mITRTCAVCall.addListener(this.mTRTCAudioCallListener);
        this.mTimeHandlerThread = new HandlerThread("time-count-thread");
        this.mTimeHandlerThread.start();
        this.mTimeHandler = new Handler(this.mTimeHandlerThread.getLooper());
        Intent intent = this.getIntent();
        this.mSelfModel = ProfileManager.getInstance().getUserModel();
        this.mCallType = intent.getIntExtra(PARAM_TYPE, 1);
        this.mGroupId = intent.getStringExtra(PARAM_GROUP_ID);
        if (this.mCallType == 1) {
            this.mSponsorUserModel = (UserModel)intent.getSerializableExtra(PARAM_BEINGCALL_USER);
            IntentParams params = (IntentParams)intent.getSerializableExtra(PARAM_OTHER_INVITING_USER);
            if (params != null) {
                this.mOtherInvitingUserModelList = params.mUserModels;
            }
            this.showWaitingResponseView();
            this.mVibrator.vibrate(new long[]{0L, 1000L, 1000L}, 0);
            this.mRingtone.play();
        } else {
            IntentParams params = (IntentParams)intent.getSerializableExtra(PARAM_USER);
            if (params != null) {
                this.mCallUserModelList = params.mUserModels;
                for (UserModel userModel : this.mCallUserModelList) {
                    this.mCallUserModelMap.put(userModel.userId, userModel);
                }
                this.startInviting();
                this.showInvitingView();
            }
        }
    }

    private void startInviting() {
        ArrayList<String> list = new ArrayList<String>();
        for (UserModel userModel : this.mCallUserModelList) {
            list.add(userModel.userId);
        }
        this.mITRTCAVCall.groupCall(list, 1, this.mGroupId);
    }

    private void initView() {
        this.mMuteImg = (ImageView)this.findViewById(R.id.img_mute);
        this.mMuteLl = (LinearLayout)this.findViewById(R.id.ll_mute);
        this.mHangupImg = (ImageView)this.findViewById(R.id.img_hangup);
        this.mHangupLl = (LinearLayout)this.findViewById(R.id.ll_hangup);
        this.mHandsfreeImg = (ImageView)this.findViewById(R.id.img_handsfree);
        this.mHandsfreeLl = (LinearLayout)this.findViewById(R.id.ll_handsfree);
        this.mDialingImg = (ImageView)this.findViewById(R.id.img_dialing);
        this.mDialingLl = (LinearLayout)this.findViewById(R.id.ll_dialing);
        this.mLayoutManagerTrtc = (TRTCAudioLayoutManager)this.findViewById(R.id.trtc_layout_manager);
        this.mInvitingGroup = (Group)this.findViewById(R.id.group_inviting);
        this.mImgContainerLl = (LinearLayout)this.findViewById(R.id.ll_img_container);
        this.mTimeTv = (TextView)this.findViewById(R.id.tv_time);
    }

    public void showWaitingResponseView() {
        TRTCAudioLayout layout2 = this.mLayoutManagerTrtc.allocAudioCallLayout(this.mSponsorUserModel.userId);
        layout2.setUserId(this.mSponsorUserModel.userName);
        GlideEngine.loadCornerImage(layout2.getImageView(), this.mSponsorUserModel.userAvatar, null, 30.0f);
        this.updateUserView(this.mSponsorUserModel, (Object)layout2);
        this.mHangupLl.setVisibility(0);
        this.mDialingLl.setVisibility(0);
        this.mHandsfreeLl.setVisibility(8);
        this.mMuteLl.setVisibility(8);
        this.mHangupLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCAudioCallActivity.this.mVibrator.cancel();
                TRTCAudioCallActivity.this.mRingtone.stop();
                TRTCAudioCallActivity.this.mITRTCAVCall.reject();
                TRTCAudioCallActivity.this.finishActivity();
            }
        });
        this.mDialingLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCAudioCallActivity.this.mVibrator.cancel();
                TRTCAudioCallActivity.this.mRingtone.stop();
                TRTCAudioCallActivity.this.mLayoutManagerTrtc.setMySelfUserId(((TRTCAudioCallActivity)TRTCAudioCallActivity.this).mSelfModel.userId);
                TRTCAudioCallActivity.this.addUserToManager(TRTCAudioCallActivity.this.mSelfModel);
                TRTCAudioCallActivity.this.mITRTCAVCall.accept();
                TRTCAudioCallActivity.this.showCallingView();
            }
        });
        this.showOtherInvitingUserView();
    }

    public void showInvitingView() {
        this.mLayoutManagerTrtc.setMySelfUserId(this.mSelfModel.userId);
        this.addUserToManager(this.mSelfModel);
        for (UserModel userModel : this.mCallUserModelList) {
            TRTCAudioLayout layout2 = this.addUserToManager(userModel);
            layout2.startLoading();
        }
        this.mHangupLl.setVisibility(0);
        this.mHangupLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCAudioCallActivity.this.mITRTCAVCall.hangup();
                TRTCAudioCallActivity.this.finishActivity();
            }
        });
        this.mDialingLl.setVisibility(8);
        this.mHandsfreeLl.setVisibility(8);
        this.mMuteLl.setVisibility(8);
        this.hideOtherInvitingUserView();
    }

    public void showCallingView() {
        this.mHangupLl.setVisibility(0);
        this.mDialingLl.setVisibility(8);
        this.mHandsfreeLl.setVisibility(0);
        this.mMuteLl.setVisibility(0);
        this.mHangupLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCAudioCallActivity.this.mITRTCAVCall.hangup();
                TRTCAudioCallActivity.this.finishActivity();
            }
        });
        this.showTimeCount();
        this.hideOtherInvitingUserView();
    }

    private void showTimeCount() {
        if (this.mTimeRunnable != null) {
            return;
        }
        this.mTimeCount = 0;
        this.mTimeTv.setText((CharSequence)this.getShowTime(this.mTimeCount));
        if (this.mTimeRunnable == null) {
            this.mTimeRunnable = new Runnable(){

                @Override
                public void run() {
                    TRTCAudioCallActivity.this.mTimeCount++;
                    if (TRTCAudioCallActivity.this.mTimeTv != null) {
                        TRTCAudioCallActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                TRTCAudioCallActivity.this.mTimeTv.setText((CharSequence)TRTCAudioCallActivity.this.getShowTime(TRTCAudioCallActivity.this.mTimeCount));
                            }
                        });
                    }
                    TRTCAudioCallActivity.this.mTimeHandler.postDelayed(TRTCAudioCallActivity.this.mTimeRunnable, 1000L);
                }
            };
        }
        this.mTimeHandler.postDelayed(this.mTimeRunnable, 1000L);
    }

    private void stopTimeCount() {
        if (this.mTimeHandler != null) {
            this.mTimeHandler.removeCallbacks(this.mTimeRunnable);
        }
        this.mTimeRunnable = null;
    }

    private String getShowTime(int count) {
        return String.format("%02d:%02d", count / 60, count % 60);
    }

    private void showOtherInvitingUserView() {
        if (this.mOtherInvitingUserModelList == null || this.mOtherInvitingUserModelList.isEmpty()) {
            return;
        }
        this.mInvitingGroup.setVisibility(0);
        int squareWidth = this.getResources().getDimensionPixelOffset(R.dimen.contact_avatar_width);
        int leftMargin = this.getResources().getDimensionPixelOffset(R.dimen.small_image_left_margin);
        for (int index = 0; index < this.mOtherInvitingUserModelList.size() && index < 2; ++index) {
            UserModel userModel = this.mOtherInvitingUserModelList.get(index);
            ImageView imageView = new ImageView((Context)this);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(squareWidth, squareWidth);
            if (index != 0) {
                layoutParams.leftMargin = leftMargin;
            }
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            GlideEngine.loadCornerImage(imageView, userModel.userAvatar, null, 10.0f);
            this.updateUserView(userModel, imageView);
            this.mImgContainerLl.addView((View)imageView);
        }
    }

    private void hideOtherInvitingUserView() {
        this.mInvitingGroup.setVisibility(8);
    }

    private TRTCAudioLayout addUserToManager(UserModel userModel) {
        TRTCAudioLayout layout2 = this.mLayoutManagerTrtc.allocAudioCallLayout(userModel.userId);
        layout2.setUserId(userModel.userName);
        GlideEngine.loadCornerImage(layout2.getImageView(), userModel.userAvatar, null, 30.0f);
        this.updateUserView(userModel, (Object)layout2);
        return layout2;
    }

    private void updateUserView(final UserModel userModel, final Object layout2) {
        if (!TextUtils.isEmpty((CharSequence)userModel.userName) && !TextUtils.isEmpty((CharSequence)userModel.userAvatar)) {
            return;
        }
        ArrayList<String> users = new ArrayList<String>();
        users.add(userModel.userId);
        V2TIMManager.getInstance().getUsersInfo(users, (V2TIMValueCallback)new V2TIMValueCallback<List<V2TIMUserFullInfo>>(){

            public void onError(int code, String desc) {
                TUIKitLog.w(TAG, "getUsersInfo code:|desc:" + desc);
            }

            public void onSuccess(List<V2TIMUserFullInfo> v2TIMUserFullInfos) {
                if (v2TIMUserFullInfos == null || v2TIMUserFullInfos.size() != 1) {
                    TUIKitLog.w(TAG, "getUsersInfo v2TIMUserFullInfos error");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)userModel.userName)) {
                    userModel.userName = v2TIMUserFullInfos.get(0).getNickName();
                    if (layout2 instanceof TRTCAudioLayout) {
                        ((TRTCAudioLayout)((Object)layout2)).setUserId(v2TIMUserFullInfos.get(0).getNickName());
                    }
                }
                userModel.userAvatar = v2TIMUserFullInfos.get(0).getFaceUrl();
                if (layout2 instanceof TRTCAudioLayout) {
                    GlideEngine.loadCornerImage(((TRTCAudioLayout)((Object)layout2)).getImageView(), userModel.userAvatar, null, 30.0f);
                } else if (layout2 instanceof ImageView) {
                    GlideEngine.loadCornerImage((ImageView)layout2, userModel.userAvatar, null, 30.0f);
                }
            }
        });
    }
}

