/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcaudiocalldemo.ui.audiolayout;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.wang.avi.AVLoadingIndicatorView;

public class TRTCAudioLayout
extends RelativeLayout {
    private ImageView mHeadImg;
    private TextView mNameTv;
    private ProgressBar mAudioPb;
    private String mUserId;
    private AVLoadingIndicatorView mViewLoading;
    private FrameLayout mShadeFl;

    public TRTCAudioLayout(Context context) {
        this(context, null);
    }

    public TRTCAudioLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        TRTCAudioLayout.inflate((Context)context, (int)R.layout.audiocall_item_user_layout, (ViewGroup)this);
        this.initView();
    }

    private void initView() {
        this.mHeadImg = (ImageView)this.findViewById(R.id.img_head);
        this.mNameTv = (TextView)this.findViewById(R.id.tv_name);
        this.mAudioPb = (ProgressBar)this.findViewById(R.id.pb_audio);
        this.mViewLoading = (AVLoadingIndicatorView)this.findViewById(R.id.loading_view);
        this.mShadeFl = (FrameLayout)this.findViewById(R.id.fl_shade);
    }

    public void setAudioVolume(int vol) {
        this.mAudioPb.setProgress(vol);
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
        this.mNameTv.setText((CharSequence)this.mUserId);
    }

    public void setBitmap(Bitmap bitmap) {
        this.mHeadImg.setImageBitmap(bitmap);
    }

    public ImageView getImageView() {
        return this.mHeadImg;
    }

    public void startLoading() {
        this.mShadeFl.setVisibility(0);
        this.mViewLoading.show();
    }

    public void stopLoading() {
        this.mShadeFl.setVisibility(8);
        this.mViewLoading.hide();
    }
}

