/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcaudiocalldemo.ui.audiolayout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tencent.liteav.trtcaudiocalldemo.ui.audiolayout.TRTCAudioLayout;
import com.tencent.liteav.trtcaudiocalldemo.ui.audiolayout.Utils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.util.ArrayList;
import java.util.Iterator;

public class TRTCAudioLayoutManager
extends RelativeLayout {
    public static final int MAX_USER = 9;
    private static final String TAG = TRTCAudioLayoutManager.class.getSimpleName();
    private ArrayList<TRTCLayoutEntity> mLayoutEntityList;
    private boolean mInitParam = false;
    private ArrayList<RelativeLayout.LayoutParams> mGrid1ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid2ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid3ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid4ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid9ParamList;
    private int mCount = 0;
    private String mSelfUserId;
    private Context mContext;

    public TRTCAudioLayoutManager(Context context) {
        super(context);
        this.initView(context);
    }

    public TRTCAudioLayoutManager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TRTCAudioLayoutManager(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        TUIKitLog.i(TAG, "initView: ");
        this.mContext = context;
        this.mLayoutEntityList = new ArrayList();
        this.post(new Runnable(){

            @Override
            public void run() {
                TRTCAudioLayoutManager.this.makeGirdLayout(true);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSize == 0 && heightSize == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int minSize = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
            this.setMeasuredDimension(minSize, minSize);
            return;
        }
        int size = widthSize == 0 || heightSize == 0 ? Math.max(widthSize, heightSize) : Math.min(widthSize, heightSize);
        int newMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)size, (int)0x40000000);
        super.onMeasure(newMeasureSpec, newMeasureSpec);
    }

    public void setMySelfUserId(String userId) {
        this.mSelfUserId = userId;
    }

    public TRTCAudioLayout findAudioCallLayout(String userId) {
        if (userId == null) {
            return null;
        }
        for (TRTCLayoutEntity layoutEntity : this.mLayoutEntityList) {
            if (!layoutEntity.userId.equals(userId)) continue;
            return layoutEntity.layout;
        }
        return null;
    }

    public TRTCAudioLayout allocAudioCallLayout(String userId) {
        if (userId == null) {
            return null;
        }
        if (this.mCount > 9) {
            return null;
        }
        TRTCLayoutEntity layoutEntity = new TRTCLayoutEntity();
        layoutEntity.userId = userId;
        layoutEntity.layout = new TRTCAudioLayout(this.mContext);
        layoutEntity.layout.setVisibility(0);
        this.mLayoutEntityList.add(layoutEntity);
        this.addView((View)layoutEntity.layout);
        ++this.mCount;
        this.post(new Runnable(){

            @Override
            public void run() {
                TRTCAudioLayoutManager.this.makeGirdLayout(true);
            }
        });
        return layoutEntity.layout;
    }

    public void recyclerAudioCallLayout(String userId) {
        if (userId == null) {
            return;
        }
        Iterator<TRTCLayoutEntity> iterator = this.mLayoutEntityList.iterator();
        while (iterator.hasNext()) {
            TRTCLayoutEntity item = iterator.next();
            if (!item.userId.equals(userId)) continue;
            this.removeView((View)item.layout);
            iterator.remove();
            --this.mCount;
            break;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                TRTCAudioLayoutManager.this.makeGirdLayout(true);
            }
        });
    }

    public void updateAudioVolume(String userId, int audioVolume) {
        if (userId == null) {
            return;
        }
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            if (entity.layout.getVisibility() != 0 || !userId.equals(entity.userId)) continue;
            entity.layout.setAudioVolume(audioVolume);
        }
    }

    private TRTCLayoutEntity findEntity(TRTCAudioLayout layout2) {
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            if (entity.layout != layout2) continue;
            return entity;
        }
        return null;
    }

    private TRTCLayoutEntity findEntity(String userId) {
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            if (!entity.userId.equals(userId)) continue;
            return entity;
        }
        return null;
    }

    private void makeGirdLayout(boolean needUpdate) {
        if (!this.mInitParam) {
            this.mGrid1ParamList = Utils.initGrid1Param(this.getContext(), this.getWidth(), this.getHeight());
            this.mGrid2ParamList = Utils.initGrid2Param(this.getContext(), this.getWidth(), this.getHeight());
            this.mGrid3ParamList = Utils.initGrid3Param(this.getContext(), this.getWidth(), this.getHeight());
            this.mGrid4ParamList = Utils.initGrid4Param(this.getContext(), this.getWidth(), this.getHeight());
            this.mGrid9ParamList = Utils.initGrid9Param(this.getContext(), this.getWidth(), this.getHeight());
            this.mInitParam = true;
        }
        if (needUpdate) {
            if (this.mCount <= 1) {
                ArrayList<RelativeLayout.LayoutParams> paramList = this.mGrid1ParamList;
                TRTCLayoutEntity entity = this.mLayoutEntityList.get(0);
                entity.layout.setLayoutParams((ViewGroup.LayoutParams)paramList.get(0));
                return;
            }
            ArrayList<RelativeLayout.LayoutParams> paramList = this.mCount == 2 ? this.mGrid2ParamList : (this.mCount == 3 ? this.mGrid3ParamList : (this.mCount == 4 ? this.mGrid4ParamList : this.mGrid9ParamList));
            int layoutIndex = 1;
            for (int i = 0; i < this.mLayoutEntityList.size(); ++i) {
                TRTCLayoutEntity entity = this.mLayoutEntityList.get(i);
                if (entity.userId.equals(this.mSelfUserId)) {
                    entity.layout.setLayoutParams((ViewGroup.LayoutParams)paramList.get(0));
                    continue;
                }
                if (layoutIndex >= paramList.size()) continue;
                entity.layout.setLayoutParams((ViewGroup.LayoutParams)paramList.get(layoutIndex++));
            }
        }
    }

    private static class TRTCLayoutEntity {
        public TRTCAudioLayout layout;
        public String userId = "";

        private TRTCLayoutEntity() {
        }
    }
}

