/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcvideocalldemo.ui;

import android.app.NotificationManager;
import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Vibrator;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.Group;
import com.tencent.liteav.login.ProfileManager;
import com.tencent.liteav.login.UserModel;
import com.tencent.liteav.model.ITRTCAVCall;
import com.tencent.liteav.model.IntentParams;
import com.tencent.liteav.model.TRTCAVCallImpl;
import com.tencent.liteav.model.TRTCAVCallListener;
import com.tencent.liteav.trtcvideocalldemo.ui.videolayout.TRTCVideoLayout;
import com.tencent.liteav.trtcvideocalldemo.ui.videolayout.TRTCVideoLayoutManager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.utils.PermissionUtils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TRTCVideoCallActivity
extends AppCompatActivity {
    private static final String TAG = TRTCVideoCallActivity.class.getSimpleName();
    public static final int TYPE_BEING_CALLED = 1;
    public static final int TYPE_CALL = 2;
    public static final String PARAM_GROUP_ID = "group_id";
    public static final String PARAM_TYPE = "type";
    public static final String PARAM_USER = "user_model";
    public static final String PARAM_BEINGCALL_USER = "beingcall_user_model";
    public static final String PARAM_OTHER_INVITING_USER = "other_inviting_user_model";
    private static final int MAX_SHOW_INVITING_USER = 4;
    private static final int RADIUS = 30;
    private ImageView mMuteImg;
    private LinearLayout mMuteLl;
    private ImageView mHangupImg;
    private LinearLayout mHangupLl;
    private ImageView mHandsfreeImg;
    private LinearLayout mHandsfreeLl;
    private ImageView mDialingImg;
    private LinearLayout mDialingLl;
    private TRTCVideoLayoutManager mLayoutManagerTrtc;
    private Group mInvitingGroup;
    private LinearLayout mImgContainerLl;
    private TextView mTimeTv;
    private Runnable mTimeRunnable;
    private int mTimeCount;
    private Handler mTimeHandler;
    private HandlerThread mTimeHandlerThread;
    private UserModel mSelfModel;
    private List<UserModel> mCallUserModelList = new ArrayList<UserModel>();
    private Map<String, UserModel> mCallUserModelMap = new HashMap<String, UserModel>();
    private UserModel mSponsorUserModel;
    private List<UserModel> mOtherInvitingUserModelList;
    private int mCallType;
    private ITRTCAVCall mITRTCAVCall;
    private boolean isHandsFree = true;
    private boolean isMuteMic = false;
    private String mGroupId;
    private Vibrator mVibrator;
    private Ringtone mRingtone;
    private TRTCAVCallListener mTRTCAVCallListener = new TRTCAVCallListener(){

        @Override
        public void onError(int code, String msg) {
            ToastUtil.toastLongMessage(TRTCVideoCallActivity.this.getString(R.string.send_error) + "[" + code + "]:" + msg);
            TRTCVideoCallActivity.this.finishActivity();
        }

        @Override
        public void onInvited(String sponsor, List<String> userIdList, boolean isFromGroup, int callType) {
        }

        @Override
        public void onGroupCallInviteeListUpdate(List<String> userIdList) {
        }

        @Override
        public void onUserEnter(final String userId) {
            TRTCVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TRTCVideoCallActivity.this.showCallingView();
                    UserModel model = new UserModel();
                    model.userId = userId;
                    model.phone = "";
                    model.userName = userId;
                    model.userAvatar = "";
                    TRTCVideoCallActivity.this.mCallUserModelList.add(model);
                    TRTCVideoCallActivity.this.mCallUserModelMap.put(model.userId, model);
                    TRTCVideoLayout videoLayout = TRTCVideoCallActivity.this.addUserToManager(model);
                    if (videoLayout == null) {
                        return;
                    }
                    videoLayout.setVideoAvailable(false);
                    ProfileManager.getInstance().getUserInfoByUserId(userId, new ProfileManager.GetUserInfoCallback(){

                        @Override
                        public void onSuccess(UserModel model) {
                            UserModel oldModel = (UserModel)TRTCVideoCallActivity.this.mCallUserModelMap.get(model.userId);
                            if (oldModel != null) {
                                oldModel.userName = model.userName;
                                oldModel.userAvatar = model.userAvatar;
                                oldModel.phone = model.phone;
                                TRTCVideoLayout videoLayout = TRTCVideoCallActivity.this.mLayoutManagerTrtc.findCloudViewView(model.userId);
                                if (videoLayout != null) {
                                    GlideEngine.loadCornerImage((ImageView)videoLayout.getHeadImg(), oldModel.userAvatar, null, 30.0f);
                                    videoLayout.getUserNameTv().setText((CharSequence)oldModel.userName);
                                }
                            }
                        }

                        @Override
                        public void onFailed(int code, String msg) {
                            ToastUtil.toastLongMessage(TRTCVideoCallActivity.this.getString(R.string.get_user_info_tips_before) + userId + TRTCVideoCallActivity.this.getString(R.string.get_user_info_tips_after));
                        }
                    });
                }
            });
        }

        @Override
        public void onUserLeave(final String userId) {
            TRTCVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    TRTCVideoCallActivity.this.mLayoutManagerTrtc.recyclerCloudViewView(userId);
                    UserModel userModel = (UserModel)TRTCVideoCallActivity.this.mCallUserModelMap.remove(userId);
                    if (userModel != null) {
                        TRTCVideoCallActivity.this.mCallUserModelList.remove(userModel);
                    }
                }
            });
        }

        @Override
        public void onReject(final String userId) {
            TRTCVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TRTCVideoCallActivity.this.mCallUserModelMap.containsKey(userId)) {
                        TRTCVideoCallActivity.this.mLayoutManagerTrtc.recyclerCloudViewView(userId);
                        UserModel userModel = (UserModel)TRTCVideoCallActivity.this.mCallUserModelMap.remove(userId);
                        if (userModel != null) {
                            TRTCVideoCallActivity.this.mCallUserModelList.remove(userModel);
                            ToastUtil.toastLongMessage(userModel.userName + TRTCVideoCallActivity.this.getString(R.string.reject_calls));
                        }
                    }
                }
            });
        }

        @Override
        public void onNoResp(final String userId) {
            TRTCVideoCallActivity.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (TRTCVideoCallActivity.this.mCallUserModelMap.containsKey(userId)) {
                        TRTCVideoCallActivity.this.mLayoutManagerTrtc.recyclerCloudViewView(userId);
                        UserModel userModel = (UserModel)TRTCVideoCallActivity.this.mCallUserModelMap.remove(userId);
                        if (userModel != null) {
                            TRTCVideoCallActivity.this.mCallUserModelList.remove(userModel);
                            ToastUtil.toastLongMessage(userModel.userName + TRTCVideoCallActivity.this.getString(R.string.no_response));
                        }
                    }
                }
            });
        }

        @Override
        public void onLineBusy(String userId) {
            if (TRTCVideoCallActivity.this.mCallUserModelMap.containsKey(userId)) {
                TRTCVideoCallActivity.this.mLayoutManagerTrtc.recyclerCloudViewView(userId);
                UserModel userModel = (UserModel)TRTCVideoCallActivity.this.mCallUserModelMap.remove(userId);
                if (userModel != null) {
                    TRTCVideoCallActivity.this.mCallUserModelList.remove(userModel);
                    ToastUtil.toastLongMessage(userModel.userName + TRTCVideoCallActivity.this.getString(R.string.line_busy));
                }
            }
        }

        @Override
        public void onCallingCancel() {
            if (TRTCVideoCallActivity.this.mSponsorUserModel != null) {
                ToastUtil.toastLongMessage(((TRTCVideoCallActivity)TRTCVideoCallActivity.this).mSponsorUserModel.userName + TRTCVideoCallActivity.this.getString(R.string.cancle_calling));
            }
            TRTCVideoCallActivity.this.finishActivity();
        }

        @Override
        public void onCallingTimeout() {
            if (TRTCVideoCallActivity.this.mSponsorUserModel != null) {
                ToastUtil.toastLongMessage(((TRTCVideoCallActivity)TRTCVideoCallActivity.this).mSponsorUserModel.userName + TRTCVideoCallActivity.this.getString(R.string.call_time_out));
            }
            TRTCVideoCallActivity.this.finishActivity();
        }

        @Override
        public void onCallEnd() {
            TRTCVideoCallActivity.this.finishActivity();
        }

        @Override
        public void onUserVideoAvailable(String userId, boolean isVideoAvailable) {
            TRTCVideoLayout layout2 = TRTCVideoCallActivity.this.mLayoutManagerTrtc.findCloudViewView(userId);
            if (layout2 != null) {
                layout2.setVideoAvailable(isVideoAvailable);
                if (isVideoAvailable) {
                    TRTCVideoCallActivity.this.mITRTCAVCall.startRemoteView(userId, layout2.getVideoView());
                } else {
                    TRTCVideoCallActivity.this.mITRTCAVCall.stopRemoteView(userId);
                }
            }
        }

        @Override
        public void onUserAudioAvailable(String userId, boolean isVideoAvailable) {
        }

        @Override
        public void onUserVoiceVolume(Map<String, Integer> volumeMap) {
            for (Map.Entry<String, Integer> entry : volumeMap.entrySet()) {
                String userId = entry.getKey();
                TRTCVideoLayout layout2 = TRTCVideoCallActivity.this.mLayoutManagerTrtc.findCloudViewView(userId);
                if (layout2 == null) continue;
                layout2.setAudioVolumeProgress(entry.getValue());
            }
        }
    };
    private ImageView mSponsorAvatarImg;
    private TextView mSponsorUserNameTv;
    private Group mSponsorGroup;

    public static void startCallSomeone(Context context, List<UserModel> models) {
        TUIKitLog.i(TAG, "startCallSomeone");
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance(context)).setWaitingLastActivityFinished(false);
        Intent starter = new Intent(context, TRTCVideoCallActivity.class);
        starter.putExtra(PARAM_TYPE, 2);
        starter.putExtra(PARAM_USER, (Serializable)new IntentParams(models));
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    public static void startCallSomePeople(Context context, List<UserModel> models, String groupId) {
        TUIKitLog.i(TAG, "startCallSomePeople");
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance(context)).setWaitingLastActivityFinished(false);
        Intent starter = new Intent(context, TRTCVideoCallActivity.class);
        starter.putExtra(PARAM_GROUP_ID, groupId);
        starter.putExtra(PARAM_TYPE, 2);
        starter.putExtra(PARAM_USER, (Serializable)new IntentParams(models));
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    public static void startBeingCall(Context context, UserModel beingCallUserModel, List<UserModel> otherInvitingUserModel) {
        TUIKitLog.i(TAG, "startBeingCall");
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance(context)).setWaitingLastActivityFinished(false);
        Intent starter = new Intent(context, TRTCVideoCallActivity.class);
        starter.putExtra(PARAM_TYPE, 1);
        starter.putExtra(PARAM_BEINGCALL_USER, (Serializable)beingCallUserModel);
        starter.putExtra(PARAM_OTHER_INVITING_USER, (Serializable)new IntentParams(otherInvitingUserModel));
        starter.setFlags(0x10000000);
        context.startActivity(starter);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        TUIKitLog.i(TAG, "onCreate");
        this.mCallType = this.getIntent().getIntExtra(PARAM_TYPE, 1);
        TUIKitLog.i(TAG, "mCallType: " + this.mCallType);
        if (this.mCallType == 1 && ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance((Context)this)).isWaitingLastActivityFinished()) {
            TUIKitLog.w(TAG, "ignore activity launch");
            this.finishActivity();
            return;
        }
        NotificationManager manager = (NotificationManager)this.getSystemService("notification");
        if (manager != null) {
            manager.cancelAll();
        }
        this.getWindow().addFlags(128);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.videocall_activity_online_call);
        PermissionUtils.checkPermission((Context)this, "android.permission.CAMERA");
        PermissionUtils.checkPermission((Context)this, "android.permission.RECORD_AUDIO");
        this.mVibrator = (Vibrator)this.getSystemService("vibrator");
        this.mRingtone = RingtoneManager.getRingtone((Context)this, (Uri)RingtoneManager.getDefaultUri((int)1));
        this.initView();
        this.initData();
        this.initListener();
    }

    private void finishActivity() {
        ((TRTCAVCallImpl)TRTCAVCallImpl.sharedInstance((Context)this)).setWaitingLastActivityFinished(true);
        this.finish();
    }

    public void onBackPressed() {
        this.mITRTCAVCall.hangup();
        super.onBackPressed();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mVibrator != null) {
            this.mVibrator.cancel();
        }
        if (this.mRingtone != null) {
            this.mRingtone.stop();
        }
        if (this.mITRTCAVCall != null) {
            this.mITRTCAVCall.closeCamera();
            this.mITRTCAVCall.removeListener(this.mTRTCAVCallListener);
        }
        this.stopTimeCount();
        if (this.mTimeHandlerThread != null) {
            this.mTimeHandlerThread.quit();
        }
    }

    private void initListener() {
        this.mMuteLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCVideoCallActivity.this.isMuteMic = !TRTCVideoCallActivity.this.isMuteMic;
                TRTCVideoCallActivity.this.mITRTCAVCall.setMicMute(TRTCVideoCallActivity.this.isMuteMic);
                TRTCVideoCallActivity.this.mMuteImg.setActivated(TRTCVideoCallActivity.this.isMuteMic);
                ToastUtil.toastLongMessage(TRTCVideoCallActivity.this.isMuteMic ? TRTCVideoCallActivity.this.getString(R.string.open_silent) : TRTCVideoCallActivity.this.getString(R.string.close_silent));
            }
        });
        this.mHandsfreeLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCVideoCallActivity.this.isHandsFree = !TRTCVideoCallActivity.this.isHandsFree;
                TRTCVideoCallActivity.this.mITRTCAVCall.setHandsFree(TRTCVideoCallActivity.this.isHandsFree);
                TRTCVideoCallActivity.this.mHandsfreeImg.setActivated(TRTCVideoCallActivity.this.isHandsFree);
                ToastUtil.toastLongMessage(TRTCVideoCallActivity.this.isHandsFree ? TRTCVideoCallActivity.this.getString(R.string.use_speakers) : TRTCVideoCallActivity.this.getString(R.string.use_handset));
            }
        });
        this.mMuteImg.setActivated(this.isMuteMic);
        this.mHandsfreeImg.setActivated(this.isHandsFree);
    }

    private void initData() {
        this.mITRTCAVCall = TRTCAVCallImpl.sharedInstance((Context)this);
        this.mITRTCAVCall.addListener(this.mTRTCAVCallListener);
        this.mTimeHandlerThread = new HandlerThread("time-count-thread");
        this.mTimeHandlerThread.start();
        this.mTimeHandler = new Handler(this.mTimeHandlerThread.getLooper());
        Intent intent = this.getIntent();
        this.mSelfModel = ProfileManager.getInstance().getUserModel();
        this.mCallType = intent.getIntExtra(PARAM_TYPE, 1);
        this.mGroupId = intent.getStringExtra(PARAM_GROUP_ID);
        if (this.mCallType == 1) {
            this.mSponsorUserModel = (UserModel)intent.getSerializableExtra(PARAM_BEINGCALL_USER);
            IntentParams params = (IntentParams)intent.getSerializableExtra(PARAM_OTHER_INVITING_USER);
            if (params != null) {
                this.mOtherInvitingUserModelList = params.mUserModels;
            }
            this.showWaitingResponseView();
            this.mVibrator.vibrate(new long[]{0L, 1000L, 1000L}, 0);
            this.mRingtone.play();
        } else {
            IntentParams params = (IntentParams)intent.getSerializableExtra(PARAM_USER);
            if (params != null) {
                this.mCallUserModelList = params.mUserModels;
                for (UserModel userModel : this.mCallUserModelList) {
                    this.mCallUserModelMap.put(userModel.userId, userModel);
                }
                this.startInviting();
                this.showInvitingView();
            }
        }
    }

    private void startInviting() {
        ArrayList<String> list = new ArrayList<String>();
        for (UserModel userModel : this.mCallUserModelList) {
            list.add(userModel.userId);
        }
        this.mITRTCAVCall.groupCall(list, 2, this.mGroupId);
    }

    private void initView() {
        this.mMuteImg = (ImageView)this.findViewById(R.id.img_mute);
        this.mMuteLl = (LinearLayout)this.findViewById(R.id.ll_mute);
        this.mHangupImg = (ImageView)this.findViewById(R.id.img_hangup);
        this.mHangupLl = (LinearLayout)this.findViewById(R.id.ll_hangup);
        this.mHandsfreeImg = (ImageView)this.findViewById(R.id.img_handsfree);
        this.mHandsfreeLl = (LinearLayout)this.findViewById(R.id.ll_handsfree);
        this.mDialingImg = (ImageView)this.findViewById(R.id.img_dialing);
        this.mDialingLl = (LinearLayout)this.findViewById(R.id.ll_dialing);
        this.mLayoutManagerTrtc = (TRTCVideoLayoutManager)this.findViewById(R.id.trtc_layout_manager);
        this.mInvitingGroup = (Group)this.findViewById(R.id.group_inviting);
        this.mImgContainerLl = (LinearLayout)this.findViewById(R.id.ll_img_container);
        this.mTimeTv = (TextView)this.findViewById(R.id.tv_time);
        this.mSponsorAvatarImg = (ImageView)this.findViewById(R.id.img_sponsor_avatar);
        this.mSponsorUserNameTv = (TextView)this.findViewById(R.id.tv_sponsor_user_name);
        this.mSponsorGroup = (Group)this.findViewById(R.id.group_sponsor);
    }

    public void showWaitingResponseView() {
        this.mLayoutManagerTrtc.setMySelfUserId(this.mSelfModel.userId);
        TRTCVideoLayout videoLayout = this.addUserToManager(this.mSelfModel);
        if (videoLayout == null) {
            return;
        }
        videoLayout.setVideoAvailable(true);
        this.mITRTCAVCall.openCamera(true, videoLayout.getVideoView());
        this.mSponsorGroup.setVisibility(0);
        GlideEngine.loadCornerImage(this.mSponsorAvatarImg, this.mSponsorUserModel.userAvatar, null, 30.0f);
        this.mSponsorUserNameTv.setText((CharSequence)this.mSponsorUserModel.userName);
        this.mHangupLl.setVisibility(0);
        this.mDialingLl.setVisibility(0);
        this.mHandsfreeLl.setVisibility(8);
        this.mMuteLl.setVisibility(8);
        this.mHangupLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCVideoCallActivity.this.mVibrator.cancel();
                TRTCVideoCallActivity.this.mRingtone.stop();
                TRTCVideoCallActivity.this.mITRTCAVCall.reject();
                TRTCVideoCallActivity.this.finishActivity();
            }
        });
        this.mDialingLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCVideoCallActivity.this.mVibrator.cancel();
                TRTCVideoCallActivity.this.mRingtone.stop();
                TRTCVideoCallActivity.this.mITRTCAVCall.accept();
                TRTCVideoCallActivity.this.showCallingView();
            }
        });
        this.showOtherInvitingUserView();
    }

    public void showInvitingView() {
        this.mLayoutManagerTrtc.setMySelfUserId(this.mSelfModel.userId);
        TRTCVideoLayout videoLayout = this.addUserToManager(this.mSelfModel);
        if (videoLayout == null) {
            return;
        }
        videoLayout.setVideoAvailable(true);
        this.mITRTCAVCall.openCamera(true, videoLayout.getVideoView());
        this.mHangupLl.setVisibility(0);
        this.mHangupLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCVideoCallActivity.this.mITRTCAVCall.hangup();
                TRTCVideoCallActivity.this.finishActivity();
            }
        });
        this.mDialingLl.setVisibility(8);
        this.mHandsfreeLl.setVisibility(8);
        this.mMuteLl.setVisibility(8);
        this.hideOtherInvitingUserView();
        this.mSponsorGroup.setVisibility(8);
    }

    public void showCallingView() {
        this.mSponsorGroup.setVisibility(8);
        this.mHangupLl.setVisibility(0);
        this.mDialingLl.setVisibility(8);
        this.mHandsfreeLl.setVisibility(0);
        this.mMuteLl.setVisibility(0);
        this.mHangupLl.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCVideoCallActivity.this.mITRTCAVCall.hangup();
                TRTCVideoCallActivity.this.finishActivity();
            }
        });
        this.showTimeCount();
        this.hideOtherInvitingUserView();
    }

    private void showTimeCount() {
        if (this.mTimeRunnable != null) {
            return;
        }
        this.mTimeCount = 0;
        this.mTimeTv.setText((CharSequence)this.getShowTime(this.mTimeCount));
        if (this.mTimeRunnable == null) {
            this.mTimeRunnable = new Runnable(){

                @Override
                public void run() {
                    TRTCVideoCallActivity.this.mTimeCount++;
                    if (TRTCVideoCallActivity.this.mTimeTv != null) {
                        TRTCVideoCallActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                TRTCVideoCallActivity.this.mTimeTv.setText((CharSequence)TRTCVideoCallActivity.this.getShowTime(TRTCVideoCallActivity.this.mTimeCount));
                            }
                        });
                    }
                    TRTCVideoCallActivity.this.mTimeHandler.postDelayed(TRTCVideoCallActivity.this.mTimeRunnable, 1000L);
                }
            };
        }
        this.mTimeHandler.postDelayed(this.mTimeRunnable, 1000L);
    }

    private void stopTimeCount() {
        if (this.mTimeHandler != null) {
            this.mTimeHandler.removeCallbacks(this.mTimeRunnable);
        }
        this.mTimeRunnable = null;
    }

    private String getShowTime(int count) {
        return String.format("%02d:%02d", count / 60, count % 60);
    }

    private void showOtherInvitingUserView() {
        if (this.mOtherInvitingUserModelList == null || this.mOtherInvitingUserModelList.size() == 0) {
            return;
        }
        this.mInvitingGroup.setVisibility(0);
        int squareWidth = this.getResources().getDimensionPixelOffset(R.dimen.small_image_size);
        int leftMargin = this.getResources().getDimensionPixelOffset(R.dimen.small_image_left_margin);
        for (int index = 0; index < this.mOtherInvitingUserModelList.size() && index < 4; ++index) {
            UserModel userModel = this.mOtherInvitingUserModelList.get(index);
            ImageView imageView = new ImageView((Context)this);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(squareWidth, squareWidth);
            if (index != 0) {
                layoutParams.leftMargin = leftMargin;
            }
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            GlideEngine.loadCornerImage(imageView, userModel.userAvatar, null, 30.0f);
            this.mImgContainerLl.addView((View)imageView);
        }
    }

    private void hideOtherInvitingUserView() {
        this.mInvitingGroup.setVisibility(8);
    }

    private TRTCVideoLayout addUserToManager(UserModel userModel) {
        TRTCVideoLayout layout2 = this.mLayoutManagerTrtc.allocCloudVideoView(userModel.userId);
        if (layout2 == null) {
            return null;
        }
        layout2.getUserNameTv().setText((CharSequence)userModel.userName);
        if (!TextUtils.isEmpty((CharSequence)userModel.userAvatar)) {
            GlideEngine.loadCornerImage((ImageView)layout2.getHeadImg(), userModel.userAvatar, null, 30.0f);
        }
        return layout2;
    }
}

