/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcvideocalldemo.ui.videolayout;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tencent.liteav.trtcvideocalldemo.ui.videolayout.SquareImageView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.rtmp.ui.TXCloudVideoView;

public class TRTCVideoLayout
extends RelativeLayout {
    private boolean mMoveable;
    private TXCloudVideoView mTcCloudViewTrtc;
    private SquareImageView mHeadImg;
    private TextView mUserNameTv;
    private FrameLayout mFlNoVideo;
    private ProgressBar mAudioPb;

    public TRTCVideoLayout(Context context) {
        this(context, null);
    }

    public TRTCVideoLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
        this.setClickable(true);
    }

    public TXCloudVideoView getVideoView() {
        return this.mTcCloudViewTrtc;
    }

    public SquareImageView getHeadImg() {
        return this.mHeadImg;
    }

    public TextView getUserNameTv() {
        return this.mUserNameTv;
    }

    public void setVideoAvailable(boolean available) {
        if (available) {
            this.mTcCloudViewTrtc.setVisibility(0);
            this.mFlNoVideo.setVisibility(8);
        } else {
            this.mTcCloudViewTrtc.setVisibility(8);
            this.mFlNoVideo.setVisibility(0);
        }
    }

    public void setAudioVolumeProgress(int progress) {
        if (this.mAudioPb != null) {
            this.mAudioPb.setProgress(progress);
        }
    }

    public void setAudioVolumeProgressBarVisibility(int visibility) {
        if (this.mAudioPb != null) {
            this.mAudioPb.setVisibility(visibility);
        }
    }

    private void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.videocall_item_user_user_layout, (ViewGroup)this, true);
        this.mTcCloudViewTrtc = (TXCloudVideoView)this.findViewById(R.id.trtc_tc_cloud_view);
        this.mHeadImg = (SquareImageView)this.findViewById(R.id.img_avatar);
        this.mUserNameTv = (TextView)this.findViewById(R.id.tv_user_name);
        this.mFlNoVideo = (FrameLayout)this.findViewById(R.id.fl_no_video);
        this.mAudioPb = (ProgressBar)this.findViewById(R.id.pb_audio);
    }

    public boolean isMoveable() {
        return this.mMoveable;
    }

    public void setMoveable(boolean enable) {
        this.mMoveable = enable;
    }
}

