/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcvideocalldemo.ui.videolayout;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tencent.liteav.trtcvideocalldemo.ui.videolayout.TRTCVideoLayout;
import com.tencent.liteav.trtcvideocalldemo.ui.videolayout.Utils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class TRTCVideoLayoutManager
extends RelativeLayout {
    public static final int MODE_FLOAT = 1;
    public static final int MODE_GRID = 2;
    public static final int MAX_USER = 9;
    private static final String TAG = TRTCVideoLayoutManager.class.getSimpleName();
    private LinkedList<TRTCLayoutEntity> mLayoutEntityList;
    private ArrayList<RelativeLayout.LayoutParams> mFloatParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid4ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid9ParamList;
    private int mCount = 0;
    private int mMode;
    private String mSelfUserId;
    private Context mContext;

    public TRTCVideoLayoutManager(Context context) {
        this(context, null);
    }

    public TRTCVideoLayoutManager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.initView(context);
    }

    private void initView(Context context) {
        TUIKitLog.i(TAG, "initView: ");
        this.mLayoutEntityList = new LinkedList();
        this.mMode = 1;
        this.post(new Runnable(){

            @Override
            public void run() {
                TRTCVideoLayoutManager.this.makeFloatLayout();
            }
        });
    }

    public void setMySelfUserId(String userId) {
        this.mSelfUserId = userId;
    }

    public int switchMode() {
        if (this.mMode == 1) {
            this.mMode = 2;
            this.makeGirdLayout(true);
        } else {
            this.mMode = 1;
            this.makeFloatLayout();
        }
        return this.mMode;
    }

    public TRTCVideoLayout findCloudViewView(String userId) {
        if (userId == null) {
            return null;
        }
        for (TRTCLayoutEntity layoutEntity : this.mLayoutEntityList) {
            if (!layoutEntity.userId.equals(userId)) continue;
            return layoutEntity.layout;
        }
        return null;
    }

    public TRTCVideoLayout allocCloudVideoView(String userId) {
        if (userId == null) {
            return null;
        }
        if (this.mCount > 9) {
            return null;
        }
        TRTCLayoutEntity layoutEntity = new TRTCLayoutEntity();
        layoutEntity.userId = userId;
        layoutEntity.layout = new TRTCVideoLayout(this.mContext);
        layoutEntity.layout.setVisibility(0);
        this.initGestureListener(layoutEntity.layout);
        this.mLayoutEntityList.add(layoutEntity);
        this.addView((View)layoutEntity.layout);
        ++this.mCount;
        this.switchModeInternal();
        return layoutEntity.layout;
    }

    private void switchModeInternal() {
        if (this.mCount == 2) {
            this.mMode = 1;
            this.makeFloatLayout();
            return;
        }
        if (this.mCount == 3) {
            this.mMode = 2;
            this.makeGirdLayout(true);
            return;
        }
        if (this.mCount >= 4 && this.mMode == 2) {
            this.makeGirdLayout(true);
            return;
        }
    }

    private void initGestureListener(final TRTCVideoLayout layout2) {
        final GestureDetector detector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                layout2.performClick();
                return false;
            }

            public boolean onDown(MotionEvent e) {
                return true;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (!layout2.isMoveable()) {
                    return false;
                }
                ViewGroup.LayoutParams params = layout2.getLayoutParams();
                if (params instanceof RelativeLayout.LayoutParams) {
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)layout2.getLayoutParams();
                    int newX = (int)((float)layoutParams.leftMargin + (e2.getX() - e1.getX()));
                    int newY = (int)((float)layoutParams.topMargin + (e2.getY() - e1.getY()));
                    if (newX >= 0 && newX <= TRTCVideoLayoutManager.this.getWidth() - layout2.getWidth() && newY >= 0 && newY <= TRTCVideoLayoutManager.this.getHeight() - layout2.getHeight()) {
                        layoutParams.leftMargin = newX;
                        layoutParams.topMargin = newY;
                        layout2.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                }
                return true;
            }
        });
        layout2.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                return detector.onTouchEvent(event);
            }
        });
    }

    public void recyclerCloudViewView(String userId) {
        if (userId == null) {
            return;
        }
        if (this.mMode == 1) {
            TRTCLayoutEntity entity = this.mLayoutEntityList.get(this.mLayoutEntityList.size() - 1);
            if (userId.equals(entity.userId)) {
                this.makeFullVideoView(this.mSelfUserId);
            }
        }
        Iterator iterator = this.mLayoutEntityList.iterator();
        while (iterator.hasNext()) {
            TRTCLayoutEntity item = (TRTCLayoutEntity)iterator.next();
            if (!item.userId.equals(userId)) continue;
            this.removeView((View)item.layout);
            iterator.remove();
            --this.mCount;
            break;
        }
        this.switchModeInternal();
    }

    public void hideAllAudioVolumeProgressBar() {
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            entity.layout.setAudioVolumeProgressBarVisibility(8);
        }
    }

    public void showAllAudioVolumeProgressBar() {
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            entity.layout.setAudioVolumeProgressBarVisibility(0);
        }
    }

    public void updateAudioVolume(String userId, int audioVolume) {
        if (userId == null) {
            return;
        }
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            if (entity.layout.getVisibility() != 0 || !userId.equals(entity.userId)) continue;
            entity.layout.setAudioVolumeProgress(audioVolume);
        }
    }

    private TRTCLayoutEntity findEntity(TRTCVideoLayout layout2) {
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            if (entity.layout != layout2) continue;
            return entity;
        }
        return null;
    }

    private TRTCLayoutEntity findEntity(String userId) {
        for (TRTCLayoutEntity entity : this.mLayoutEntityList) {
            if (!entity.userId.equals(userId)) continue;
            return entity;
        }
        return null;
    }

    private void makeGirdLayout(boolean needUpdate) {
        if (this.mGrid4ParamList == null || this.mGrid4ParamList.size() == 0 || this.mGrid9ParamList == null || this.mGrid9ParamList.size() == 0) {
            this.mGrid4ParamList = Utils.initGrid4Param(this.getContext(), this.getWidth(), this.getHeight());
            this.mGrid9ParamList = Utils.initGrid9Param(this.getContext(), this.getWidth(), this.getHeight());
        }
        if (needUpdate) {
            ArrayList<RelativeLayout.LayoutParams> paramList = this.mCount <= 4 ? this.mGrid4ParamList : this.mGrid9ParamList;
            int layoutIndex = 1;
            for (int i = 0; i < this.mLayoutEntityList.size(); ++i) {
                TRTCLayoutEntity entity = this.mLayoutEntityList.get(i);
                entity.layout.setMoveable(false);
                entity.layout.setOnClickListener(null);
                if (entity.userId.equals(this.mSelfUserId)) {
                    entity.layout.setLayoutParams((ViewGroup.LayoutParams)paramList.get(0));
                    continue;
                }
                if (layoutIndex >= paramList.size()) continue;
                entity.layout.setLayoutParams((ViewGroup.LayoutParams)paramList.get(layoutIndex++));
            }
        }
    }

    private void makeFloatLayout() {
        if (this.mFloatParamList == null || this.mFloatParamList.size() == 0) {
            this.mFloatParamList = Utils.initFloatParamList(this.getContext(), this.getWidth(), this.getHeight());
        }
        int size = this.mLayoutEntityList.size();
        for (int i = 0; i < size; ++i) {
            TRTCLayoutEntity entity = this.mLayoutEntityList.get(size - i - 1);
            RelativeLayout.LayoutParams layoutParams = this.mFloatParamList.get(i);
            entity.layout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            if (i == 0) {
                entity.layout.setMoveable(false);
            } else {
                entity.layout.setMoveable(true);
            }
            this.addFloatViewClickListener(entity);
            this.bringChildToFront((View)entity.layout);
        }
    }

    private void addFloatViewClickListener(TRTCLayoutEntity entity) {
        final String userId = entity.userId;
        entity.layout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (!TextUtils.isEmpty((CharSequence)userId)) {
                    TRTCVideoLayoutManager.this.makeFullVideoView(userId);
                }
            }
        });
    }

    private void makeFullVideoView(String userId) {
        TUIKitLog.i(TAG, "makeFullVideoView: from = " + userId);
        TRTCLayoutEntity entity = this.findEntity(userId);
        this.mLayoutEntityList.remove(entity);
        this.mLayoutEntityList.addLast(entity);
        this.makeFloatLayout();
    }

    private static class TRTCLayoutEntity {
        public TRTCVideoLayout layout;
        public String userId = "";

        private TRTCLayoutEntity() {
        }
    }
}

