/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.trtcvideocalldemo.ui.videolayout;

import android.content.Context;
import android.widget.RelativeLayout;
import java.util.ArrayList;

public class Utils {
    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static ArrayList<RelativeLayout.LayoutParams> initFloatParamList(Context context, int layoutWidth, int layoutHeight) {
        RelativeLayout.LayoutParams layoutParams;
        int i;
        ArrayList<RelativeLayout.LayoutParams> list = new ArrayList<RelativeLayout.LayoutParams>();
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(-1, -1);
        list.add(layoutParams0);
        int midMargin = Utils.dip2px(context, 10.0f);
        int lrMargin = Utils.dip2px(context, 15.0f);
        int bottomMargin = Utils.dip2px(context, 50.0f);
        int subWidth = Utils.dip2px(context, 120.0f);
        int subHeight = Utils.dip2px(context, 180.0f);
        for (i = 2; i >= 0; --i) {
            layoutParams = new RelativeLayout.LayoutParams(subWidth, subHeight);
            layoutParams.leftMargin = layoutWidth - lrMargin - subWidth;
            layoutParams.topMargin = layoutHeight - (bottomMargin + midMargin * (i + 1) + subHeight * i) - subHeight;
            list.add(layoutParams);
        }
        for (i = 2; i >= 0; --i) {
            layoutParams = new RelativeLayout.LayoutParams(subWidth, subHeight);
            layoutParams.leftMargin = lrMargin;
            layoutParams.topMargin = layoutHeight - (bottomMargin + midMargin * (i + 1) + subHeight * i) - subHeight;
            list.add(layoutParams);
        }
        return list;
    }

    public static ArrayList<RelativeLayout.LayoutParams> initGrid4Param(Context context, int layoutWidth, int layoutHeight) {
        int margin = Utils.dip2px(context, 10.0f);
        int bottomMargin = Utils.dip2px(context, 50.0f);
        ArrayList<RelativeLayout.LayoutParams> list = new ArrayList<RelativeLayout.LayoutParams>();
        int grid4W = (layoutWidth - margin * 2) / 2;
        int grid4H = (layoutHeight - margin * 2 - bottomMargin) / 2;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams0.addRule(9);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = margin;
        layoutParams0.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams1.addRule(11);
        layoutParams1.addRule(10);
        layoutParams1.topMargin = margin;
        layoutParams1.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams2.addRule(9);
        layoutParams2.addRule(12);
        layoutParams2.bottomMargin = margin + bottomMargin;
        layoutParams2.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams3.addRule(11);
        layoutParams3.addRule(12);
        layoutParams3.bottomMargin = margin + bottomMargin;
        layoutParams3.rightMargin = margin;
        list.add(layoutParams0);
        list.add(layoutParams1);
        list.add(layoutParams2);
        list.add(layoutParams3);
        return list;
    }

    public static ArrayList<RelativeLayout.LayoutParams> initGrid9Param(Context context, int layoutWidth, int layoutHeight) {
        int margin = Utils.dip2px(context, 10.0f);
        int bottomMargin = Utils.dip2px(context, 50.0f);
        ArrayList<RelativeLayout.LayoutParams> list = new ArrayList<RelativeLayout.LayoutParams>();
        int grid9W = (layoutWidth - margin * 2) / 3;
        int grid9H = (layoutHeight - margin * 2 - bottomMargin) / 3;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams0.addRule(9);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = margin;
        layoutParams0.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams1.addRule(14);
        layoutParams1.addRule(10);
        layoutParams1.topMargin = margin;
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams2.addRule(11);
        layoutParams2.addRule(10);
        layoutParams2.topMargin = margin;
        layoutParams2.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams3.addRule(10);
        layoutParams3.addRule(9);
        layoutParams3.leftMargin = margin;
        layoutParams3.topMargin = margin + grid9H;
        RelativeLayout.LayoutParams layoutParams4 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams4.addRule(14);
        layoutParams4.topMargin = margin + grid9H;
        RelativeLayout.LayoutParams layoutParams5 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams5.addRule(10);
        layoutParams5.addRule(11);
        layoutParams5.topMargin = margin + grid9H;
        layoutParams5.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams6 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams6.addRule(9);
        layoutParams6.addRule(12);
        layoutParams6.bottomMargin = margin + bottomMargin;
        layoutParams6.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams7 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams7.addRule(14);
        layoutParams7.addRule(12);
        layoutParams7.bottomMargin = margin + bottomMargin;
        RelativeLayout.LayoutParams layoutParams8 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams8.addRule(11);
        layoutParams8.addRule(12);
        layoutParams8.bottomMargin = margin + bottomMargin;
        layoutParams8.rightMargin = margin;
        list.add(layoutParams0);
        list.add(layoutParams1);
        list.add(layoutParams2);
        list.add(layoutParams3);
        list.add(layoutParams4);
        list.add(layoutParams5);
        list.add(layoutParams6);
        list.add(layoutParams7);
        list.add(layoutParams8);
        return list;
    }
}

