/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.google.gson.Gson;
import com.tencent.imsdk.v2.V2TIMAdvancedMsgListener;
import com.tencent.imsdk.v2.V2TIMCallback;
import com.tencent.imsdk.v2.V2TIMConversation;
import com.tencent.imsdk.v2.V2TIMConversationListener;
import com.tencent.imsdk.v2.V2TIMGroupChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupListener;
import com.tencent.imsdk.v2.V2TIMGroupMemberChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMMessageReceipt;
import com.tencent.imsdk.v2.V2TIMSDKConfig;
import com.tencent.imsdk.v2.V2TIMSDKListener;
import com.tencent.liteav.AVCallManager;
import com.tencent.liteav.login.ProfileManager;
import com.tencent.liteav.login.UserModel;
import com.tencent.qcloud.tim.uikit.base.IMEventListener;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.face.FaceManager;
import com.tencent.qcloud.tim.uikit.config.GeneralConfig;
import com.tencent.qcloud.tim.uikit.config.TUIKitConfigs;
import com.tencent.qcloud.tim.uikit.modules.chat.C2CChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.chat.GroupChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.modules.message.MessageRevokedManager;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.NetWorkUtils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TUIKitImpl {
    private static final String TAG = "TUIKit";
    private static Context sAppContext;
    private static TUIKitConfigs sConfigs;
    private static List<IMEventListener> sIMEventListeners;
    private static Gson sGson;

    public static void init(Context context, int sdkAppID, TUIKitConfigs configs) {
        TUIKitLog.e(TAG, "init tuikit version: 5.1.56");
        sAppContext = context;
        sConfigs = configs;
        if (sConfigs.getGeneralConfig() == null) {
            GeneralConfig generalConfig = new GeneralConfig();
            sConfigs.setGeneralConfig(generalConfig);
        }
        sConfigs.getGeneralConfig().setSDKAppId(sdkAppID);
        String dir = sConfigs.getGeneralConfig().getAppCacheDir();
        if (TextUtils.isEmpty((CharSequence)dir)) {
            TUIKitLog.e(TAG, "appCacheDir is empty, use default dir");
            sConfigs.getGeneralConfig().setAppCacheDir(context.getFilesDir().getPath());
        } else {
            File file = new File(dir);
            if (file.exists()) {
                if (file.isFile()) {
                    TUIKitLog.e(TAG, "appCacheDir is a file, use default dir");
                    sConfigs.getGeneralConfig().setAppCacheDir(context.getFilesDir().getPath());
                } else if (!file.canWrite()) {
                    TUIKitLog.e(TAG, "appCacheDir can not write, use default dir");
                    sConfigs.getGeneralConfig().setAppCacheDir(context.getFilesDir().getPath());
                }
            } else {
                boolean ret = file.mkdirs();
                if (!ret) {
                    TUIKitLog.e(TAG, "appCacheDir is invalid, use default dir");
                    sConfigs.getGeneralConfig().setAppCacheDir(context.getFilesDir().getPath());
                }
            }
        }
        TUIKitImpl.initIM(context, sdkAppID);
        TUIKitImpl.initTUIKitLive(context);
        BackgroundTasks.initInstance();
        FileUtil.initPath();
        FaceManager.loadFaceFiles();
    }

    public static void login(final String userid, final String usersig, final IUIKitCallBack callback) {
        TUIKitConfigs.getConfigs().getGeneralConfig().setUserId(userid);
        TUIKitConfigs.getConfigs().getGeneralConfig().setUserSig(usersig);
        V2TIMManager.getInstance().login(userid, usersig, new V2TIMCallback(){

            public void onError(int code, String desc) {
                callback.onError(TUIKitImpl.TAG, code, desc);
            }

            public void onSuccess() {
                if (TUIKitConfigs.getConfigs().getGeneralConfig().isSupportAVCall()) {
                    UserModel self = new UserModel();
                    self.userId = userid;
                    self.userSig = usersig;
                    ProfileManager.getInstance().setUserModel(self);
                    AVCallManager.getInstance().init(sAppContext);
                }
                TUIKitImpl.loginTUIKitLive(TUIKitConfigs.getConfigs().getGeneralConfig().getSDKAppId(), userid, usersig);
                callback.onSuccess(null);
            }
        });
    }

    public static void logout(final IUIKitCallBack callback) {
        V2TIMManager.getInstance().logout(new V2TIMCallback(){

            public void onError(int code, String desc) {
                callback.onError(TUIKitImpl.TAG, code, desc);
            }

            public void onSuccess() {
                callback.onSuccess(null);
                if (!TUIKitConfigs.getConfigs().getGeneralConfig().isSupportAVCall()) {
                    return;
                }
                Intent intent = new Intent(sAppContext, AVCallManager.class);
                sAppContext.stopService(intent);
                TUIKitImpl.logoutTUIKitLive();
            }
        });
    }

    private static void initIM(final Context context, int sdkAppID) {
        V2TIMSDKConfig sdkConfig = sConfigs.getSdkConfig();
        if (sdkConfig == null) {
            sdkConfig = new V2TIMSDKConfig();
            sConfigs.setSdkConfig(sdkConfig);
        }
        GeneralConfig generalConfig = sConfigs.getGeneralConfig();
        sdkConfig.setLogLevel(generalConfig.getLogLevel());
        sGson = new Gson();
        V2TIMManager.getInstance().initSDK(context, sdkAppID, sdkConfig, new V2TIMSDKListener(){

            public void onConnecting() {
            }

            public void onConnectSuccess() {
                NetWorkUtils.sIMSDKConnected = true;
                for (IMEventListener l : sIMEventListeners) {
                    l.onConnected();
                }
            }

            public void onConnectFailed(int code, String error) {
                NetWorkUtils.sIMSDKConnected = false;
                for (IMEventListener l : sIMEventListeners) {
                    l.onDisconnected(code, error);
                }
            }

            public void onKickedOffline() {
                for (IMEventListener l : sIMEventListeners) {
                    l.onForceOffline();
                }
                TUIKitImpl.unInit();
            }

            public void onUserSigExpired() {
                for (IMEventListener l : sIMEventListeners) {
                    l.onUserSigExpired();
                }
                TUIKitImpl.unInit();
            }
        });
        V2TIMManager.getConversationManager().setConversationListener(new V2TIMConversationListener(){

            public void onSyncServerStart() {
                super.onSyncServerStart();
            }

            public void onSyncServerFinish() {
                super.onSyncServerFinish();
            }

            public void onSyncServerFailed() {
                super.onSyncServerFailed();
            }

            public void onNewConversation(List<V2TIMConversation> conversationList) {
                ConversationManagerKit.getInstance().onRefreshConversation(conversationList);
                for (IMEventListener listener : sIMEventListeners) {
                    listener.onRefreshConversation(conversationList);
                }
            }

            public void onConversationChanged(List<V2TIMConversation> conversationList) {
                ConversationManagerKit.getInstance().onRefreshConversation(conversationList);
                for (IMEventListener listener : sIMEventListeners) {
                    listener.onRefreshConversation(conversationList);
                }
            }
        });
        V2TIMManager.getInstance().setGroupListener(new V2TIMGroupListener(){

            public void onMemberEnter(String groupID, List<V2TIMGroupMemberInfo> memberList) {
                TUIKitLog.i(TUIKitImpl.TAG, "onMemberEnter groupID:" + groupID + ", size:" + memberList.size());
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onMemberEnter");
                intent.putExtra("groupId", groupID);
                intent.putExtra("member", sGson.toJson(memberList));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                for (V2TIMGroupMemberInfo v2TIMGroupMemberInfo : memberList) {
                    String userID = v2TIMGroupMemberInfo.getUserID();
                    if (userID == null || !userID.equals(V2TIMManager.getInstance().getLoginUser())) continue;
                    GroupChatManagerKit.getInstance().notifyJoinGroup(groupID, false);
                    return;
                }
            }

            public void onMemberLeave(String groupID, V2TIMGroupMemberInfo member) {
                TUIKitLog.i(TUIKitImpl.TAG, "onMemberLeave groupID:" + groupID + ", memberID:" + member.getUserID());
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onMemberLeave");
                intent.putExtra("groupId", groupID);
                intent.putExtra("member", sGson.toJson((Object)member));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }

            public void onMemberInvited(String groupID, V2TIMGroupMemberInfo opUser, List<V2TIMGroupMemberInfo> memberList) {
                for (V2TIMGroupMemberInfo v2TIMGroupMemberInfo : memberList) {
                    String userID = v2TIMGroupMemberInfo.getUserID();
                    if (userID == null || !userID.equals(V2TIMManager.getInstance().getLoginUser())) continue;
                    GroupChatManagerKit.getInstance().notifyJoinGroup(groupID, true);
                    return;
                }
            }

            public void onMemberKicked(String groupID, V2TIMGroupMemberInfo opUser, List<V2TIMGroupMemberInfo> memberList) {
                for (V2TIMGroupMemberInfo v2TIMGroupMemberInfo : memberList) {
                    String userID = v2TIMGroupMemberInfo.getUserID();
                    if (userID == null || !userID.equals(V2TIMManager.getInstance().getLoginUser())) continue;
                    GroupChatManagerKit.getInstance().notifyKickedFromGroup(groupID);
                    return;
                }
            }

            public void onMemberInfoChanged(String groupID, List<V2TIMGroupMemberChangeInfo> v2TIMGroupMemberChangeInfoList) {
            }

            public void onGroupCreated(String groupID) {
            }

            public void onGroupDismissed(String groupID, V2TIMGroupMemberInfo opUser) {
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onGroupDismissed");
                intent.putExtra("groupId", groupID);
                intent.putExtra("opUser", sGson.toJson((Object)opUser));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                GroupChatManagerKit.getInstance().notifyGroupDismissed(groupID);
            }

            public void onGroupRecycled(String groupID, V2TIMGroupMemberInfo opUser) {
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onGroupRecycled");
                intent.putExtra("groupId", groupID);
                intent.putExtra("opUser", sGson.toJson((Object)opUser));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                GroupChatManagerKit.getInstance().notifyGroupDismissed(groupID);
            }

            public void onGroupInfoChanged(String groupID, List<V2TIMGroupChangeInfo> changeInfos) {
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onGroupInfoChanged");
                intent.putExtra("groupId", groupID);
                intent.putExtra("changeInfos", sGson.toJson(changeInfos));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }

            public void onReceiveJoinApplication(String groupID, V2TIMGroupMemberInfo member, String opReason) {
            }

            public void onApplicationProcessed(String groupID, V2TIMGroupMemberInfo opUser, boolean isAgreeJoin, String opReason) {
                if (!isAgreeJoin) {
                    GroupChatManagerKit.getInstance().notifyJoinGroupRefused(groupID);
                }
            }

            public void onGrantAdministrator(String groupID, V2TIMGroupMemberInfo opUser, List<V2TIMGroupMemberInfo> memberList) {
            }

            public void onRevokeAdministrator(String groupID, V2TIMGroupMemberInfo opUser, List<V2TIMGroupMemberInfo> memberList) {
            }

            public void onQuitFromGroup(String groupID) {
                TUIKitLog.i(TUIKitImpl.TAG, "onQuitFromGroup groupID:" + groupID);
            }

            public void onReceiveRESTCustomData(String groupID, byte[] customData) {
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onReceiveRESTCustomData");
                intent.putExtra("groupId", groupID);
                intent.putExtra("customData", customData);
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
                GroupChatManagerKit.getInstance().notifyGroupRESTCustomSystemData(groupID, customData);
            }

            public void onGroupAttributeChanged(String groupID, Map<String, String> groupAttributeMap) {
                Intent intent = new Intent("V2TIMGroupNotify");
                intent.putExtra("method", "V2TIMGroupNotify_onGroupAttributeChanged");
                intent.putExtra("groupId", groupID);
                intent.putExtra("groupAttributeMap", sGson.toJson(groupAttributeMap));
                LocalBroadcastManager.getInstance((Context)context).sendBroadcast(intent);
            }
        });
        V2TIMManager.getMessageManager().addAdvancedMsgListener(new V2TIMAdvancedMsgListener(){

            public void onRecvNewMessage(V2TIMMessage msg) {
                for (IMEventListener l : sIMEventListeners) {
                    l.onNewMessage(msg);
                }
            }

            public void onRecvC2CReadReceipt(List<V2TIMMessageReceipt> receiptList) {
                C2CChatManagerKit.getInstance().onReadReport(receiptList);
            }

            public void onRecvMessageRevoked(String msgID) {
                super.onRecvMessageRevoked(msgID);
            }
        });
        V2TIMManager.getMessageManager().addAdvancedMsgListener((V2TIMAdvancedMsgListener)MessageRevokedManager.getInstance());
    }

    public static void unInit() {
        ConversationManagerKit.getInstance().destroyConversation();
        if (!TUIKitConfigs.getConfigs().getGeneralConfig().isSupportAVCall()) {
            return;
        }
        AVCallManager.getInstance().unInit();
        TUIKitImpl.unInitTUIKitLive();
    }

    public static Context getAppContext() {
        return sAppContext;
    }

    public static TUIKitConfigs getConfigs() {
        if (sConfigs == null) {
            sConfigs = TUIKitConfigs.getConfigs();
        }
        return sConfigs;
    }

    public static void addIMEventListener(IMEventListener listener) {
        TUIKitLog.i(TAG, "addIMEventListener:" + sIMEventListeners.size() + "|l:" + listener);
        if (listener != null && !sIMEventListeners.contains(listener)) {
            sIMEventListeners.add(listener);
        }
    }

    public static void removeIMEventListener(IMEventListener listener) {
        TUIKitLog.i(TAG, "removeIMEventListener:" + sIMEventListeners.size() + "|l:" + listener);
        if (listener == null) {
            sIMEventListeners.clear();
        } else {
            sIMEventListeners.remove(listener);
        }
    }

    private static void initTUIKitLive(Context context) {
        try {
            Class<?> classz = Class.forName("com.tencent.qcloud.tim.tuikit.live.TUIKitLive");
            Method method = classz.getMethod("init", Context.class);
            method.invoke(null, context);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            TUIKitLog.e(TAG, "initTUIKitLive error: " + e.getMessage());
        }
    }

    private static void unInitTUIKitLive() {
        try {
            Class<?> classz = Class.forName("com.tencent.qcloud.tim.tuikit.live.TUIKitLive");
            Method method = classz.getMethod("unInit", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            TUIKitLog.e(TAG, "unInitTUIKitLive error: " + e.getMessage());
        }
    }

    private static void loginTUIKitLive(int sdkAppid, String userId, String userSig) {
        try {
            Class<?> classz = Class.forName("com.tencent.qcloud.tim.tuikit.live.TUIKitLive");
            Class<?> tClazz = Class.forName("com.tencent.qcloud.tim.tuikit.live.TUIKitLive$LoginCallback");
            Field field = classz.getDeclaredField("sIsAttachedTUIKit");
            field.setAccessible(true);
            field.set(null, true);
            Method method = classz.getMethod("login", Integer.TYPE, String.class, String.class, tClazz);
            method.invoke(null, sdkAppid, userId, userSig, null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            TUIKitLog.e(TAG, "loginTUIKitLive error: " + e.getMessage());
        }
    }

    private static void logoutTUIKitLive() {
        try {
            Class<?> classz = Class.forName("com.tencent.qcloud.tim.tuikit.live.TUIKitLive");
            Method method = classz.getMethod("logout", new Class[0]);
            method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            TUIKitLog.e(TAG, "logoutTUIKitLive error: " + e.getMessage());
        }
    }

    static {
        sIMEventListeners = new ArrayList<IMEventListener>();
    }
}

