/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.media.MediaPlayer;
import android.media.MediaRecorder;
import android.os.Handler;
import android.text.TextUtils;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;

public class AudioPlayer {
    private static final String TAG = AudioPlayer.class.getSimpleName();
    private static AudioPlayer sInstance = new AudioPlayer();
    private static String CURRENT_RECORD_FILE = TUIKitConstants.RECORD_DIR + "auto_";
    private static int MAGIC_NUMBER = 500;
    private static int MIN_RECORD_DURATION = 1000;
    private Callback mRecordCallback;
    private Callback mPlayCallback;
    private String mAudioRecordPath;
    private MediaPlayer mPlayer;
    private MediaRecorder mRecorder;
    private Handler mHandler = new Handler();

    private AudioPlayer() {
    }

    public static AudioPlayer getInstance() {
        return sInstance;
    }

    public void startRecord(Callback callback) {
        this.mRecordCallback = callback;
        try {
            this.mAudioRecordPath = CURRENT_RECORD_FILE + System.currentTimeMillis() + ".m4a";
            this.mRecorder = new MediaRecorder();
            this.mRecorder.setAudioSource(1);
            this.mRecorder.setOutputFormat(2);
            this.mRecorder.setOutputFile(this.mAudioRecordPath);
            this.mRecorder.setAudioEncoder(3);
            this.mRecorder.prepare();
            this.mRecorder.start();
            this.mHandler.removeCallbacksAndMessages(null);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    AudioPlayer.this.stopInternalRecord();
                    AudioPlayer.this.onRecordCompleted(true);
                    AudioPlayer.this.mRecordCallback = null;
                    ToastUtil.toastShortMessage(TUIKit.getAppContext().getString(R.string.record_limit_tips));
                }
            }, (long)(TUIKit.getConfigs().getGeneralConfig().getAudioRecordMaxTime() * 1000));
        }
        catch (Exception e) {
            TUIKitLog.w(TAG, "startRecord failed", e);
            this.stopInternalRecord();
            this.onRecordCompleted(false);
        }
    }

    public void stopRecord() {
        this.stopInternalRecord();
        this.onRecordCompleted(true);
        this.mRecordCallback = null;
    }

    private void stopInternalRecord() {
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.mRecorder == null) {
            return;
        }
        this.mRecorder.release();
        this.mRecorder = null;
    }

    public void startPlay(String filePath, Callback callback) {
        this.mAudioRecordPath = filePath;
        this.mPlayCallback = callback;
        try {
            this.mPlayer = new MediaPlayer();
            this.mPlayer.setDataSource(filePath);
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mp) {
                    AudioPlayer.this.stopInternalPlay();
                    AudioPlayer.this.onPlayCompleted(true);
                }
            });
            this.mPlayer.prepare();
            this.mPlayer.start();
        }
        catch (Exception e) {
            TUIKitLog.w(TAG, "startPlay failed", e);
            ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.play_error_tip));
            this.stopInternalPlay();
            this.onPlayCompleted(false);
        }
    }

    public void stopPlay() {
        this.stopInternalPlay();
        this.onPlayCompleted(false);
        this.mPlayCallback = null;
    }

    private void stopInternalPlay() {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.release();
        this.mPlayer = null;
    }

    public boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    private void onPlayCompleted(boolean success) {
        if (this.mPlayCallback != null) {
            this.mPlayCallback.onCompletion(success);
        }
        this.mPlayer = null;
    }

    private void onRecordCompleted(boolean success) {
        if (this.mRecordCallback != null) {
            this.mRecordCallback.onCompletion(success);
        }
        this.mRecorder = null;
    }

    public String getPath() {
        return this.mAudioRecordPath;
    }

    public int getDuration() {
        if (TextUtils.isEmpty((CharSequence)this.mAudioRecordPath)) {
            return 0;
        }
        int duration = 0;
        try {
            MediaPlayer mp = new MediaPlayer();
            mp.setDataSource(this.mAudioRecordPath);
            mp.prepare();
            duration = mp.getDuration();
            duration = duration < MIN_RECORD_DURATION ? 0 : (duration += MAGIC_NUMBER);
        }
        catch (Exception e) {
            TUIKitLog.w(TAG, "getDuration failed", e);
        }
        if (duration < 0) {
            duration = 0;
        }
        return duration;
    }

    public static interface Callback {
        public void onCompletion(Boolean var1);
    }
}

