/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.DrawableRes;

public class CircleImageView
extends ImageView {
    private static final Bitmap.Config BITMAP_CONFIG = Bitmap.Config.ARGB_8888;
    private static final int COLORDRAWABLE_DIMENSION = 2;
    private Bitmap mBitmap;
    private BitmapShader mBitmapShader;
    private Paint mPaint;

    public CircleImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    protected void onDraw(Canvas canvas) {
        if (this.mBitmap == null || this.mBitmapShader == null) {
            return;
        }
        if (this.mBitmap.getHeight() == 0 || this.mBitmap.getWidth() == 0) {
            return;
        }
        this.updateBitmapShader();
        this.mPaint.setShader((Shader)this.mBitmapShader);
        canvas.drawCircle((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f, Math.min((float)this.getWidth() / 2.0f, (float)this.getHeight() / 2.0f), this.mPaint);
    }

    private void init() {
        if (this.mBitmap == null) {
            return;
        }
        this.mBitmapShader = new BitmapShader(this.mBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
    }

    public void setImageBitmap(Bitmap bm) {
        super.setImageBitmap(bm);
        this.mBitmap = bm;
        this.init();
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        this.mBitmap = this.getBitmapFromDrawable(drawable2);
        this.init();
    }

    public void setImageResource(@DrawableRes int resId) {
        super.setImageResource(resId);
        this.mBitmap = this.getBitmapFromDrawable(this.getDrawable());
        this.init();
    }

    public void setImageURI(Uri uri) {
        super.setImageURI(uri);
        this.mBitmap = uri != null ? this.getBitmapFromDrawable(this.getDrawable()) : null;
        this.init();
    }

    private Bitmap getBitmapFromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            return null;
        }
        if (drawable2 instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        try {
            Bitmap bitmap = drawable2 instanceof ColorDrawable ? Bitmap.createBitmap((int)2, (int)2, (Bitmap.Config)BITMAP_CONFIG) : Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)BITMAP_CONFIG);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateBitmapShader() {
        if (this.mBitmap == null) {
            return;
        }
        int canvasSize = Math.min(this.getWidth(), this.getHeight());
        if (canvasSize == 0) {
            return;
        }
        if (canvasSize != this.mBitmap.getWidth() || canvasSize != this.mBitmap.getHeight()) {
            Matrix matrix = new Matrix();
            float scale = (float)canvasSize / (float)this.mBitmap.getWidth();
            matrix.setScale(scale, scale);
            this.mBitmapShader.setLocalMatrix(matrix);
        }
    }
}

