/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Switch;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;

public class LineControllerView
extends LinearLayout {
    private String mName;
    private boolean mIsBottom;
    private String mContent;
    private boolean mIsJump;
    private boolean mIsSwitch;
    private TextView mNameText;
    private TextView mContentText;
    private ImageView mNavArrowView;
    private Switch mSwitchView;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineControllerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.line_controller_view, (ViewGroup)this);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.LineControllerView, 0, 0);
        try {
            this.mName = ta.getString(R.styleable.LineControllerView_name);
            this.mContent = ta.getString(R.styleable.LineControllerView_subject);
            this.mIsBottom = ta.getBoolean(R.styleable.LineControllerView_isBottom, false);
            this.mIsJump = ta.getBoolean(R.styleable.LineControllerView_canNav, false);
            this.mIsSwitch = ta.getBoolean(R.styleable.LineControllerView_isSwitch, false);
            this.setUpView();
        }
        finally {
            ta.recycle();
        }
    }

    private void setUpView() {
        this.mNameText = (TextView)this.findViewById(R.id.name);
        this.mNameText.setText((CharSequence)this.mName);
        this.mContentText = (TextView)this.findViewById(R.id.content);
        this.mContentText.setText((CharSequence)this.mContent);
        View bottomLine = this.findViewById(R.id.bottomLine);
        bottomLine.setVisibility(this.mIsBottom ? 0 : 8);
        this.mNavArrowView = (ImageView)this.findViewById(R.id.rightArrow);
        this.mNavArrowView.setVisibility(this.mIsJump ? 0 : 8);
        RelativeLayout contentLayout = (RelativeLayout)this.findViewById(R.id.contentText);
        contentLayout.setVisibility(this.mIsSwitch ? 8 : 0);
        this.mSwitchView = (Switch)this.findViewById(R.id.btnSwitch);
        this.mSwitchView.setVisibility(this.mIsSwitch ? 0 : 8);
    }

    public String getContent() {
        return this.mContentText.getText().toString();
    }

    public void setContent(String content) {
        this.mContent = content;
        this.mContentText.setText((CharSequence)content);
    }

    public void setSingleLine(boolean singleLine) {
        this.mContentText.setSingleLine(singleLine);
    }

    public void setCanNav(boolean canNav) {
        this.mIsJump = canNav;
        this.mNavArrowView.setVisibility(canNav ? 0 : 8);
        if (canNav) {
            ViewGroup.LayoutParams params = this.mContentText.getLayoutParams();
            params.width = ScreenUtil.getPxByDp(120.0f);
            params.height = -2;
            this.mContentText.setLayoutParams(params);
            this.mContentText.setTextIsSelectable(false);
        } else {
            ViewGroup.LayoutParams params = this.mContentText.getLayoutParams();
            params.width = -2;
            params.height = -2;
            this.mContentText.setLayoutParams(params);
            this.mContentText.setTextIsSelectable(true);
        }
    }

    public boolean isChecked() {
        return this.mSwitchView.isChecked();
    }

    public void setChecked(boolean on) {
        this.mSwitchView.setChecked(on);
    }

    public void setCheckListener(CompoundButton.OnCheckedChangeListener listener) {
        this.mSwitchView.setOnCheckedChangeListener(listener);
    }
}

