/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.INoticeLayout;

public class NoticeLayout
extends RelativeLayout
implements INoticeLayout {
    private TextView mContentText;
    private TextView mContentExtraText;
    private boolean mAwaysShow;

    public NoticeLayout(Context context) {
        super(context);
        this.init();
    }

    public NoticeLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public NoticeLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        NoticeLayout.inflate((Context)this.getContext(), (int)R.layout.chat_notice_layout, (ViewGroup)this);
        this.mContentText = (TextView)this.findViewById(R.id.notice_content);
        this.mContentExtraText = (TextView)this.findViewById(R.id.notice_content_extra);
    }

    @Override
    public TextView getContent() {
        return this.mContentText;
    }

    @Override
    public TextView getContentExtra() {
        return this.mContentExtraText;
    }

    @Override
    public void setOnNoticeClickListener(View.OnClickListener l) {
        this.setOnClickListener(l);
    }

    public void setVisibility(int visibility) {
        if (this.mAwaysShow) {
            super.setVisibility(0);
        } else {
            super.setVisibility(visibility);
        }
    }

    @Override
    public void alwaysShow(boolean show) {
        this.mAwaysShow = show;
        if (this.mAwaysShow) {
            super.setVisibility(0);
        }
    }
}

