/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.InputFilter;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.component.TitleBarLayout;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;

public class SelectionActivity
extends Activity {
    private static OnResultReturnListener sOnResultReturnListener;
    private RadioGroup radioGroup;
    private EditText input;
    private int mSelectionType;

    public static void startTextSelection(Context context, Bundle bundle, OnResultReturnListener listener) {
        bundle.putInt("type", 1);
        SelectionActivity.startSelection(context, bundle, listener);
    }

    public static void startListSelection(Context context, Bundle bundle, OnResultReturnListener listener) {
        bundle.putInt("type", 2);
        SelectionActivity.startSelection(context, bundle, listener);
    }

    private static void startSelection(Context context, Bundle bundle, OnResultReturnListener listener) {
        Intent intent = new Intent(context, SelectionActivity.class);
        intent.putExtra("content", bundle);
        intent.addFlags(0x10000000);
        context.startActivity(intent);
        sOnResultReturnListener = listener;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.selection_activity);
        TitleBarLayout titleBar = (TitleBarLayout)this.findViewById(R.id.edit_title_bar);
        this.radioGroup = (RadioGroup)this.findViewById(R.id.content_list_rg);
        this.input = (EditText)this.findViewById(R.id.edit_content_et);
        Bundle bundle = this.getIntent().getBundleExtra("content");
        switch (bundle.getInt("type")) {
            case 1: {
                this.radioGroup.setVisibility(8);
                String defaultString = bundle.getString("init_content");
                int limit = bundle.getInt("limit");
                if (!TextUtils.isEmpty((CharSequence)defaultString)) {
                    this.input.setText((CharSequence)defaultString);
                    this.input.setSelection(defaultString.length());
                }
                if (limit <= 0) break;
                this.input.setFilters(new InputFilter[]{new InputFilter.LengthFilter(limit)});
                break;
            }
            case 2: {
                this.input.setVisibility(8);
                ArrayList list = bundle.getStringArrayList("list");
                if (list == null || list.size() == 0) {
                    return;
                }
                for (int i = 0; i < list.size(); ++i) {
                    RadioButton radioButton = new RadioButton((Context)this);
                    radioButton.setText((CharSequence)list.get(i));
                    radioButton.setId(i);
                    this.radioGroup.addView((View)radioButton, i, new ViewGroup.LayoutParams(-2, -2));
                }
                int checked = bundle.getInt("default_select_item_index");
                this.radioGroup.check(checked);
                this.radioGroup.invalidate();
                break;
            }
            default: {
                this.finish();
                return;
            }
        }
        this.mSelectionType = bundle.getInt("type");
        final String title = bundle.getString("title");
        titleBar.setTitle(title, ITitleBarLayout.POSITION.MIDDLE);
        titleBar.setOnLeftClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectionActivity.this.finish();
            }
        });
        titleBar.getRightIcon().setVisibility(8);
        titleBar.getRightTitle().setText((CharSequence)this.getResources().getString(R.string.sure));
        titleBar.setOnRightClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SelectionActivity.this.echoClick(title);
            }
        });
    }

    private void echoClick(String title) {
        switch (this.mSelectionType) {
            case 1: {
                if (TextUtils.isEmpty((CharSequence)this.input.getText().toString()) && title.equals(this.getResources().getString(R.string.modify_group_name))) {
                    ToastUtil.toastLongMessage(this.getString(R.string.input_tip));
                    return;
                }
                if (sOnResultReturnListener == null) break;
                sOnResultReturnListener.onReturn(this.input.getText().toString());
                break;
            }
            case 2: {
                if (sOnResultReturnListener == null) break;
                sOnResultReturnListener.onReturn(this.radioGroup.getCheckedRadioButtonId());
            }
        }
        this.finish();
    }

    protected void onStop() {
        super.onStop();
        sOnResultReturnListener = null;
    }

    public static interface OnResultReturnListener {
        public void onReturn(Object var1);
    }
}

