/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;

public class TitleBarLayout
extends LinearLayout
implements ITitleBarLayout {
    private LinearLayout mLeftGroup;
    private LinearLayout mRightGroup;
    private TextView mLeftTitle;
    private TextView mCenterTitle;
    private TextView mRightTitle;
    private ImageView mLeftIcon;
    private ImageView mRightIcon;
    private RelativeLayout mTitleLayout;

    public TitleBarLayout(Context context) {
        super(context);
        this.init();
    }

    public TitleBarLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TitleBarLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        TitleBarLayout.inflate((Context)this.getContext(), (int)R.layout.title_bar_layout, (ViewGroup)this);
        this.mTitleLayout = (RelativeLayout)this.findViewById(R.id.page_title_layout);
        this.mLeftGroup = (LinearLayout)this.findViewById(R.id.page_title_left_group);
        this.mRightGroup = (LinearLayout)this.findViewById(R.id.page_title_right_group);
        this.mLeftTitle = (TextView)this.findViewById(R.id.page_title_left_text);
        this.mRightTitle = (TextView)this.findViewById(R.id.page_title_right_text);
        this.mCenterTitle = (TextView)this.findViewById(R.id.page_title);
        this.mLeftIcon = (ImageView)this.findViewById(R.id.page_title_left_icon);
        this.mRightIcon = (ImageView)this.findViewById(R.id.page_title_right_icon);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)this.mTitleLayout.getLayoutParams();
        params.height = ScreenUtil.getPxByDp(50.0f);
        this.mTitleLayout.setLayoutParams((ViewGroup.LayoutParams)params);
        this.setBackgroundColor(this.getResources().getColor(R.color.status_bar_color));
    }

    @Override
    public void setOnLeftClickListener(View.OnClickListener listener) {
        this.mLeftGroup.setOnClickListener(listener);
    }

    @Override
    public void setOnRightClickListener(View.OnClickListener listener) {
        this.mRightGroup.setOnClickListener(listener);
    }

    @Override
    public void setTitle(String title, ITitleBarLayout.POSITION position) {
        switch (position) {
            case LEFT: {
                this.mLeftTitle.setText((CharSequence)title);
                break;
            }
            case RIGHT: {
                this.mRightTitle.setText((CharSequence)title);
                break;
            }
            case MIDDLE: {
                this.mCenterTitle.setText((CharSequence)title);
            }
        }
    }

    @Override
    public LinearLayout getLeftGroup() {
        return this.mLeftGroup;
    }

    @Override
    public LinearLayout getRightGroup() {
        return this.mRightGroup;
    }

    @Override
    public ImageView getLeftIcon() {
        return this.mLeftIcon;
    }

    @Override
    public void setLeftIcon(int resId) {
        this.mLeftIcon.setImageResource(resId);
    }

    @Override
    public ImageView getRightIcon() {
        return this.mRightIcon;
    }

    @Override
    public void setRightIcon(int resId) {
        this.mRightIcon.setImageResource(resId);
    }

    @Override
    public TextView getLeftTitle() {
        return this.mLeftTitle;
    }

    @Override
    public TextView getMiddleTitle() {
        return this.mCenterTitle;
    }

    @Override
    public TextView getRightTitle() {
        return this.mRightTitle;
    }
}

