/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;

public class UnreadCountTextView
extends AppCompatTextView {
    private int mNormalSize = ScreenUtil.getPxByDp(18.4f);
    private Paint mPaint;

    public UnreadCountTextView(Context context) {
        super(context);
        this.init();
    }

    public UnreadCountTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public UnreadCountTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint();
        this.mPaint.setColor(this.getResources().getColor(R.color.read_dot_bg));
        this.setTextColor(-1);
        this.setTextSize(2, 13.6f);
    }

    protected void onDraw(Canvas canvas) {
        if (this.getText().length() == 0) {
            int r;
            int l;
            int t = l = (this.getMeasuredWidth() - ScreenUtil.getPxByDp(10.0f)) / 2;
            int b = r = this.getMeasuredWidth() - l;
            canvas.drawOval(new RectF((float)l, (float)t, (float)r, (float)b), this.mPaint);
        } else if (this.getText().length() == 1) {
            canvas.drawOval(new RectF(0.0f, 0.0f, (float)this.mNormalSize, (float)this.mNormalSize), this.mPaint);
        } else if (this.getText().length() > 1) {
            canvas.drawRoundRect(new RectF(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight()), (float)(this.getMeasuredHeight() / 2), (float)(this.getMeasuredHeight() / 2), this.mPaint);
        }
        super.onDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mNormalSize;
        int height = this.mNormalSize;
        if (this.getText().length() > 1) {
            width = this.mNormalSize + ScreenUtil.getPxByDp((this.getText().length() - 1) * 10);
        }
        this.setMeasuredDimension(width, height);
    }
}

