/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.action;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.action.PopMenuAction;
import com.tencent.qcloud.tim.uikit.utils.BackgroundTasks;
import java.util.ArrayList;
import java.util.List;

public class PopMenuAdapter
extends BaseAdapter {
    private List<PopMenuAction> dataSource = new ArrayList<PopMenuAction>();

    public void setDataSource(List datas) {
        this.dataSource = datas;
        BackgroundTasks.getInstance().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                PopMenuAdapter.this.notifyDataSetChanged();
            }
        });
    }

    public int getCount() {
        return this.dataSource.size();
    }

    public Object getItem(int position) {
        return this.dataSource.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            convertView = LayoutInflater.from((Context)TUIKit.getAppContext()).inflate(R.layout.pop_menu_adapter, parent, false);
            holder = new ViewHolder();
            holder.menu_icon = (ImageView)convertView.findViewById(R.id.pop_menu_icon);
            holder.menu_lable = (TextView)convertView.findViewById(R.id.pop_menu_label);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        PopMenuAction action = (PopMenuAction)this.getItem(position);
        holder.menu_icon.setVisibility(0);
        if (action.getIcon() != null) {
            holder.menu_icon.setImageBitmap(action.getIcon());
        } else if (action.getIconResId() > 0) {
            holder.menu_icon.setImageResource(action.getIconResId());
        } else {
            holder.menu_icon.setVisibility(8);
        }
        holder.menu_lable.setText((CharSequence)action.getActionName());
        return convertView;
    }

    static class ViewHolder {
        TextView menu_lable;
        ImageView menu_icon;

        ViewHolder() {
        }
    }
}

