/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;

public class TUIKitDialog {
    private Context mContext;
    protected Dialog dialog;
    private LinearLayout mBackgroundLayout;
    private LinearLayout mMainLayout;
    private TextView mTitleTv;
    private Button mCancelButton;
    private Button mSureButton;
    private ImageView mLineImg;
    private Display mDisplay;
    private boolean showTitle = false;
    private boolean showPosBtn = false;
    private boolean showNegBtn = false;
    private float dialogWidth = 0.7f;

    public TUIKitDialog(Context context) {
        this.mContext = context;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.mDisplay = windowManager.getDefaultDisplay();
    }

    public TUIKitDialog builder() {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.view_dialog, null);
        this.mBackgroundLayout = (LinearLayout)view.findViewById(R.id.ll_background);
        this.mMainLayout = (LinearLayout)view.findViewById(R.id.ll_alert);
        this.mMainLayout.setVerticalGravity(8);
        this.mTitleTv = (TextView)view.findViewById(R.id.tv_title);
        this.mTitleTv.setVisibility(8);
        this.mCancelButton = (Button)view.findViewById(R.id.btn_neg);
        this.mCancelButton.setVisibility(8);
        this.mSureButton = (Button)view.findViewById(R.id.btn_pos);
        this.mSureButton.setVisibility(8);
        this.mLineImg = (ImageView)view.findViewById(R.id.img_line);
        this.mLineImg.setVisibility(8);
        this.dialog = new Dialog(this.mContext, R.style.TUIKit_AlertDialogStyle);
        this.dialog.setContentView(view);
        this.mBackgroundLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams((int)((float)this.mDisplay.getWidth() * this.dialogWidth), -2));
        return this;
    }

    public TUIKitDialog setTitle(@NonNull String title) {
        this.showTitle = true;
        this.mTitleTv.setText((CharSequence)title);
        return this;
    }

    public TUIKitDialog setCancelable(boolean cancel) {
        this.dialog.setCancelable(cancel);
        return this;
    }

    public TUIKitDialog setCancelOutside(boolean isCancelOutside) {
        this.dialog.setCanceledOnTouchOutside(isCancelOutside);
        return this;
    }

    public TUIKitDialog setPositiveButton(String text, final View.OnClickListener listener) {
        this.showPosBtn = true;
        this.mSureButton.setText((CharSequence)text);
        this.mSureButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                listener.onClick(v);
                TUIKitDialog.this.dialog.dismiss();
            }
        });
        return this;
    }

    public TUIKitDialog setPositiveButton(View.OnClickListener listener) {
        this.setPositiveButton(TUIKit.getAppContext().getString(R.string.sure), listener);
        return this;
    }

    public TUIKitDialog setNegativeButton(String text, final View.OnClickListener listener) {
        this.showNegBtn = true;
        this.mCancelButton.setText((CharSequence)text);
        this.mCancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                listener.onClick(v);
                TUIKitDialog.this.dialog.dismiss();
            }
        });
        return this;
    }

    public TUIKitDialog setNegativeButton(View.OnClickListener listener) {
        this.setNegativeButton(TUIKit.getAppContext().getString(R.string.cancel), listener);
        return this;
    }

    private void setLayout() {
        if (!this.showTitle) {
            this.mTitleTv.setVisibility(8);
        }
        if (this.showTitle) {
            this.mTitleTv.setVisibility(0);
        }
        if (!this.showPosBtn && !this.showNegBtn) {
            this.mSureButton.setVisibility(8);
            this.mSureButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TUIKitDialog.this.dialog.dismiss();
                }
            });
        }
        if (this.showPosBtn && this.showNegBtn) {
            this.mSureButton.setVisibility(0);
            this.mCancelButton.setVisibility(0);
            this.mLineImg.setVisibility(0);
        }
        if (this.showPosBtn && !this.showNegBtn) {
            this.mSureButton.setVisibility(0);
        }
        if (!this.showPosBtn && this.showNegBtn) {
            this.mCancelButton.setVisibility(0);
        }
    }

    public void show() {
        this.setLayout();
        this.dialog.show();
    }

    public void dismiss() {
        this.dialog.dismiss();
    }

    public TUIKitDialog setDialogWidth(float dialogWidth) {
        if (this.mBackgroundLayout != null) {
            this.mBackgroundLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams((int)((float)this.mDisplay.getWidth() * dialogWidth), -2));
        }
        this.dialogWidth = dialogWidth;
        return this;
    }

    public TextView getTxt_title() {
        return this.mTitleTv;
    }

    public Button getBtn_neg() {
        return this.mCancelButton;
    }

    public LinearLayout getlLayout_alert_ll() {
        return this.mMainLayout;
    }

    public int dp2px(float dpValue) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public int px2dip(float pxValue) {
        float scale = this.mContext.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public int px2sp(float pxValue) {
        float fontScale = this.mContext.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public int sp2px(float spValue) {
        float fontScale = this.mContext.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public Button getBtn_pos() {
        return this.mSureButton;
    }
}

