/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.face;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.face.FaceManager;
import java.util.ArrayList;

public class EmojiIndicatorView
extends LinearLayout {
    private Context mContext;
    private ArrayList<ImageView> mImageViews;
    private Bitmap bmpSelect;
    private Bitmap bmpNomal;
    private int mHeight = 16;
    private int mMaxHeight;
    private AnimatorSet mPlayToAnimatorSet;
    private AnimatorSet mPlayByInAnimatorSet;
    private AnimatorSet mPlayByOutAnimatorSet;

    public EmojiIndicatorView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.setOrientation(0);
        this.mMaxHeight = FaceManager.dip2px(this.mContext, this.mHeight);
        this.bmpSelect = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.indicator_point_select);
        this.bmpNomal = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.indicator_point_nomal);
    }

    public EmojiIndicatorView(Context context) {
        this(context, null);
    }

    public void init(int count) {
        this.mImageViews = new ArrayList();
        this.removeAllViews();
        for (int i = 0; i < count; ++i) {
            RelativeLayout rl = new RelativeLayout(this.mContext);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(this.mMaxHeight, this.mMaxHeight);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            ImageView imageView = new ImageView(this.mContext);
            if (i == 0) {
                imageView.setImageBitmap(this.bmpSelect);
                rl.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                imageView.setImageBitmap(this.bmpNomal);
                rl.addView((View)imageView, (ViewGroup.LayoutParams)layoutParams);
            }
            this.addView((View)rl, (ViewGroup.LayoutParams)params);
            this.mImageViews.add(imageView);
        }
    }

    public void setIndicatorCount(int count) {
        if (this.mImageViews == null || count > this.mImageViews.size()) {
            return;
        }
        for (int i = 0; i < this.mImageViews.size(); ++i) {
            if (i >= count) {
                this.mImageViews.get(i).setVisibility(8);
                ((View)this.mImageViews.get(i).getParent()).setVisibility(8);
                continue;
            }
            this.mImageViews.get(i).setVisibility(0);
            ((View)this.mImageViews.get(i).getParent()).setVisibility(0);
        }
    }

    public void playTo(int position) {
        for (ImageView iv : this.mImageViews) {
            iv.setImageBitmap(this.bmpNomal);
        }
        this.mImageViews.get(position).setImageBitmap(this.bmpSelect);
        ImageView imageViewStrat = this.mImageViews.get(position);
        ObjectAnimator animIn1 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleX", (float[])new float[]{0.25f, 1.0f});
        ObjectAnimator animIn2 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleY", (float[])new float[]{0.25f, 1.0f});
        if (this.mPlayToAnimatorSet != null && this.mPlayToAnimatorSet.isRunning()) {
            this.mPlayToAnimatorSet.cancel();
            this.mPlayToAnimatorSet = null;
        }
        this.mPlayToAnimatorSet = new AnimatorSet();
        this.mPlayToAnimatorSet.play((Animator)animIn1).with((Animator)animIn2);
        this.mPlayToAnimatorSet.setDuration(100L);
        this.mPlayToAnimatorSet.start();
    }

    public void playBy(int startPosition, int nextPosition) {
        boolean isShowInAnimOnly = false;
        if (startPosition < 0 || nextPosition < 0 || nextPosition == startPosition) {
            nextPosition = 0;
            startPosition = 0;
        }
        if (startPosition < 0) {
            isShowInAnimOnly = true;
            nextPosition = 0;
            startPosition = 0;
        }
        final ImageView imageViewStrat = this.mImageViews.get(startPosition);
        final ImageView imageViewNext = this.mImageViews.get(nextPosition);
        ObjectAnimator anim1 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleX", (float[])new float[]{1.0f, 0.25f});
        ObjectAnimator anim2 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleY", (float[])new float[]{1.0f, 0.25f});
        if (this.mPlayByOutAnimatorSet != null && this.mPlayByOutAnimatorSet.isRunning()) {
            this.mPlayByOutAnimatorSet.cancel();
            this.mPlayByOutAnimatorSet = null;
        }
        this.mPlayByOutAnimatorSet = new AnimatorSet();
        this.mPlayByOutAnimatorSet.play((Animator)anim1).with((Animator)anim2);
        this.mPlayByOutAnimatorSet.setDuration(100L);
        ObjectAnimator animIn1 = ObjectAnimator.ofFloat((Object)imageViewNext, (String)"scaleX", (float[])new float[]{0.25f, 1.0f});
        ObjectAnimator animIn2 = ObjectAnimator.ofFloat((Object)imageViewNext, (String)"scaleY", (float[])new float[]{0.25f, 1.0f});
        if (this.mPlayByInAnimatorSet != null && this.mPlayByInAnimatorSet.isRunning()) {
            this.mPlayByInAnimatorSet.cancel();
            this.mPlayByInAnimatorSet = null;
        }
        this.mPlayByInAnimatorSet = new AnimatorSet();
        this.mPlayByInAnimatorSet.play((Animator)animIn1).with((Animator)animIn2);
        this.mPlayByInAnimatorSet.setDuration(100L);
        if (isShowInAnimOnly) {
            this.mPlayByInAnimatorSet.start();
            return;
        }
        anim1.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                imageViewStrat.setImageBitmap(EmojiIndicatorView.this.bmpNomal);
                ObjectAnimator animFil1l = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleX", (float[])new float[]{1.0f});
                ObjectAnimator animFill2 = ObjectAnimator.ofFloat((Object)imageViewStrat, (String)"scaleY", (float[])new float[]{1.0f});
                AnimatorSet mFillAnimatorSet = new AnimatorSet();
                mFillAnimatorSet.play((Animator)animFil1l).with((Animator)animFill2);
                mFillAnimatorSet.start();
                imageViewNext.setImageBitmap(EmojiIndicatorView.this.bmpSelect);
                EmojiIndicatorView.this.mPlayByInAnimatorSet.start();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.mPlayByOutAnimatorSet.start();
    }
}

