/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.face;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.face.Emoji;
import com.tencent.qcloud.tim.uikit.component.face.EmojiIndicatorView;
import com.tencent.qcloud.tim.uikit.component.face.FaceGroup;
import com.tencent.qcloud.tim.uikit.component.face.FaceGroupIcon;
import com.tencent.qcloud.tim.uikit.component.face.FaceManager;
import com.tencent.qcloud.tim.uikit.component.face.RecentEmojiManager;
import com.tencent.qcloud.tim.uikit.modules.chat.base.BaseInputFragment;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.SoftKeyBoardUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FaceFragment
extends BaseInputFragment
implements View.OnClickListener {
    ViewPager faceViewPager;
    EmojiIndicatorView faceIndicator;
    FaceGroupIcon faceFirstSetTv;
    FaceGroupIcon mCurrentSelected;
    LinearLayout faceGroup;
    ArrayList<View> ViewPagerItems = new ArrayList();
    ArrayList<Emoji> emojiList;
    ArrayList<Emoji> recentlyEmojiList;
    ArrayList<FaceGroup> customFaces;
    private int mCurrentGroupIndex = 0;
    private int columns = 7;
    private int rows = 3;
    private int vMargin = 0;
    private OnEmojiClickListener listener;
    private RecentEmojiManager recentManager;

    public static FaceFragment Instance() {
        FaceFragment instance = new FaceFragment();
        Bundle bundle = new Bundle();
        instance.setArguments(bundle);
        return instance;
    }

    public void setListener(OnEmojiClickListener listener) {
        this.listener = listener;
    }

    public void onAttach(Activity activity) {
        if (activity instanceof OnEmojiClickListener) {
            this.listener = (OnEmojiClickListener)activity;
        }
        this.recentManager = RecentEmojiManager.make((Context)activity);
        super.onAttach(activity);
    }

    public void onCreate(Bundle savedInstanceState) {
        try {
            this.emojiList = FaceManager.getEmojiList();
            this.recentlyEmojiList = this.recentManager.getCollection("recentFace") != null ? (ArrayList)this.recentManager.getCollection("recentFace") : new ArrayList();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        super.onCreate(savedInstanceState);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_face, container, false);
        ViewGroup.LayoutParams params = view.getLayoutParams();
        params.height = SoftKeyBoardUtil.getSoftKeyBoardHeight();
        view.setLayoutParams(params);
        this.faceViewPager = (ViewPager)view.findViewById(R.id.face_viewPager);
        this.faceIndicator = (EmojiIndicatorView)view.findViewById(R.id.face_indicator);
        this.faceFirstSetTv = (FaceGroupIcon)view.findViewById(R.id.face_first_set);
        this.faceGroup = (LinearLayout)view.findViewById(R.id.face_view_group);
        this.initViews();
        return view;
    }

    private void initViews() {
        this.initViewPager(this.emojiList, 7, 3);
        this.mCurrentSelected = this.faceFirstSetTv;
        this.faceFirstSetTv.setSelected(true);
        this.faceFirstSetTv.setOnClickListener(this);
        this.customFaces = FaceManager.getCustomFaceList();
        this.mCurrentGroupIndex = 0;
        int width = ScreenUtil.getPxByDp(70.0f);
        for (int i = 0; i < this.customFaces.size(); ++i) {
            final FaceGroup group = this.customFaces.get(i);
            FaceGroupIcon faceBtn = new FaceGroupIcon((Context)this.getActivity());
            faceBtn.setFaceTabIcon(group.getGroupIcon());
            faceBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FaceFragment.this.mCurrentSelected != v) {
                        FaceFragment.this.mCurrentGroupIndex = group.getGroupId();
                        ArrayList<Emoji> faces = group.getFaces();
                        FaceFragment.this.mCurrentSelected.setSelected(false);
                        FaceFragment.this.initViewPager(faces, group.getPageColumnCount(), group.getPageRowCount());
                        FaceFragment.this.mCurrentSelected = (FaceGroupIcon)v;
                        FaceFragment.this.mCurrentSelected.setSelected(true);
                    }
                }
            });
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(width, -1);
            this.faceGroup.addView((View)faceBtn, (ViewGroup.LayoutParams)params);
        }
    }

    private void initViewPager(ArrayList<Emoji> list, int columns, int rows) {
        this.columns = columns;
        this.rows = rows;
        if (list.size() > 0) {
            this.vMargin = (SoftKeyBoardUtil.getSoftKeyBoardHeight() - (ScreenUtil.getPxByDp(60.0f) + list.get(0).getHeight() * rows)) / 4;
        }
        this.intiIndicator(list);
        this.ViewPagerItems.clear();
        int pageCont = this.getPagerCount(list);
        for (int i = 0; i < pageCont; ++i) {
            this.ViewPagerItems.add(this.getViewPagerItem(i, list));
        }
        FaceVPAdapter mVpAdapter = new FaceVPAdapter(this.ViewPagerItems);
        this.faceViewPager.setAdapter((PagerAdapter)mVpAdapter);
        this.faceViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){
            int oldPosition = 0;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                FaceFragment.this.faceIndicator.playBy(this.oldPosition, position);
                this.oldPosition = position;
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void intiIndicator(ArrayList<Emoji> list) {
        this.faceIndicator.init(this.getPagerCount(list));
    }

    public void onClick(View v) {
        if (v.getId() == R.id.face_first_set && this.mCurrentSelected != v) {
            this.mCurrentGroupIndex = 0;
            this.mCurrentSelected.setSelected(false);
            this.mCurrentSelected = (FaceGroupIcon)v;
            this.initViewPager(this.emojiList, 7, 3);
            this.mCurrentSelected.setSelected(true);
        }
    }

    private int getPagerCount(ArrayList<Emoji> list) {
        int count = list.size();
        int dit = 1;
        if (this.mCurrentGroupIndex > 0) {
            dit = 0;
        }
        return count % (this.columns * this.rows - dit) == 0 ? count / (this.columns * this.rows - dit) : count / (this.columns * this.rows - dit) + 1;
    }

    private View getViewPagerItem(int position, ArrayList<Emoji> list) {
        LayoutInflater inflater = (LayoutInflater)this.getActivity().getSystemService("layout_inflater");
        View layout2 = inflater.inflate(R.layout.layout_face_grid, null);
        GridView gridview = (GridView)layout2.findViewById(R.id.chart_face_gv);
        final ArrayList<Emoji> subList = new ArrayList<Emoji>();
        int dit = 1;
        if (this.mCurrentGroupIndex > 0) {
            dit = 0;
        }
        subList.addAll(list.subList(position * (this.columns * this.rows - dit), (this.columns * this.rows - dit) * (position + 1) > list.size() ? list.size() : (this.columns * this.rows - dit) * (position + 1)));
        if (this.mCurrentGroupIndex == 0 && subList.size() < this.columns * this.rows - dit) {
            for (int i = subList.size(); i < this.columns * this.rows - dit; ++i) {
                subList.add(null);
            }
        }
        if (this.mCurrentGroupIndex == 0) {
            Emoji deleteEmoji = new Emoji();
            deleteEmoji.setIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.face_delete));
            subList.add(deleteEmoji);
        }
        FaceGVAdapter mGvAdapter = new FaceGVAdapter(subList, (Context)this.getActivity());
        gridview.setAdapter((ListAdapter)mGvAdapter);
        gridview.setNumColumns(this.columns);
        gridview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (FaceFragment.this.mCurrentGroupIndex > 0) {
                    FaceFragment.this.listener.onCustomFaceClick(FaceFragment.this.mCurrentGroupIndex, (Emoji)subList.get(position));
                } else {
                    if (position == FaceFragment.this.columns * FaceFragment.this.rows - 1) {
                        if (FaceFragment.this.listener != null) {
                            FaceFragment.this.listener.onEmojiDelete();
                        }
                        return;
                    }
                    if (FaceFragment.this.listener != null) {
                        FaceFragment.this.listener.onEmojiClick((Emoji)subList.get(position));
                    }
                }
            }
        });
        return gridview;
    }

    private void insertToRecentList(Emoji emoji) {
        if (emoji != null) {
            if (this.recentlyEmojiList.contains(emoji)) {
                int index = this.recentlyEmojiList.indexOf(emoji);
                Emoji emoji0 = this.recentlyEmojiList.get(0);
                this.recentlyEmojiList.set(index, emoji0);
                this.recentlyEmojiList.set(0, emoji);
                return;
            }
            if (this.recentlyEmojiList.size() == this.rows * this.columns - 1) {
                this.recentlyEmojiList.remove(this.rows * this.columns - 2);
            }
            this.recentlyEmojiList.add(0, emoji);
        }
    }

    public void onDestroyView() {
        super.onDestroyView();
        try {
            this.recentManager.putCollection("recentFace", this.recentlyEmojiList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class FaceVPAdapter
    extends PagerAdapter {
        private List<View> views;

        public FaceVPAdapter(List<View> views) {
            this.views = views;
        }

        public void destroyItem(View arg0, int arg1, Object arg2) {
            ((ViewPager)arg0).removeView((View)arg2);
        }

        public int getCount() {
            return this.views.size();
        }

        public Object instantiateItem(View arg0, int arg1) {
            ((ViewPager)arg0).addView(this.views.get(arg1));
            return this.views.get(arg1);
        }

        public boolean isViewFromObject(View arg0, Object arg1) {
            return arg0 == arg1;
        }
    }

    class FaceGVAdapter
    extends BaseAdapter {
        private List<Emoji> list;
        private Context mContext;

        public FaceGVAdapter(List<Emoji> list, Context mContext) {
            this.list = list;
            this.mContext = mContext;
        }

        public int getCount() {
            return this.list.size();
        }

        public Object getItem(int position) {
            return this.list.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            Emoji emoji = this.list.get(position);
            if (convertView == null) {
                holder = new ViewHolder();
                convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_face, null);
                holder.iv = (ImageView)convertView.findViewById(R.id.face_image);
                FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)holder.iv.getLayoutParams();
                if (emoji != null) {
                    params.width = emoji.getWidth();
                    params.height = emoji.getHeight();
                }
                if (position / FaceFragment.this.columns == 0) {
                    params.setMargins(0, FaceFragment.this.vMargin, 0, 0);
                } else if (FaceFragment.this.rows == 2) {
                    params.setMargins(0, FaceFragment.this.vMargin, 0, 0);
                } else if (position / FaceFragment.this.columns < FaceFragment.this.rows - 1) {
                    params.setMargins(0, FaceFragment.this.vMargin, 0, FaceFragment.this.vMargin);
                } else {
                    params.setMargins(0, 0, 0, FaceFragment.this.vMargin);
                }
                holder.iv.setLayoutParams((ViewGroup.LayoutParams)params);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            if (emoji != null) {
                holder.iv.setImageBitmap(emoji.getIcon());
            }
            return convertView;
        }

        class ViewHolder {
            ImageView iv;

            ViewHolder() {
            }
        }
    }

    public static interface OnEmojiClickListener {
        public void onEmojiDelete();

        public void onEmojiClick(Emoji var1);

        public void onCustomFaceClick(int var1, Emoji var2);
    }
}

