/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.face;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.text.SpannableStringBuilder;
import android.text.style.ImageSpan;
import android.util.LruCache;
import android.widget.EditText;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.face.CustomFace;
import com.tencent.qcloud.tim.uikit.component.face.CustomFaceGroup;
import com.tencent.qcloud.tim.uikit.component.face.Emoji;
import com.tencent.qcloud.tim.uikit.component.face.FaceGroup;
import com.tencent.qcloud.tim.uikit.config.CustomFaceConfig;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FaceManager {
    private static final int drawableWidth = ScreenUtil.getPxByDp(32.0f);
    private static ArrayList<Emoji> emojiList = new ArrayList();
    private static LruCache<String, Bitmap> drawableCache = new LruCache(1024);
    private static Context context = TUIKit.getAppContext();
    private static String[] emojiFilters = context.getResources().getStringArray(R.array.emoji_filter_key);
    private static String[] emojiFilters_values = context.getResources().getStringArray(R.array.emoji_filter_value);
    private static ArrayList<FaceGroup> customFace = new ArrayList();

    public static ArrayList<Emoji> getEmojiList() {
        return emojiList;
    }

    public static ArrayList<FaceGroup> getCustomFaceList() {
        return customFace;
    }

    public static Bitmap getCustomBitmap(int groupId, String name) {
        for (int i = 0; i < customFace.size(); ++i) {
            FaceGroup group = customFace.get(i);
            if (group.getGroupId() != groupId) continue;
            ArrayList<Emoji> faces = group.getFaces();
            for (int j = 0; j < faces.size(); ++j) {
                Emoji face = faces.get(j);
                if (!face.getFilter().equals(name)) continue;
                return face.getIcon();
            }
        }
        return null;
    }

    public static String[] getEmojiFiltersValues() {
        return emojiFilters_values;
    }

    public static String[] getEmojiFilters() {
        return emojiFilters;
    }

    public static void loadFaceFiles() {
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < emojiFilters.length; ++i) {
                    FaceManager.loadAssetBitmap(emojiFilters[i], "emoji/" + emojiFilters[i] + "@2x.png", true);
                }
                CustomFaceConfig config = TUIKit.getConfigs().getCustomFaceConfig();
                if (config == null) {
                    return;
                }
                List<CustomFaceGroup> groups = config.getFaceGroups();
                if (groups == null) {
                    return;
                }
                for (int i = 0; i < groups.size(); ++i) {
                    CustomFaceGroup groupConfigs = groups.get(i);
                    FaceGroup groupInfo = new FaceGroup();
                    groupInfo.setGroupId(groupConfigs.getFaceGroupId());
                    groupInfo.setDesc(groupConfigs.getFaceIconName());
                    groupInfo.setPageColumnCount(groupConfigs.getPageColumnCount());
                    groupInfo.setPageRowCount(groupConfigs.getPageRowCount());
                    groupInfo.setGroupIcon(FaceManager.loadAssetBitmap(groupConfigs.getFaceIconName(), groupConfigs.getFaceIconPath(), false).getIcon());
                    ArrayList<CustomFace> customFaceArray = groupConfigs.getCustomFaceList();
                    ArrayList<Emoji> faceList = new ArrayList<Emoji>();
                    for (int j = 0; j < customFaceArray.size(); ++j) {
                        CustomFace face = customFaceArray.get(j);
                        Emoji emoji = FaceManager.loadAssetBitmap(face.getFaceName(), face.getAssetPath(), false);
                        emoji.setWidth(face.getFaceWidth());
                        emoji.setHeight(face.getFaceHeight());
                        faceList.add(emoji);
                    }
                    groupInfo.setFaces(faceList);
                    customFace.add(groupInfo);
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Emoji loadAssetBitmap(String filter, String assetPath, boolean isEmoji) {
        InputStream is = null;
        try {
            Emoji emoji = new Emoji();
            Resources resources = context.getResources();
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inDensity = 480;
            options.inScreenDensity = resources.getDisplayMetrics().densityDpi;
            options.inTargetDensity = resources.getDisplayMetrics().densityDpi;
            context.getAssets().list("");
            is = context.getAssets().open(assetPath);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is, (Rect)new Rect(0, 0, drawableWidth, drawableWidth), (BitmapFactory.Options)options);
            if (bitmap != null) {
                drawableCache.put((Object)filter, (Object)bitmap);
                emoji.setIcon(bitmap);
                emoji.setFilter(filter);
                if (isEmoji) {
                    emojiList.add(emoji);
                }
            }
            Emoji emoji2 = emoji;
            return emoji2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int widthRatio;
            int heightRatio = Math.round((float)height / (float)reqHeight);
            inSampleSize = heightRatio < (widthRatio = Math.round((float)width / (float)reqWidth)) ? heightRatio : widthRatio;
        }
        return inSampleSize;
    }

    public static Bitmap decodeSampledBitmapFromResource(Resources res, int resId, int reqWidth, int reqHeight) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
        options.inSampleSize = FaceManager.calculateInSampleSize(options, reqWidth, reqHeight);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeResource((Resources)res, (int)resId, (BitmapFactory.Options)options);
    }

    public static int dip2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static boolean isFaceChar(String faceChar) {
        return drawableCache.get((Object)faceChar) != null;
    }

    public static void handlerEmojiText(TextView comment, String content, boolean typing) {
        SpannableStringBuilder sb = new SpannableStringBuilder((CharSequence)content);
        String regex = "\\[(\\S+?)\\]";
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(content);
        boolean imageFound = false;
        while (m.find()) {
            String emojiName = m.group();
            Bitmap bitmap = (Bitmap)drawableCache.get((Object)emojiName);
            if (bitmap == null) continue;
            imageFound = true;
            sb.setSpan((Object)new ImageSpan(context, bitmap), m.start(), m.end(), 17);
        }
        if (!imageFound && typing) {
            return;
        }
        int selection = comment.getSelectionStart();
        comment.setText((CharSequence)sb);
        if (comment instanceof EditText) {
            ((EditText)comment).setSelection(selection);
        }
    }

    public static Bitmap getEmoji(String name) {
        return (Bitmap)drawableCache.get((Object)name);
    }
}

