/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.face;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class RecentEmojiManager {
    public static final String PREFERENCE_NAME = "recentFace";
    private SharedPreferences mPreferences;
    private SharedPreferences.Editor mEditor;

    private RecentEmojiManager(Context context) {
        this.mPreferences = context.getSharedPreferences(PREFERENCE_NAME, 0);
        this.mEditor = this.mPreferences.edit();
    }

    public static RecentEmojiManager make(Context context) {
        return new RecentEmojiManager(context);
    }

    public String getString(String key) {
        return this.mPreferences.getString(key, "");
    }

    public RecentEmojiManager putString(String key, String value) {
        this.mEditor.putString(key, value).apply();
        return this;
    }

    public RecentEmojiManager putCollection(String key, Collection collection) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(collection);
        String collectionString = new String(Base64.encode((byte[])byteArrayOutputStream.toByteArray(), (int)0));
        objectOutputStream.close();
        return this.putString(key, collectionString);
    }

    public Collection getCollection(String key) throws IOException, ClassNotFoundException {
        String collectionString = this.getString(key);
        if (TextUtils.isEmpty((CharSequence)collectionString) || TextUtils.isEmpty((CharSequence)collectionString.trim())) {
            return null;
        }
        byte[] mobileBytes = Base64.decode((byte[])collectionString.getBytes(), (int)0);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mobileBytes);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        Collection collection = (Collection)objectInputStream.readObject();
        objectInputStream.close();
        return collection;
    }
}

