/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.gatherimage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;

@SuppressLint(value={"AppCompatCustomView"})
public class ShadeImageView
extends ImageView {
    private static SparseArray<Bitmap> sRoundBitmapArray = new SparseArray();
    private Paint mShadePaint = new Paint();
    private Bitmap mRoundBitmap;
    private int radius = ScreenUtil.getPxByDp(5.0f);

    public ShadeImageView(Context context) {
        super(context);
    }

    public ShadeImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public ShadeImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        this.setLayerType(2, null);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mShadePaint.setColor(-65536);
        this.mShadePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.mRoundBitmap = (Bitmap)sRoundBitmapArray.get(this.getMeasuredWidth() + this.radius);
        if (this.mRoundBitmap == null) {
            this.mRoundBitmap = this.getRoundBitmap();
            sRoundBitmapArray.put(this.getMeasuredWidth() + this.radius, (Object)this.mRoundBitmap);
        }
        canvas.drawBitmap(this.mRoundBitmap, 0.0f, 0.0f, this.mShadePaint);
    }

    private Bitmap getRoundBitmap() {
        Bitmap output = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color2 = Color.parseColor((String)"#cfd3d8");
        Rect rect = new Rect(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight());
        RectF rectF = new RectF(rect);
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color2);
        canvas.drawRoundRect(rectF, (float)this.radius, (float)this.radius, paint);
        return output;
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int radius) {
        this.radius = radius;
    }
}

