/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.gatherimage;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.gatherimage.ShadeImageView;
import com.tencent.qcloud.tim.uikit.component.gatherimage.TeamHeadSynthesizer;
import java.util.List;

public class SynthesizedImageView
extends ShadeImageView {
    TeamHeadSynthesizer teamHeadSynthesizer;
    int imageSize = 100;
    int synthesizedBg = Color.parseColor((String)"#cfd3d8");
    int defaultImageResId = 0;
    int imageGap = 6;

    public SynthesizedImageView(Context context) {
        super(context);
        this.init(context);
    }

    public SynthesizedImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(attrs);
        this.init(context);
    }

    public SynthesizedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrs(attrs);
        this.init(context);
    }

    private void initAttrs(AttributeSet attributeSet) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.SynthesizedImageView);
        if (null != ta) {
            this.synthesizedBg = ta.getColor(R.styleable.SynthesizedImageView_synthesized_image_bg, this.synthesizedBg);
            this.defaultImageResId = ta.getResourceId(R.styleable.SynthesizedImageView_synthesized_default_image, this.defaultImageResId);
            this.imageSize = ta.getDimensionPixelSize(R.styleable.SynthesizedImageView_synthesized_image_size, this.imageSize);
            this.imageGap = ta.getDimensionPixelSize(R.styleable.SynthesizedImageView_synthesized_image_gap, this.imageGap);
            ta.recycle();
        }
    }

    private void init(Context context) {
        this.teamHeadSynthesizer = new TeamHeadSynthesizer(context, this);
        this.teamHeadSynthesizer.setMaxWidthHeight(this.imageSize, this.imageSize);
        this.teamHeadSynthesizer.setDefaultImage(this.defaultImageResId);
        this.teamHeadSynthesizer.setBgColor(this.synthesizedBg);
        this.teamHeadSynthesizer.setGap(this.imageGap);
    }

    public SynthesizedImageView displayImage(List<Object> imageUrls) {
        this.teamHeadSynthesizer.getMultiImageData().setImageUrls(imageUrls);
        return this;
    }

    public SynthesizedImageView defaultImage(int defaultImage) {
        this.teamHeadSynthesizer.setDefaultImage(defaultImage);
        return this;
    }

    public SynthesizedImageView synthesizedWidthHeight(int maxWidth, int maxHeight) {
        this.teamHeadSynthesizer.setMaxWidthHeight(maxWidth, maxHeight);
        return this;
    }

    public void setImageId(String id2) {
        this.teamHeadSynthesizer.setImageId(id2);
    }

    public void load() {
        this.teamHeadSynthesizer.load();
    }
}

