/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.gatherimage;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.text.TextUtils;
import android.widget.ImageView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.gatherimage.MultiImageData;
import com.tencent.qcloud.tim.uikit.component.gatherimage.Synthesizer;
import com.tencent.qcloud.tim.uikit.component.picture.imageEngine.impl.GlideEngine;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.utils.ImageUtil;
import com.tencent.qcloud.tim.uikit.utils.MD5Utils;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.ThreadHelper;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class TeamHeadSynthesizer
implements Synthesizer {
    String currentTargetID;
    MultiImageData multiImageData;
    Context mContext;
    int targetImageSize;
    int maxWidth;
    int maxHeight;
    ImageView imageView;
    int bgColor = Color.parseColor((String)"#cfd3d8");
    boolean loadOk;
    private String mImageId = "";
    private final String SP_IMAGE = "conversation_group_face";
    Callback callback = new Callback(){

        @Override
        public void onCall(Object obj, String targetID, boolean complete) {
            if (!TextUtils.equals((CharSequence)TeamHeadSynthesizer.this.currentTargetID, (CharSequence)targetID)) {
                return;
            }
            if (obj instanceof File) {
                if (complete) {
                    TeamHeadSynthesizer.this.loadOk = true;
                }
                TeamHeadSynthesizer.this.imageView.setImageBitmap(BitmapFactory.decodeFile((String)((File)obj).getAbsolutePath()));
            } else if (obj instanceof Bitmap) {
                if (complete) {
                    TeamHeadSynthesizer.this.loadOk = true;
                }
                TeamHeadSynthesizer.this.imageView.setImageBitmap((Bitmap)obj);
            }
        }
    };
    private int mRowCount;
    private int mColumnCount;
    private int mGap = 6;

    public TeamHeadSynthesizer(Context mContext, ImageView imageView) {
        this.mContext = mContext;
        this.imageView = imageView;
        this.init();
    }

    private void init() {
        this.multiImageData = new MultiImageData();
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidthHeight(int maxWidth, int maxHeight) {
        this.maxWidth = maxWidth;
        this.maxHeight = maxHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public MultiImageData getMultiImageData() {
        return this.multiImageData;
    }

    public int getDefaultImage() {
        return this.multiImageData.getDefaultImageResId();
    }

    public void setDefaultImage(int defaultImageResId) {
        this.multiImageData.setDefaultImageResId(defaultImageResId);
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(int bgColor) {
        this.bgColor = bgColor;
    }

    public int getGap() {
        return this.mGap;
    }

    public void setGap(int mGap) {
        this.mGap = mGap;
    }

    protected int[] calculateGridParam(int imagesSize) {
        int[] gridParam = new int[2];
        if (imagesSize < 3) {
            gridParam[0] = 1;
            gridParam[1] = imagesSize;
        } else if (imagesSize <= 4) {
            gridParam[0] = 2;
            gridParam[1] = 2;
        } else {
            gridParam[0] = imagesSize / 3 + (imagesSize % 3 == 0 ? 0 : 1);
            gridParam[1] = 3;
        }
        return gridParam;
    }

    @Override
    public Bitmap synthesizeImageList() {
        Bitmap mergeBitmap = Bitmap.createBitmap((int)this.maxWidth, (int)this.maxHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(mergeBitmap);
        this.drawDrawable(canvas);
        canvas.save();
        canvas.restore();
        return mergeBitmap;
    }

    @Override
    public boolean asyncLoadImageList() {
        boolean loadSuccess = true;
        List<Object> imageUrls = this.multiImageData.getImageUrls();
        for (int i = 0; i < imageUrls.size(); ++i) {
            Bitmap defaultIcon = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)R.drawable.default_user_icon);
            try {
                Bitmap bitmap = this.asyncLoadImage(imageUrls.get(i), this.targetImageSize);
                this.multiImageData.putBitmap(bitmap, i);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.multiImageData.putBitmap(defaultIcon, i);
                continue;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                this.multiImageData.putBitmap(defaultIcon, i);
            }
        }
        return loadSuccess;
    }

    @Override
    public void drawDrawable(Canvas canvas) {
        canvas.drawColor(this.bgColor);
        int size = this.multiImageData.size();
        int t_center = (this.maxHeight + this.mGap) / 2;
        int b_center = (this.maxHeight - this.mGap) / 2;
        int l_center = (this.maxWidth + this.mGap) / 2;
        int r_center = (this.maxWidth - this.mGap) / 2;
        int center = (this.maxHeight - this.targetImageSize) / 2;
        for (int i = 0; i < size; ++i) {
            int rowNum = i / this.mColumnCount;
            int columnNum = i % this.mColumnCount;
            int left = (int)((double)this.targetImageSize * (this.mColumnCount == 1 ? (double)columnNum + 0.5 : (double)columnNum) + (double)(this.mGap * (columnNum + 1)));
            int top = (int)((double)this.targetImageSize * (this.mColumnCount == 1 ? (double)rowNum + 0.5 : (double)rowNum) + (double)(this.mGap * (rowNum + 1)));
            int right = left + this.targetImageSize;
            int bottom = top + this.targetImageSize;
            Bitmap bitmap = this.multiImageData.getBitmap(i);
            if (size == 1) {
                this.drawBitmapAtPosition(canvas, left, top, right, bottom, bitmap);
                continue;
            }
            if (size == 2) {
                this.drawBitmapAtPosition(canvas, left, center, right, center + this.targetImageSize, bitmap);
                continue;
            }
            if (size == 3) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, center, top, center + this.targetImageSize, bottom, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * i + this.targetImageSize * (i - 1), t_center, this.mGap * i + this.targetImageSize * i, t_center + this.targetImageSize, bitmap);
                continue;
            }
            if (size == 4) {
                this.drawBitmapAtPosition(canvas, left, top, right, bottom, bitmap);
                continue;
            }
            if (size == 5) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, r_center - this.targetImageSize, r_center - this.targetImageSize, r_center, r_center, bitmap);
                    continue;
                }
                if (i == 1) {
                    this.drawBitmapAtPosition(canvas, l_center, r_center - this.targetImageSize, l_center + this.targetImageSize, r_center, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 1) + this.targetImageSize * (i - 2), t_center, this.mGap * (i - 1) + this.targetImageSize * (i - 1), t_center + this.targetImageSize, bitmap);
                continue;
            }
            if (size == 6) {
                if (i < 3) {
                    this.drawBitmapAtPosition(canvas, this.mGap * (i + 1) + this.targetImageSize * i, b_center - this.targetImageSize, this.mGap * (i + 1) + this.targetImageSize * (i + 1), b_center, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 2) + this.targetImageSize * (i - 3), t_center, this.mGap * (i - 2) + this.targetImageSize * (i - 2), t_center + this.targetImageSize, bitmap);
                continue;
            }
            if (size == 7) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, center, this.mGap, center + this.targetImageSize, this.mGap + this.targetImageSize, bitmap);
                    continue;
                }
                if (i > 0 && i < 4) {
                    this.drawBitmapAtPosition(canvas, this.mGap * i + this.targetImageSize * (i - 1), center, this.mGap * i + this.targetImageSize * i, center + this.targetImageSize, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 3) + this.targetImageSize * (i - 4), t_center + this.targetImageSize / 2, this.mGap * (i - 3) + this.targetImageSize * (i - 3), t_center + this.targetImageSize / 2 + this.targetImageSize, bitmap);
                continue;
            }
            if (size == 8) {
                if (i == 0) {
                    this.drawBitmapAtPosition(canvas, r_center - this.targetImageSize, this.mGap, r_center, this.mGap + this.targetImageSize, bitmap);
                    continue;
                }
                if (i == 1) {
                    this.drawBitmapAtPosition(canvas, l_center, this.mGap, l_center + this.targetImageSize, this.mGap + this.targetImageSize, bitmap);
                    continue;
                }
                if (i > 1 && i < 5) {
                    this.drawBitmapAtPosition(canvas, this.mGap * (i - 1) + this.targetImageSize * (i - 2), center, this.mGap * (i - 1) + this.targetImageSize * (i - 1), center + this.targetImageSize, bitmap);
                    continue;
                }
                this.drawBitmapAtPosition(canvas, this.mGap * (i - 4) + this.targetImageSize * (i - 5), t_center + this.targetImageSize / 2, this.mGap * (i - 4) + this.targetImageSize * (i - 4), t_center + this.targetImageSize / 2 + this.targetImageSize, bitmap);
                continue;
            }
            if (size != 9) continue;
            this.drawBitmapAtPosition(canvas, left, top, right, bottom, bitmap);
        }
    }

    public void drawBitmapAtPosition(Canvas canvas, int left, int top, int right, int bottom, Bitmap bitmap) {
        if (null == bitmap && this.multiImageData.getDefaultImageResId() > 0) {
            bitmap = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)this.multiImageData.getDefaultImageResId());
        }
        if (null != bitmap) {
            Rect rect = new Rect(left, top, right, bottom);
            canvas.drawBitmap(bitmap, null, rect, null);
        }
    }

    private Bitmap asyncLoadImage(Object imageUrl, int targetImageSize) throws ExecutionException, InterruptedException {
        return GlideEngine.loadBitmap(imageUrl, targetImageSize);
    }

    public void setImageId(String id2) {
        this.mImageId = id2;
    }

    public void load() {
        if (this.multiImageData.size() == 0) {
            this.imageView.setImageResource(this.getDefaultImage());
            return;
        }
        if (this.multiImageData.size() == 1) {
            GlideEngine.loadImage(this.imageView, this.multiImageData.getImageUrls().get(0));
            return;
        }
        String newTargetID = this.buildTargetSynthesizedId();
        if (this.loadOk && null != this.imageView.getDrawable() && TextUtils.equals((CharSequence)this.currentTargetID, (CharSequence)newTargetID)) {
            return;
        }
        this.currentTargetID = newTargetID;
        int[] gridParam = this.calculateGridParam(this.multiImageData.size());
        this.mRowCount = gridParam[0];
        this.mColumnCount = gridParam[1];
        this.targetImageSize = (this.maxWidth - (this.mColumnCount + 1) * this.mGap) / (this.mColumnCount == 1 ? 2 : this.mColumnCount);
        ThreadHelper.INST.execute(new Runnable(){

            @Override
            public void run() {
                final File file = new File(TUIKitConstants.IMAGE_BASE_DIR + TeamHeadSynthesizer.this.currentTargetID);
                boolean cacheBitmapExists = false;
                if (file.exists() && file.isFile()) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeFile((String)file.getPath(), (BitmapFactory.Options)options);
                    if (options.outWidth > 0 && options.outHeight > 0) {
                        cacheBitmapExists = true;
                    }
                }
                if (!cacheBitmapExists) {
                    TeamHeadSynthesizer.this.asyncLoadImageList();
                    final Bitmap bitmap = TeamHeadSynthesizer.this.synthesizeImageList();
                    ImageUtil.storeBitmap(file, bitmap);
                    ConversationManagerKit.getInstance().setGroupConversationAvatar(TeamHeadSynthesizer.this.mImageId, file.getAbsolutePath());
                    TeamHeadSynthesizer.this.imageView.post(new Runnable(){

                        @Override
                        public void run() {
                            TeamHeadSynthesizer.this.callback.onCall(bitmap, TeamHeadSynthesizer.this.currentTargetID, true);
                        }
                    });
                } else {
                    TeamHeadSynthesizer.this.imageView.post(new Runnable(){

                        @Override
                        public void run() {
                            TeamHeadSynthesizer.this.callback.onCall(file, TeamHeadSynthesizer.this.currentTargetID, true);
                        }
                    });
                }
            }
        });
    }

    public String buildTargetSynthesizedId() {
        int size = this.multiImageData.size();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < size; ++i) {
            Object imageUrl = this.multiImageData.getImageUrls().get(i);
            buffer.append(i + "" + imageUrl);
        }
        return MD5Utils.getMD5String(buffer.toString());
    }

    static interface Callback {
        public void onCall(Object var1, String var2, boolean var3);
    }
}

