/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.gatherimage;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.gatherimage.DynamicChatUserIconView;
import com.tencent.qcloud.tim.uikit.component.gatherimage.SynthesizedImageView;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import java.util.List;

public class UserIconView
extends RelativeLayout {
    private SynthesizedImageView mIconView;
    private DynamicChatUserIconView mDynamicView;
    private int mDefaultImageResId;
    private int mIconRadius;

    public UserIconView(Context context) {
        super(context);
        this.init(null);
    }

    public UserIconView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public UserIconView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    public void setDynamicChatIconView(DynamicChatUserIconView dynamicView) {
        this.mDynamicView = dynamicView;
        this.mDynamicView.setLayout((ViewGroup)this);
        this.mDynamicView.setMainViewId(R.id.profile_icon_group);
        if (this.mDynamicView.getIconRadius() >= 0) {
            this.mIconView.setRadius(this.mDynamicView.getIconRadius());
        }
    }

    public void invokeInformation(MessageInfo messageInfo) {
        this.mIconView.load();
        if (this.mDynamicView != null) {
            this.mDynamicView.parseInformation(messageInfo);
        }
    }

    private void init(AttributeSet attributeSet) {
        TypedArray ta;
        UserIconView.inflate((Context)this.getContext(), (int)R.layout.profile_icon_view, (ViewGroup)this);
        if (attributeSet != null && null != (ta = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.UserIconView))) {
            this.mDefaultImageResId = ta.getResourceId(R.styleable.UserIconView_default_image, this.mDefaultImageResId);
            this.mIconRadius = ta.getDimensionPixelSize(R.styleable.UserIconView_image_radius, this.mIconRadius);
            ta.recycle();
        }
        this.mIconView = (SynthesizedImageView)this.findViewById(R.id.profile_icon);
        if (this.mDefaultImageResId > 0) {
            this.mIconView.defaultImage(this.mDefaultImageResId);
        }
        if (this.mIconRadius > 0) {
            this.mIconView.setRadius(this.mIconRadius);
        }
    }

    public void setDefaultImageResId(int resId) {
        this.mDefaultImageResId = resId;
        this.mIconView.defaultImage(resId);
    }

    public void setRadius(int radius) {
        this.mIconRadius = radius;
        this.mIconView.setRadius(this.mIconRadius);
    }

    public void setIconUrls(List<Object> iconUrls) {
        this.mIconView.displayImage(iconUrls).load();
    }
}

