/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.helper;

import com.github.promeg.pinyinhelper.Pinyin;
import com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.bean.BaseIndexPinyinBean;
import com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.helper.IIndexBarDataHelper;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IndexBarDataHelperImpl
implements IIndexBarDataHelper {
    @Override
    public IIndexBarDataHelper convert(List<? extends BaseIndexPinyinBean> datas) {
        if (null == datas || datas.isEmpty()) {
            return this;
        }
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            BaseIndexPinyinBean indexPinyinBean = datas.get(i);
            StringBuilder pySb = new StringBuilder();
            if (!indexPinyinBean.isNeedToPinyin()) continue;
            String target = indexPinyinBean.getTarget();
            for (int i1 = 0; i1 < target.length(); ++i1) {
                pySb.append(Pinyin.toPinyin((char)target.charAt(i1)).toUpperCase());
            }
            indexPinyinBean.setBaseIndexPinyin(pySb.toString());
        }
        return this;
    }

    @Override
    public IIndexBarDataHelper fillInexTag(List<? extends BaseIndexPinyinBean> datas) {
        if (null == datas || datas.isEmpty()) {
            return this;
        }
        int size = datas.size();
        for (int i = 0; i < size; ++i) {
            BaseIndexPinyinBean indexPinyinBean = datas.get(i);
            if (!indexPinyinBean.isNeedToPinyin()) continue;
            String tagString = indexPinyinBean.getBaseIndexPinyin().substring(0, 1);
            if (tagString.matches("[A-Z]")) {
                indexPinyinBean.setBaseIndexTag(tagString);
                continue;
            }
            indexPinyinBean.setBaseIndexTag("#");
        }
        return this;
    }

    @Override
    public IIndexBarDataHelper sortSourceDatas(List<? extends BaseIndexPinyinBean> datas) {
        if (null == datas || datas.isEmpty()) {
            return this;
        }
        this.convert(datas);
        this.fillInexTag(datas);
        Collections.sort(datas, new Comparator<BaseIndexPinyinBean>(){

            @Override
            public int compare(BaseIndexPinyinBean lhs, BaseIndexPinyinBean rhs) {
                if (!lhs.isNeedToPinyin()) {
                    return 0;
                }
                if (!rhs.isNeedToPinyin()) {
                    return 0;
                }
                if (lhs.getBaseIndexTag().equals("#") && !rhs.getBaseIndexTag().equals("#")) {
                    return 1;
                }
                if (!lhs.getBaseIndexTag().equals("#") && rhs.getBaseIndexTag().equals("#")) {
                    return -1;
                }
                return lhs.getBaseIndexPinyin().compareTo(rhs.getBaseIndexPinyin());
            }
        });
        return this;
    }

    @Override
    public IIndexBarDataHelper getSortedIndexDatas(List<? extends BaseIndexPinyinBean> sourceDatas, List<String> indexDatas) {
        if (null == sourceDatas || sourceDatas.isEmpty()) {
            return this;
        }
        int size = sourceDatas.size();
        for (int i = 0; i < size; ++i) {
            String baseIndexTag = sourceDatas.get(i).getBaseIndexTag();
            if (indexDatas.contains(baseIndexTag)) continue;
            indexDatas.add(baseIndexTag);
        }
        return this;
    }
}

