/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.CustomLinearLayoutManager;
import com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.bean.BaseIndexPinyinBean;
import com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.helper.IIndexBarDataHelper;
import com.tencent.qcloud.tim.uikit.component.indexlib.IndexBar.helper.IndexBarDataHelperImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class IndexBar
extends View {
    private static final String TAG = IndexBar.class.getSimpleName();
    public static String[] INDEX_STRING = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    private boolean isNeedRealIndex;
    private List<String> mIndexDatas;
    private int mWidth;
    private int mHeight;
    private int mGapHeight;
    private Paint mPaint;
    private int mPressedBackground;
    private IIndexBarDataHelper mDataHelper;
    private TextView mPressedShowTextView;
    private boolean isSourceDatasAlreadySorted;
    private List<? extends BaseIndexPinyinBean> mSourceDatas;
    private CustomLinearLayoutManager mLayoutManager;
    private int mHeaderViewCount = 0;
    private onIndexPressedListener mOnIndexPressedListener;

    public IndexBar(Context context) {
        this(context, null);
    }

    public IndexBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IndexBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    public int getHeaderViewCount() {
        return this.mHeaderViewCount;
    }

    public IndexBar setHeaderViewCount(int headerViewCount) {
        this.mHeaderViewCount = headerViewCount;
        return this;
    }

    public boolean isSourceDatasAlreadySorted() {
        return this.isSourceDatasAlreadySorted;
    }

    public IndexBar setSourceDatasAlreadySorted(boolean sourceDatasAlreadySorted) {
        this.isSourceDatasAlreadySorted = sourceDatasAlreadySorted;
        return this;
    }

    public IIndexBarDataHelper getDataHelper() {
        return this.mDataHelper;
    }

    public IndexBar setDataHelper(IIndexBarDataHelper dataHelper) {
        this.mDataHelper = dataHelper;
        return this;
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        int textSize = (int)TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mPressedBackground = -16777216;
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.IndexBar, defStyleAttr, 0);
        int n = typedArray.getIndexCount();
        for (int i = 0; i < n; ++i) {
            int attr2 = typedArray.getIndex(i);
            if (attr2 == R.styleable.IndexBar_indexBarTextSize) {
                textSize = typedArray.getDimensionPixelSize(attr2, textSize);
                continue;
            }
            if (attr2 != R.styleable.IndexBar_indexBarPressBackground) continue;
            this.mPressedBackground = typedArray.getColor(attr2, this.mPressedBackground);
        }
        typedArray.recycle();
        this.initIndexDatas();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)textSize);
        this.mPaint.setColor(context.getResources().getColor(R.color.black));
        this.setOnIndexPressedListener(new onIndexPressedListener(){

            @Override
            public void onIndexPressed(int index, String text) {
                int position;
                if (IndexBar.this.mPressedShowTextView != null) {
                    IndexBar.this.mPressedShowTextView.setVisibility(0);
                    IndexBar.this.mPressedShowTextView.setText((CharSequence)text);
                }
                if (IndexBar.this.mLayoutManager != null && (position = IndexBar.this.getPosByTag(text)) != -1) {
                    IndexBar.this.mLayoutManager.scrollToPositionWithOffset(position, 0);
                }
            }

            @Override
            public void onMotionEventEnd() {
                if (IndexBar.this.mPressedShowTextView != null) {
                    IndexBar.this.mPressedShowTextView.setVisibility(8);
                }
            }
        });
        this.mDataHelper = new IndexBarDataHelperImpl();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int wMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int wSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int hMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int hSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int measureWidth = 0;
        int measureHeight = 0;
        Rect indexBounds = new Rect();
        for (int i = 0; i < this.mIndexDatas.size(); ++i) {
            String index = this.mIndexDatas.get(i);
            this.mPaint.getTextBounds(index, 0, index.length(), indexBounds);
            measureWidth = Math.max(indexBounds.width(), measureWidth);
            measureHeight = Math.max(indexBounds.height(), measureHeight);
        }
        measureHeight *= this.mIndexDatas.size();
        switch (wMode) {
            case 0x40000000: {
                measureWidth = wSize;
                break;
            }
            case -2147483648: {
                measureWidth = Math.min(measureWidth, wSize);
                break;
            }
        }
        switch (hMode) {
            case 0x40000000: {
                measureHeight = hSize;
                break;
            }
            case -2147483648: {
                measureHeight = Math.min(measureHeight, hSize);
                break;
            }
        }
        this.setMeasuredDimension(measureWidth, measureHeight);
    }

    protected void onDraw(Canvas canvas) {
        int t = this.getPaddingTop();
        for (int i = 0; i < this.mIndexDatas.size(); ++i) {
            String index = this.mIndexDatas.get(i);
            Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
            int baseline = (int)(((float)this.mGapHeight - fontMetrics.bottom - fontMetrics.top) / 2.0f);
            canvas.drawText(index, (float)(this.mWidth / 2) - this.mPaint.measureText(index) / 2.0f, (float)(t + this.mGapHeight * i + baseline), this.mPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                this.setBackgroundColor(this.mPressedBackground);
            }
            case 2: {
                float y = event.getY();
                int pressI = (int)((y - (float)this.getPaddingTop()) / (float)this.mGapHeight);
                if (pressI < 0) {
                    pressI = 0;
                } else if (pressI >= this.mIndexDatas.size()) {
                    pressI = this.mIndexDatas.size() - 1;
                }
                if (null == this.mOnIndexPressedListener || pressI <= -1 || pressI >= this.mIndexDatas.size()) break;
                this.mOnIndexPressedListener.onIndexPressed(pressI, this.mIndexDatas.get(pressI));
                break;
            }
            default: {
                this.setBackgroundResource(17170445);
                if (null == this.mOnIndexPressedListener) break;
                this.mOnIndexPressedListener.onMotionEventEnd();
            }
        }
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        if (null == this.mIndexDatas || this.mIndexDatas.isEmpty()) {
            return;
        }
        this.computeGapHeight();
    }

    public onIndexPressedListener getOnIndexPressedListener() {
        return this.mOnIndexPressedListener;
    }

    public void setOnIndexPressedListener(onIndexPressedListener mOnIndexPressedListener) {
        this.mOnIndexPressedListener = mOnIndexPressedListener;
    }

    public IndexBar setPressedShowTextView(TextView mPressedShowTextView) {
        this.mPressedShowTextView = mPressedShowTextView;
        return this;
    }

    public IndexBar setLayoutManager(CustomLinearLayoutManager mLayoutManager) {
        this.mLayoutManager = mLayoutManager;
        return this;
    }

    public IndexBar setNeedRealIndex(boolean needRealIndex) {
        this.isNeedRealIndex = needRealIndex;
        this.initIndexDatas();
        return this;
    }

    private void initIndexDatas() {
        this.mIndexDatas = this.isNeedRealIndex ? new ArrayList<String>() : Arrays.asList(INDEX_STRING);
    }

    public IndexBar setSourceDatas(List<? extends BaseIndexPinyinBean> mSourceDatas) {
        this.mSourceDatas = mSourceDatas;
        this.initSourceDatas();
        return this;
    }

    private void initSourceDatas() {
        if (null == this.mSourceDatas || this.mSourceDatas.isEmpty()) {
            return;
        }
        if (!this.isSourceDatasAlreadySorted) {
            this.mDataHelper.sortSourceDatas(this.mSourceDatas);
        } else {
            this.mDataHelper.convert(this.mSourceDatas);
            this.mDataHelper.fillInexTag(this.mSourceDatas);
        }
        if (this.isNeedRealIndex) {
            this.mDataHelper.getSortedIndexDatas(this.mSourceDatas, this.mIndexDatas);
            this.computeGapHeight();
        }
    }

    private void computeGapHeight() {
        this.mGapHeight = (this.mHeight - this.getPaddingTop() - this.getPaddingBottom()) / this.mIndexDatas.size();
    }

    private void sortData() {
    }

    private int getPosByTag(String tag) {
        if (null == this.mSourceDatas || this.mSourceDatas.isEmpty()) {
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            return -1;
        }
        for (int i = 0; i < this.mSourceDatas.size(); ++i) {
            if (!tag.equals(this.mSourceDatas.get(i).getBaseIndexTag())) continue;
            return i + this.getHeaderViewCount();
        }
        return -1;
    }

    public static interface onIndexPressedListener {
        public void onIndexPressed(int var1, String var2);

        public void onMotionEventEnd();
    }
}

