/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.indexlib.suspension;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.tencent.qcloud.tim.uikit.component.indexlib.suspension.ISuspensionInterface;
import java.util.List;

public class SuspensionDecoration
extends RecyclerView.ItemDecoration {
    private static final String TAG = SuspensionDecoration.class.getSimpleName();
    private static int COLOR_TITLE_BG = Color.parseColor((String)"#FFEDEDED");
    private static int COLOR_TITLE_BOTTOM_LINE = Color.parseColor((String)"#FFCACACA");
    private static int COLOR_TITLE_FONT = Color.parseColor((String)"#FF888888");
    private int mTitleFontSize;
    private List<? extends ISuspensionInterface> mDatas;
    private Paint mPaint;
    private Rect mBounds;
    private int mTitleHeight;
    private int mHeaderViewCount = 0;

    public SuspensionDecoration(Context context, List<? extends ISuspensionInterface> datas) {
        this.mDatas = datas;
        this.mPaint = new Paint();
        this.mBounds = new Rect();
        this.mTitleHeight = (int)TypedValue.applyDimension((int)1, (float)33.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mTitleFontSize = (int)TypedValue.applyDimension((int)2, (float)13.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mPaint.setTextSize((float)this.mTitleFontSize);
        this.mPaint.setAntiAlias(true);
    }

    public SuspensionDecoration setTitleHeight(int mTitleHeight) {
        this.mTitleHeight = mTitleHeight;
        return this;
    }

    public SuspensionDecoration setColorTitleBg(int colorTitleBg) {
        COLOR_TITLE_BG = colorTitleBg;
        return this;
    }

    public SuspensionDecoration setColorTitleFont(int colorTitleFont) {
        COLOR_TITLE_FONT = colorTitleFont;
        return this;
    }

    public SuspensionDecoration setTitleFontSize(int mTitleFontSize) {
        this.mPaint.setTextSize((float)mTitleFontSize);
        return this;
    }

    public SuspensionDecoration setDatas(List<? extends ISuspensionInterface> mDatas) {
        this.mDatas = mDatas;
        return this;
    }

    public int getHeaderViewCount() {
        return this.mHeaderViewCount;
    }

    public SuspensionDecoration setHeaderViewCount(int headerViewCount) {
        this.mHeaderViewCount = headerViewCount;
        return this;
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int position = params.getViewLayoutPosition();
            if (this.mDatas == null || this.mDatas.isEmpty() || (position -= this.getHeaderViewCount()) > this.mDatas.size() - 1 || position < 0 || !this.mDatas.get(position).isShowSuspension() || position <= -1) continue;
            if (position == 0) {
                this.drawTitleArea(c, left, right, child, params, position);
                continue;
            }
            if (null == this.mDatas.get(position).getSuspensionTag() || this.mDatas.get(position).getSuspensionTag().equals(this.mDatas.get(position - 1).getSuspensionTag())) continue;
            this.drawTitleArea(c, left, right, child, params, position);
        }
    }

    private void drawTitleArea(Canvas c, int left, int right, View child, RecyclerView.LayoutParams params, int position) {
        this.mPaint.setColor(COLOR_TITLE_BG);
        c.drawRect((float)left, (float)(child.getTop() - params.topMargin - this.mTitleHeight), (float)right, (float)(child.getTop() - params.topMargin), this.mPaint);
        this.mPaint.setColor(COLOR_TITLE_BOTTOM_LINE);
        c.drawRect((float)left, (float)(child.getTop() - params.topMargin - 1), (float)right, (float)(child.getTop() - params.topMargin), this.mPaint);
        this.mPaint.setColor(COLOR_TITLE_FONT);
        this.mPaint.getTextBounds(this.mDatas.get(position).getSuspensionTag(), 0, this.mDatas.get(position).getSuspensionTag().length(), this.mBounds);
        c.drawText(this.mDatas.get(position).getSuspensionTag(), (float)(child.getPaddingLeft() + 61), (float)(child.getTop() - params.topMargin - (this.mTitleHeight / 2 - this.mBounds.height() / 2)), this.mPaint);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        int pos = ((LinearLayoutManager)parent.getLayoutManager()).findFirstVisibleItemPosition();
        if (this.mDatas == null || this.mDatas.isEmpty() || (pos -= this.getHeaderViewCount()) > this.mDatas.size() - 1 || pos < 0 || !this.mDatas.get(pos).isShowSuspension()) {
            return;
        }
        String tag = this.mDatas.get(pos).getSuspensionTag();
        View child = parent.findViewHolderForLayoutPosition((int)(pos + this.getHeaderViewCount())).itemView;
        boolean flag = false;
        if (pos + 1 < this.mDatas.size() && null != tag && !tag.equals(this.mDatas.get(pos + 1).getSuspensionTag()) && child.getHeight() + child.getTop() < this.mTitleHeight) {
            c.save();
            flag = true;
            c.translate(0.0f, (float)(child.getHeight() + child.getTop() - this.mTitleHeight));
        }
        this.mPaint.setColor(COLOR_TITLE_BG);
        c.drawRect((float)parent.getPaddingLeft(), (float)parent.getPaddingTop(), (float)(parent.getRight() - parent.getPaddingRight()), (float)(parent.getPaddingTop() + this.mTitleHeight), this.mPaint);
        this.mPaint.setColor(COLOR_TITLE_FONT);
        this.mPaint.getTextBounds(tag, 0, tag.length(), this.mBounds);
        c.drawText(tag, (float)(child.getPaddingLeft() + 40), (float)(parent.getPaddingTop() + this.mTitleHeight - (this.mTitleHeight / 2 - this.mBounds.height() / 2)), this.mPaint);
        if (flag) {
            c.restore();
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        ISuspensionInterface titleCategoryInterface;
        super.getItemOffsets(outRect, view, parent, state);
        int position = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
        if (this.mDatas == null || this.mDatas.isEmpty() || (position -= this.getHeaderViewCount()) > this.mDatas.size() - 1) {
            return;
        }
        if (position > -1 && (titleCategoryInterface = this.mDatas.get(position)).isShowSuspension()) {
            if (position == 0) {
                outRect.set(0, this.mTitleHeight, 0, 0);
            } else if (null != titleCategoryInterface.getSuspensionTag() && !titleCategoryInterface.getSuspensionTag().equals(this.mDatas.get(position - 1).getSuspensionTag())) {
                outRect.set(0, this.mTitleHeight, 0, 0);
            }
        }
    }
}

