/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.photoview;

import android.app.Activity;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.imsdk.v2.V2TIMDownloadCallback;
import com.tencent.imsdk.v2.V2TIMElem;
import com.tencent.imsdk.v2.V2TIMImageElem;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.photoview.OnMatrixChangedListener;
import com.tencent.qcloud.tim.uikit.component.photoview.OnPhotoTapListener;
import com.tencent.qcloud.tim.uikit.component.photoview.OnSingleFlingListener;
import com.tencent.qcloud.tim.uikit.component.photoview.PhotoView;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import java.io.File;

public class PhotoViewActivity
extends Activity {
    public static V2TIMImageElem.V2TIMImage mCurrentOriginalImage;
    private PhotoView mPhotoView;
    private Matrix mCurrentDisplayMatrix = null;
    private TextView mViewOriginalBtn;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_photo_view);
        Uri uri = FileUtil.getUriFromPath(this.getIntent().getStringExtra("image_data"));
        boolean isSelf = this.getIntent().getBooleanExtra("self_message", false);
        this.mCurrentDisplayMatrix = new Matrix();
        this.mPhotoView = (PhotoView)this.findViewById(R.id.photo_view);
        this.mPhotoView.setDisplayMatrix(this.mCurrentDisplayMatrix);
        this.mPhotoView.setOnMatrixChangeListener(new MatrixChangeListener());
        this.mPhotoView.setOnPhotoTapListener(new PhotoTapListener());
        this.mPhotoView.setOnSingleFlingListener(new SingleFlingListener());
        this.mViewOriginalBtn = (TextView)this.findViewById(R.id.view_original_btn);
        if (isSelf || mCurrentOriginalImage == null) {
            this.mPhotoView.setImageURI(uri);
        } else if (mCurrentOriginalImage != null) {
            String path = TUIKitConstants.IMAGE_DOWNLOAD_DIR + mCurrentOriginalImage.getUUID();
            File file = new File(path);
            if (file.exists()) {
                this.mPhotoView.setImageURI(FileUtil.getUriFromPath(file.getPath()));
            } else {
                this.mPhotoView.setImageURI(uri);
                this.mViewOriginalBtn.setVisibility(0);
                this.mViewOriginalBtn.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (mCurrentOriginalImage != null) {
                            String path = TUIKitConstants.IMAGE_DOWNLOAD_DIR + mCurrentOriginalImage.getUUID();
                            final File file = new File(path);
                            if (!file.exists()) {
                                mCurrentOriginalImage.downloadImage(path, new V2TIMDownloadCallback(){

                                    public void onProgress(V2TIMElem.V2ProgressInfo progressInfo) {
                                    }

                                    public void onError(int code, String desc) {
                                    }

                                    public void onSuccess() {
                                        PhotoViewActivity.this.mPhotoView.setImageURI(FileUtil.getUriFromPath(file.getPath()));
                                        PhotoViewActivity.this.mViewOriginalBtn.setText((CharSequence)PhotoViewActivity.this.getString(R.string.completed));
                                        PhotoViewActivity.this.mViewOriginalBtn.setOnClickListener(null);
                                    }
                                });
                            } else {
                                PhotoViewActivity.this.mPhotoView.setImageURI(FileUtil.getUriFromPath(file.getPath()));
                            }
                        }
                    }
                });
            }
        }
        this.findViewById(R.id.photo_view_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PhotoViewActivity.this.finish();
            }
        });
    }

    private class SingleFlingListener
    implements OnSingleFlingListener {
        private SingleFlingListener() {
        }

        @Override
        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return true;
        }
    }

    private class MatrixChangeListener
    implements OnMatrixChangedListener {
        private MatrixChangeListener() {
        }

        @Override
        public void onMatrixChanged(RectF rect) {
        }
    }

    private class PhotoTapListener
    implements OnPhotoTapListener {
        private PhotoTapListener() {
        }

        @Override
        public void onPhotoTap(ImageView view, float x, float y) {
            float xPercentage = x * 100.0f;
            float yPercentage = y * 100.0f;
        }
    }
}

