/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.video;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.component.video.JCameraView;
import com.tencent.qcloud.tim.uikit.component.video.listener.ClickListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.ErrorListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.JCameraListener;
import com.tencent.qcloud.tim.uikit.component.video.util.DeviceUtil;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;

public class CameraActivity
extends Activity {
    private static final String TAG = CameraActivity.class.getSimpleName();
    public static IUIKitCallBack mCallBack;
    private JCameraView jCameraView;

    protected void onCreate(Bundle savedInstanceState) {
        TUIKitLog.i(TAG, "onCreate");
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setRequestedOrientation(1);
        this.setContentView(R.layout.activity_camera);
        this.jCameraView = (JCameraView)this.findViewById(R.id.jcameraview);
        int state = this.getIntent().getIntExtra("camera_type", 259);
        this.jCameraView.setFeatures(state);
        if (state == 257) {
            this.jCameraView.setTip(this.getString(R.string.tap_capture));
        } else if (state == 258) {
            this.jCameraView.setTip(this.getString(R.string.tap_video));
        }
        this.jCameraView.setMediaQuality(1600000);
        this.jCameraView.setErrorLisenter(new ErrorListener(){

            @Override
            public void onError() {
                TUIKitLog.i(TAG, "camera error");
                Intent intent = new Intent();
                CameraActivity.this.setResult(103, intent);
                CameraActivity.this.finish();
            }

            @Override
            public void AudioPermissionError() {
                ToastUtil.toastShortMessage(CameraActivity.this.getString(R.string.audio_permission_error));
            }
        });
        this.jCameraView.setJCameraLisenter(new JCameraListener(){

            @Override
            public void captureSuccess(Bitmap bitmap) {
                String path = FileUtil.saveBitmap("JCamera", bitmap);
                if (mCallBack != null) {
                    mCallBack.onSuccess(path);
                }
                CameraActivity.this.finish();
            }

            @Override
            public void recordSuccess(String url, Bitmap firstFrame, long duration) {
                String path = FileUtil.saveBitmap("JCamera", firstFrame);
                Intent intent = new Intent();
                intent.putExtra("image_width", firstFrame.getWidth());
                intent.putExtra("image_height", firstFrame.getHeight());
                intent.putExtra("video_time", duration);
                intent.putExtra("camera_image_path", path);
                intent.putExtra("camera_video_path", url);
                firstFrame.getWidth();
                if (mCallBack != null) {
                    mCallBack.onSuccess(intent);
                }
                CameraActivity.this.finish();
            }
        });
        this.jCameraView.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                CameraActivity.this.finish();
            }
        });
        this.jCameraView.setRightClickListener(new ClickListener(){

            @Override
            public void onClick() {
                ToastUtil.toastShortMessage("Right");
            }
        });
        TUIKitLog.i(TAG, DeviceUtil.getDeviceModel());
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    protected void onStart() {
        super.onStart();
        if (Build.VERSION.SDK_INT >= 19) {
            View decorView = this.getWindow().getDecorView();
            decorView.setSystemUiVisibility(5894);
        } else {
            View decorView = this.getWindow().getDecorView();
            int option = 4;
            decorView.setSystemUiVisibility(option);
        }
    }

    protected void onResume() {
        TUIKitLog.i(TAG, "onResume");
        super.onResume();
        this.jCameraView.onResume();
    }

    protected void onPause() {
        TUIKitLog.i(TAG, "onPause");
        super.onPause();
        this.jCameraView.onPause();
    }

    protected void onDestroy() {
        TUIKitLog.i(TAG, "onDestroy");
        super.onDestroy();
        mCallBack = null;
    }
}

