/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.video;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.video.CaptureButton;
import com.tencent.qcloud.tim.uikit.component.video.ReturnButton;
import com.tencent.qcloud.tim.uikit.component.video.TypeButton;
import com.tencent.qcloud.tim.uikit.component.video.listener.CaptureListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.ClickListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.ReturnListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.TypeListener;

public class CaptureLayout
extends FrameLayout {
    private CaptureListener captureLisenter;
    private TypeListener typeLisenter;
    private ReturnListener returnListener;
    private ClickListener leftClickListener;
    private ClickListener rightClickListener;
    private CaptureButton btn_capture;
    private TypeButton btn_confirm;
    private TypeButton btn_cancel;
    private ReturnButton btn_return;
    private ImageView iv_custom_left;
    private ImageView iv_custom_right;
    private TextView txt_tip;
    private int layout_width;
    private int layout_height;
    private int button_size;
    private int iconLeft = 0;
    private int iconRight = 0;
    private boolean isFirst = true;

    public CaptureLayout(Context context) {
        this(context, null);
    }

    public CaptureLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CaptureLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        WindowManager manager = (WindowManager)context.getSystemService("window");
        DisplayMetrics outMetrics = new DisplayMetrics();
        manager.getDefaultDisplay().getMetrics(outMetrics);
        this.layout_width = this.getResources().getConfiguration().orientation == 1 ? outMetrics.widthPixels : outMetrics.widthPixels / 2;
        this.button_size = (int)((float)this.layout_width / 4.5f);
        this.layout_height = this.button_size + this.button_size / 5 * 2 + 100;
        this.initView();
        this.initEvent();
    }

    public void setTypeLisenter(TypeListener typeLisenter) {
        this.typeLisenter = typeLisenter;
    }

    public void setCaptureLisenter(CaptureListener captureLisenter) {
        this.captureLisenter = captureLisenter;
    }

    public void setReturnLisenter(ReturnListener returnListener) {
        this.returnListener = returnListener;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.layout_width, this.layout_height);
    }

    public void initEvent() {
        this.iv_custom_right.setVisibility(8);
        this.btn_cancel.setVisibility(8);
        this.btn_confirm.setVisibility(8);
    }

    public void startTypeBtnAnimator() {
        if (this.iconLeft != 0) {
            this.iv_custom_left.setVisibility(8);
        } else {
            this.btn_return.setVisibility(8);
        }
        if (this.iconRight != 0) {
            this.iv_custom_right.setVisibility(8);
        }
        this.btn_capture.setVisibility(8);
        this.btn_cancel.setVisibility(0);
        this.btn_confirm.setVisibility(0);
        this.btn_cancel.setClickable(false);
        this.btn_confirm.setClickable(false);
        ObjectAnimator animator_cancel = ObjectAnimator.ofFloat((Object)((Object)this.btn_cancel), (String)"translationX", (float[])new float[]{this.layout_width / 4, 0.0f});
        ObjectAnimator animator_confirm = ObjectAnimator.ofFloat((Object)((Object)this.btn_confirm), (String)"translationX", (float[])new float[]{-this.layout_width / 4, 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.playTogether(new Animator[]{animator_cancel, animator_confirm});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                CaptureLayout.this.btn_cancel.setClickable(true);
                CaptureLayout.this.btn_confirm.setClickable(true);
            }
        });
        set.setDuration(200L);
        set.start();
    }

    private void initView() {
        this.setWillNotDraw(false);
        this.btn_capture = new CaptureButton(this.getContext(), this.button_size);
        FrameLayout.LayoutParams btn_capture_param = new FrameLayout.LayoutParams(-1, -1);
        btn_capture_param.gravity = 17;
        this.btn_capture.setLayoutParams((ViewGroup.LayoutParams)btn_capture_param);
        this.btn_capture.setCaptureLisenter(new CaptureListener(){

            @Override
            public void takePictures() {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.takePictures();
                }
            }

            @Override
            public void recordShort(long time) {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordShort(time);
                }
                CaptureLayout.this.startAlphaAnimation();
            }

            @Override
            public void recordStart() {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordStart();
                }
                CaptureLayout.this.startAlphaAnimation();
            }

            @Override
            public void recordEnd(long time) {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordEnd(time);
                }
                CaptureLayout.this.startAlphaAnimation();
                CaptureLayout.this.startTypeBtnAnimator();
            }

            @Override
            public void recordZoom(float zoom) {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordZoom(zoom);
                }
            }

            @Override
            public void recordError() {
                if (CaptureLayout.this.captureLisenter != null) {
                    CaptureLayout.this.captureLisenter.recordError();
                }
            }
        });
        this.btn_cancel = new TypeButton(this.getContext(), 1, this.button_size);
        FrameLayout.LayoutParams btn_cancel_param = new FrameLayout.LayoutParams(-1, -1);
        btn_cancel_param.gravity = 16;
        btn_cancel_param.setMargins(this.layout_width / 4 - this.button_size / 2, 0, 0, 0);
        this.btn_cancel.setLayoutParams((ViewGroup.LayoutParams)btn_cancel_param);
        this.btn_cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CaptureLayout.this.typeLisenter != null) {
                    CaptureLayout.this.typeLisenter.cancel();
                }
                CaptureLayout.this.startAlphaAnimation();
            }
        });
        this.btn_confirm = new TypeButton(this.getContext(), 2, this.button_size);
        FrameLayout.LayoutParams btn_confirm_param = new FrameLayout.LayoutParams(-1, -1);
        btn_confirm_param.gravity = 21;
        btn_confirm_param.setMargins(0, 0, this.layout_width / 4 - this.button_size / 2, 0);
        this.btn_confirm.setLayoutParams((ViewGroup.LayoutParams)btn_confirm_param);
        this.btn_confirm.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CaptureLayout.this.typeLisenter != null) {
                    CaptureLayout.this.typeLisenter.confirm();
                }
                CaptureLayout.this.startAlphaAnimation();
            }
        });
        this.btn_return = new ReturnButton(this.getContext(), (int)((float)this.button_size / 2.5f));
        FrameLayout.LayoutParams btn_return_param = new FrameLayout.LayoutParams(-2, -2);
        btn_return_param.gravity = 16;
        btn_return_param.setMargins(this.layout_width / 6, 0, 0, 0);
        this.btn_return.setLayoutParams((ViewGroup.LayoutParams)btn_return_param);
        this.btn_return.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CaptureLayout.this.leftClickListener != null) {
                    CaptureLayout.this.leftClickListener.onClick();
                }
            }
        });
        this.iv_custom_left = new ImageView(this.getContext());
        FrameLayout.LayoutParams iv_custom_param_left = new FrameLayout.LayoutParams((int)((float)this.button_size / 2.5f), (int)((float)this.button_size / 2.5f));
        iv_custom_param_left.gravity = 16;
        iv_custom_param_left.setMargins(this.layout_width / 6, 0, 0, 0);
        this.iv_custom_left.setLayoutParams((ViewGroup.LayoutParams)iv_custom_param_left);
        this.iv_custom_left.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CaptureLayout.this.leftClickListener != null) {
                    CaptureLayout.this.leftClickListener.onClick();
                }
            }
        });
        this.iv_custom_right = new ImageView(this.getContext());
        FrameLayout.LayoutParams iv_custom_param_right = new FrameLayout.LayoutParams((int)((float)this.button_size / 2.5f), (int)((float)this.button_size / 2.5f));
        iv_custom_param_right.gravity = 21;
        iv_custom_param_right.setMargins(0, 0, this.layout_width / 6, 0);
        this.iv_custom_right.setLayoutParams((ViewGroup.LayoutParams)iv_custom_param_right);
        this.iv_custom_right.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CaptureLayout.this.rightClickListener != null) {
                    CaptureLayout.this.rightClickListener.onClick();
                }
            }
        });
        this.txt_tip = new TextView(this.getContext());
        FrameLayout.LayoutParams txt_param = new FrameLayout.LayoutParams(-1, -2);
        txt_param.gravity = 1;
        txt_param.setMargins(0, 0, 0, 0);
        this.txt_tip.setText((CharSequence)TUIKit.getAppContext().getString(R.string.tap_tips));
        this.txt_tip.setTextColor(-1);
        this.txt_tip.setGravity(17);
        this.txt_tip.setLayoutParams((ViewGroup.LayoutParams)txt_param);
        this.addView(this.btn_capture);
        this.addView(this.btn_cancel);
        this.addView(this.btn_confirm);
        this.addView(this.btn_return);
        this.addView((View)this.iv_custom_left);
        this.addView((View)this.iv_custom_right);
        this.addView((View)this.txt_tip);
    }

    public void resetCaptureLayout() {
        this.btn_capture.resetState();
        this.btn_cancel.setVisibility(8);
        this.btn_confirm.setVisibility(8);
        this.btn_capture.setVisibility(0);
        if (this.iconLeft != 0) {
            this.iv_custom_left.setVisibility(0);
        } else {
            this.btn_return.setVisibility(0);
        }
        if (this.iconRight != 0) {
            this.iv_custom_right.setVisibility(0);
        }
    }

    public void startAlphaAnimation() {
        if (this.isFirst) {
            ObjectAnimator animator_txt_tip = ObjectAnimator.ofFloat((Object)this.txt_tip, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
            animator_txt_tip.setDuration(500L);
            animator_txt_tip.start();
            this.isFirst = false;
        }
    }

    public void setTextWithAnimation(String tip) {
        this.txt_tip.setText((CharSequence)tip);
        ObjectAnimator animator_txt_tip = ObjectAnimator.ofFloat((Object)this.txt_tip, (String)"alpha", (float[])new float[]{0.0f, 1.0f, 1.0f, 0.0f});
        animator_txt_tip.setDuration(2500L);
        animator_txt_tip.start();
    }

    public void setDuration(int duration) {
        this.btn_capture.setDuration(duration);
    }

    public void setButtonFeatures(int state) {
        this.btn_capture.setButtonFeatures(state);
    }

    public void setTip(String tip) {
        this.txt_tip.setText((CharSequence)tip);
    }

    public void showTip() {
        this.txt_tip.setVisibility(0);
    }

    public void setIconSrc(int iconLeft, int iconRight) {
        this.iconLeft = iconLeft;
        this.iconRight = iconRight;
        if (this.iconLeft != 0) {
            this.iv_custom_left.setImageResource(iconLeft);
            this.iv_custom_left.setVisibility(0);
            this.btn_return.setVisibility(8);
        } else {
            this.iv_custom_left.setVisibility(8);
            this.btn_return.setVisibility(0);
        }
        if (this.iconRight != 0) {
            this.iv_custom_right.setImageResource(iconRight);
            this.iv_custom_right.setVisibility(0);
        } else {
            this.iv_custom_right.setVisibility(8);
        }
    }

    public void setLeftClickListener(ClickListener leftClickListener) {
        this.leftClickListener = leftClickListener;
    }

    public void setRightClickListener(ClickListener rightClickListener) {
        this.rightClickListener = rightClickListener;
    }
}

