/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.video;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.VideoView;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.component.video.CameraInterface;
import com.tencent.qcloud.tim.uikit.component.video.CaptureLayout;
import com.tencent.qcloud.tim.uikit.component.video.FoucsView;
import com.tencent.qcloud.tim.uikit.component.video.listener.CaptureListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.ClickListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.ErrorListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.JCameraListener;
import com.tencent.qcloud.tim.uikit.component.video.listener.TypeListener;
import com.tencent.qcloud.tim.uikit.component.video.state.CameraMachine;
import com.tencent.qcloud.tim.uikit.component.video.view.CameraView;
import com.tencent.qcloud.tim.uikit.utils.FileUtil;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.io.IOException;

public class JCameraView
extends FrameLayout
implements CameraInterface.CameraOpenOverCallback,
SurfaceHolder.Callback,
CameraView {
    public static final int TYPE_PICTURE = 1;
    public static final int TYPE_VIDEO = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_DEFAULT = 4;
    public static final int MEDIA_QUALITY_HIGH = 2000000;
    public static final int MEDIA_QUALITY_MIDDLE = 1600000;
    public static final int MEDIA_QUALITY_LOW = 1200000;
    public static final int MEDIA_QUALITY_POOR = 800000;
    public static final int MEDIA_QUALITY_FUNNY = 400000;
    public static final int MEDIA_QUALITY_DESPAIR = 200000;
    public static final int MEDIA_QUALITY_SORRY = 80000;
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private static final String TAG = JCameraView.class.getSimpleName();
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private CameraMachine machine;
    private int type_flash = 35;
    private JCameraListener jCameraLisenter;
    private ClickListener leftClickListener;
    private ClickListener rightClickListener;
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mPhoto;
    private ImageView mSwitchCamera;
    private CaptureLayout mCaptureLayout;
    private FoucsView mFoucsView;
    private MediaPlayer mMediaPlayer;
    private int layout_width;
    private float screenProp = 0.0f;
    private Bitmap captureBitmap;
    private Bitmap firstFrame;
    private String videoUrl;
    private int iconSize = 0;
    private int iconMargin = 0;
    private int iconSrc = 0;
    private int iconLeft = 0;
    private int iconRight = 0;
    private int duration = 0;
    private long recordTime;
    private int zoomGradient = 0;
    private boolean firstTouch = true;
    private float firstTouchLength = 0.0f;
    private ErrorListener errorLisenter;

    public JCameraView(Context context) {
        this(context, null);
    }

    public JCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.JCameraView, defStyleAttr, 0);
        this.iconSize = a.getDimensionPixelSize(R.styleable.JCameraView_iconSize, (int)TypedValue.applyDimension((int)2, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconMargin = a.getDimensionPixelSize(R.styleable.JCameraView_iconMargin, (int)TypedValue.applyDimension((int)2, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconSrc = a.getResourceId(R.styleable.JCameraView_iconSrc, R.drawable.ic_camera);
        this.iconLeft = a.getResourceId(R.styleable.JCameraView_iconLeft, 0);
        this.iconRight = a.getResourceId(R.styleable.JCameraView_iconRight, 0);
        this.duration = TUIKit.getConfigs().getGeneralConfig().getVideoRecordMaxTime() * 1000;
        a.recycle();
        this.initData();
        this.initView();
    }

    private void initData() {
        this.layout_width = ScreenUtil.getScreenWidth(this.mContext);
        this.zoomGradient = (int)((float)this.layout_width / 16.0f);
        TUIKitLog.i(TAG, "zoom = " + this.zoomGradient);
        this.machine = new CameraMachine(this.getContext(), this, this);
    }

    private void initView() {
        this.setWillNotDraw(false);
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.chat_input_camera_view, (ViewGroup)this);
        this.mVideoView = (VideoView)view.findViewById(R.id.video_preview);
        this.mPhoto = (ImageView)view.findViewById(R.id.image_photo);
        this.mSwitchCamera = (ImageView)view.findViewById(R.id.image_switch);
        this.mSwitchCamera.setImageResource(this.iconSrc);
        this.setFlashRes();
        this.mCaptureLayout = (CaptureLayout)view.findViewById(R.id.capture_layout);
        this.mCaptureLayout.setDuration(this.duration);
        this.mCaptureLayout.setIconSrc(this.iconLeft, this.iconRight);
        this.mFoucsView = (FoucsView)view.findViewById(R.id.fouce_view);
        this.mVideoView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                JCameraView.this.machine.swtich(JCameraView.this.mVideoView.getHolder(), JCameraView.this.screenProp);
            }
        });
        this.mCaptureLayout.setCaptureLisenter(new CaptureListener(){

            @Override
            public void takePictures() {
                JCameraView.this.mSwitchCamera.setVisibility(4);
                JCameraView.this.machine.capture();
            }

            @Override
            public void recordStart() {
                JCameraView.this.mSwitchCamera.setVisibility(4);
                JCameraView.this.machine.record(JCameraView.this.mVideoView.getHolder().getSurface(), JCameraView.this.screenProp);
            }

            @Override
            public void recordShort(final long time) {
                JCameraView.this.mCaptureLayout.setTextWithAnimation(TUIKit.getAppContext().getString(R.string.record_time_tip));
                JCameraView.this.mSwitchCamera.setVisibility(0);
                JCameraView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        JCameraView.this.machine.stopRecord(true, time);
                    }
                }, 1500L - time);
            }

            @Override
            public void recordEnd(long time) {
                JCameraView.this.machine.stopRecord(false, time);
                JCameraView.this.recordTime = time;
            }

            @Override
            public void recordZoom(float zoom) {
                TUIKitLog.i(TAG, "recordZoom");
                JCameraView.this.machine.zoom(zoom, 144);
            }

            @Override
            public void recordError() {
                if (JCameraView.this.errorLisenter != null) {
                    JCameraView.this.errorLisenter.AudioPermissionError();
                }
            }
        });
        this.mCaptureLayout.setTypeLisenter(new TypeListener(){

            @Override
            public void cancel() {
                JCameraView.this.machine.cancle(JCameraView.this.mVideoView.getHolder(), JCameraView.this.screenProp);
            }

            @Override
            public void confirm() {
                JCameraView.this.machine.confirm();
            }
        });
        this.mCaptureLayout.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (JCameraView.this.leftClickListener != null) {
                    JCameraView.this.leftClickListener.onClick();
                }
            }
        });
        this.mCaptureLayout.setRightClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (JCameraView.this.rightClickListener != null) {
                    JCameraView.this.rightClickListener.onClick();
                }
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float widthSize = this.mVideoView.getMeasuredWidth();
        float heightSize = this.mVideoView.getMeasuredHeight();
        if (this.screenProp == 0.0f) {
            this.screenProp = heightSize / widthSize;
        }
    }

    @Override
    public void cameraHasOpened() {
        CameraInterface.getInstance().doStartPreview(this.mVideoView.getHolder(), this.screenProp);
    }

    public void onResume() {
        TUIKitLog.i(TAG, "JCameraView onResume");
        this.resetState(4);
        CameraInterface.getInstance().registerSensorManager(this.mContext);
        this.machine.start(this.mVideoView.getHolder(), this.screenProp);
    }

    public void onPause() {
        TUIKitLog.i(TAG, "JCameraView onPause");
        this.stopVideo();
        this.resetState(1);
        CameraInterface.getInstance().isPreview(false);
        CameraInterface.getInstance().unregisterSensorManager(this.mContext);
        CameraInterface.destroyCameraInterface();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        TUIKitLog.i(TAG, "JCameraView SurfaceCreated");
        new Thread(){

            @Override
            public void run() {
                CameraInterface.getInstance().doOpenCamera(JCameraView.this);
            }
        }.start();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        TUIKitLog.i(TAG, "JCameraView SurfaceDestroyed");
        CameraInterface.getInstance().doDestroyCamera();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (event.getPointerCount() == 1) {
                    this.setFocusViewWidthAnimation(event.getX(), event.getY());
                }
                if (event.getPointerCount() != 2) break;
                TUIKitLog.i(TAG, "ACTION_DOWN = 2");
                break;
            }
            case 2: {
                if (event.getPointerCount() == 1) {
                    this.firstTouch = true;
                }
                if (event.getPointerCount() != 2) break;
                float point_1_X = event.getX(0);
                float point_1_Y = event.getY(0);
                float point_2_X = event.getX(1);
                float point_2_Y = event.getY(1);
                float result = (float)Math.sqrt(Math.pow(point_1_X - point_2_X, 2.0) + Math.pow(point_1_Y - point_2_Y, 2.0));
                if (this.firstTouch) {
                    this.firstTouchLength = result;
                    this.firstTouch = false;
                }
                if ((int)(result - this.firstTouchLength) / this.zoomGradient == 0) break;
                this.firstTouch = true;
                this.machine.zoom(result - this.firstTouchLength, 145);
                break;
            }
            case 1: {
                this.firstTouch = true;
            }
        }
        return true;
    }

    private void setFocusViewWidthAnimation(float x, float y) {
        this.machine.foucs(x, y, new CameraInterface.FocusCallback(){

            @Override
            public void focusSuccess() {
                JCameraView.this.mFoucsView.setVisibility(4);
            }
        });
    }

    private void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, height);
            videoViewParam.gravity = 17;
            this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void setJCameraLisenter(JCameraListener jCameraLisenter) {
        this.jCameraLisenter = jCameraLisenter;
    }

    public void setErrorLisenter(ErrorListener errorLisenter) {
        this.errorLisenter = errorLisenter;
        CameraInterface.getInstance().setErrorLinsenter(errorLisenter);
    }

    public void setFeatures(int state) {
        this.mCaptureLayout.setButtonFeatures(state);
    }

    public void setMediaQuality(int quality) {
        CameraInterface.getInstance().setMediaQuality(quality);
    }

    @Override
    public void resetState(int type) {
        switch (type) {
            case 2: {
                this.stopVideo();
                FileUtil.deleteFile(this.videoUrl);
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.machine.start(this.mVideoView.getHolder(), this.screenProp);
                break;
            }
            case 1: {
                this.mPhoto.setVisibility(4);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mCaptureLayout.resetCaptureLayout();
    }

    @Override
    public void confirmState(int type) {
        switch (type) {
            case 2: {
                this.stopVideo();
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.machine.start(this.mVideoView.getHolder(), this.screenProp);
                if (this.jCameraLisenter == null) break;
                this.jCameraLisenter.recordSuccess(this.videoUrl, this.firstFrame, this.recordTime);
                break;
            }
            case 1: {
                this.mPhoto.setVisibility(4);
                if (this.jCameraLisenter == null) break;
                this.jCameraLisenter.captureSuccess(this.captureBitmap);
                break;
            }
            case 3: {
                break;
            }
        }
        this.mCaptureLayout.resetCaptureLayout();
    }

    @Override
    public void showPicture(Bitmap bitmap, boolean isVertical) {
        if (isVertical) {
            this.mPhoto.setScaleType(ImageView.ScaleType.FIT_XY);
        } else {
            this.mPhoto.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        this.captureBitmap = bitmap;
        this.mPhoto.setImageBitmap(bitmap);
        this.mPhoto.setVisibility(0);
        this.mCaptureLayout.startAlphaAnimation();
        this.mCaptureLayout.startTypeBtnAnimator();
    }

    @Override
    public void playVideo(Bitmap firstFrame, String url) {
        this.videoUrl = url;
        this.firstFrame = firstFrame;
        try {
            if (this.mMediaPlayer == null) {
                this.mMediaPlayer = new MediaPlayer();
            } else {
                this.mMediaPlayer.reset();
            }
            this.mMediaPlayer.setDataSource(url);
            this.mMediaPlayer.setSurface(this.mVideoView.getHolder().getSurface());
            this.mMediaPlayer.setVideoScalingMode(1);
            this.mMediaPlayer.setAudioStreamType(3);
            this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                    JCameraView.this.updateVideoViewSize(JCameraView.this.mMediaPlayer.getVideoWidth(), JCameraView.this.mMediaPlayer.getVideoHeight());
                }
            });
            this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                public void onPrepared(MediaPlayer mp) {
                    JCameraView.this.mMediaPlayer.start();
                }
            });
            this.mMediaPlayer.setLooping(true);
            this.mMediaPlayer.prepareAsync();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopVideo() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
        }
    }

    @Override
    public void setTip(String tip) {
        this.mCaptureLayout.setTip(tip);
    }

    @Override
    public void startPreviewCallback() {
        TUIKitLog.i(TAG, "startPreviewCallback");
        this.handlerFoucs(this.mFoucsView.getWidth() / 2, this.mFoucsView.getHeight() / 2);
    }

    @Override
    public boolean handlerFoucs(float x, float y) {
        if (y > (float)this.mCaptureLayout.getTop()) {
            return false;
        }
        this.mFoucsView.setVisibility(0);
        if (x < (float)(this.mFoucsView.getWidth() / 2)) {
            x = this.mFoucsView.getWidth() / 2;
        }
        if (x > (float)(this.layout_width - this.mFoucsView.getWidth() / 2)) {
            x = this.layout_width - this.mFoucsView.getWidth() / 2;
        }
        if (y < (float)(this.mFoucsView.getWidth() / 2)) {
            y = this.mFoucsView.getWidth() / 2;
        }
        if (y > (float)(this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2)) {
            y = this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2;
        }
        this.mFoucsView.setX(x - (float)(this.mFoucsView.getWidth() / 2));
        this.mFoucsView.setY(y - (float)(this.mFoucsView.getHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleX", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleY", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"alpha", (float[])new float[]{1.0f, 0.4f, 1.0f, 0.4f, 1.0f, 0.4f, 1.0f});
        AnimatorSet animSet = new AnimatorSet();
        animSet.play((Animator)scaleX).with((Animator)scaleY).before((Animator)alpha);
        animSet.setDuration(400L);
        animSet.start();
        return true;
    }

    public void setLeftClickListener(ClickListener clickListener) {
        this.leftClickListener = clickListener;
    }

    public void setRightClickListener(ClickListener clickListener) {
        this.rightClickListener = clickListener;
    }

    private void setFlashRes() {
        switch (this.type_flash) {
            case 33: {
                this.machine.flash("auto");
                break;
            }
            case 34: {
                this.machine.flash("on");
                break;
            }
            case 35: {
                this.machine.flash("off");
            }
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }
}

