/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.video;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.component.video.proxy.IPlayer;
import com.tencent.qcloud.tim.uikit.component.video.proxy.MediaPlayerProxy;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;

public class UIKitVideoView
extends TextureView {
    private static final String TAG = UIKitVideoView.class.getSimpleName();
    private static int STATE_ERROR = -1;
    private static int STATE_IDLE = 0;
    private static int STATE_PREPARING = 1;
    private static int STATE_PREPARED = 2;
    private static int STATE_PLAYING = 3;
    private static int STATE_PAUSED = 4;
    private static int STATE_PLAYBACK_COMPLETED = 5;
    private static int STATE_STOPPED = 6;
    private int mCurrentState = STATE_IDLE;
    private Context mContext;
    private Surface mSurface;
    private MediaPlayerProxy mMediaPlayer;
    private Uri mUri;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoRotationDegree;
    private IPlayer.OnPreparedListener mOutOnPreparedListener;
    private IPlayer.OnErrorListener mOutOnErrorListener;
    private IPlayer.OnCompletionListener mOutOnCompletionListener;
    private IPlayer.OnPreparedListener mOnPreparedListener = new IPlayer.OnPreparedListener(){

        @Override
        public void onPrepared(IPlayer mp) {
            UIKitVideoView.this.mCurrentState = STATE_PREPARED;
            UIKitVideoView.this.mVideoHeight = mp.getVideoHeight();
            UIKitVideoView.this.mVideoWidth = mp.getVideoWidth();
            TUIKitLog.i(TAG, "onPrepared mVideoWidth: " + UIKitVideoView.this.mVideoWidth + " mVideoHeight: " + UIKitVideoView.this.mVideoHeight + " mVideoRotationDegree: " + UIKitVideoView.this.mVideoRotationDegree);
            if (UIKitVideoView.this.mOutOnPreparedListener != null) {
                UIKitVideoView.this.mOutOnPreparedListener.onPrepared(mp);
            }
        }
    };
    private IPlayer.OnErrorListener mOnErrorListener = new IPlayer.OnErrorListener(){

        @Override
        public boolean onError(IPlayer mp, int what, int extra) {
            TUIKitLog.w(TAG, "onError: what/extra: " + what + "/" + extra);
            UIKitVideoView.this.mCurrentState = STATE_ERROR;
            UIKitVideoView.this.stop_l();
            if (UIKitVideoView.this.mOutOnErrorListener != null) {
                UIKitVideoView.this.mOutOnErrorListener.onError(mp, what, extra);
            }
            return true;
        }
    };
    private IPlayer.OnInfoListener mOnInfoListener = new IPlayer.OnInfoListener(){

        @Override
        public void onInfo(IPlayer mp, int what, int extra) {
            TUIKitLog.w(TAG, "onInfo: what/extra: " + what + "/" + extra);
            if (what == 10001) {
                UIKitVideoView.this.mVideoRotationDegree = extra;
                UIKitVideoView.this.setRotation(UIKitVideoView.this.mVideoRotationDegree);
                UIKitVideoView.this.requestLayout();
            }
        }
    };
    private IPlayer.OnCompletionListener mOnCompletionListener = new IPlayer.OnCompletionListener(){

        @Override
        public void onCompletion(IPlayer mp) {
            TUIKitLog.i(TAG, "onCompletion");
            UIKitVideoView.this.mCurrentState = STATE_PLAYBACK_COMPLETED;
            if (UIKitVideoView.this.mOutOnCompletionListener != null) {
                UIKitVideoView.this.mOutOnCompletionListener.onCompletion(mp);
            }
        }
    };
    private IPlayer.OnVideoSizeChangedListener mOnVideoSizeChangedListener = new IPlayer.OnVideoSizeChangedListener(){

        @Override
        public void onVideoSizeChanged(IPlayer mp, int width, int height) {
        }
    };
    private TextureView.SurfaceTextureListener mSurfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            TUIKitLog.i(TAG, "onSurfaceTextureAvailable");
            UIKitVideoView.this.mSurface = new Surface(surface);
            UIKitVideoView.this.openVideo();
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            TUIKitLog.i(TAG, "onSurfaceTextureSizeChanged");
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            TUIKitLog.i(TAG, "onSurfaceTextureDestroyed");
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };

    public UIKitVideoView(Context context) {
        super(context);
        this.initVideoView(context);
    }

    public UIKitVideoView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initVideoView(context);
    }

    public UIKitVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initVideoView(context);
    }

    private void initVideoView(Context context) {
        TUIKitLog.i(TAG, "initVideoView");
        this.mContext = context;
        this.setSurfaceTextureListener(this.mSurfaceTextureListener);
        this.mCurrentState = STATE_IDLE;
    }

    public void setOnPreparedListener(IPlayer.OnPreparedListener l) {
        this.mOutOnPreparedListener = l;
    }

    public void setOnErrorListener(IPlayer.OnErrorListener l) {
        this.mOutOnErrorListener = l;
    }

    public void setOnCompletionListener(IPlayer.OnCompletionListener l) {
        this.mOutOnCompletionListener = l;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = UIKitVideoView.getDefaultSize((int)this.mVideoWidth, (int)widthMeasureSpec);
        int height = UIKitVideoView.getDefaultSize((int)this.mVideoHeight, (int)heightMeasureSpec);
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mVideoWidth > 0 && this.mVideoHeight > 0) {
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.mVideoWidth * height < width * this.mVideoHeight) {
                    width = height * this.mVideoWidth / this.mVideoHeight;
                } else if (this.mVideoWidth * height > width * this.mVideoHeight) {
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.mVideoHeight / this.mVideoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.mVideoWidth / this.mVideoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                }
            } else {
                width = this.mVideoWidth;
                height = this.mVideoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.mVideoWidth / this.mVideoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.mVideoHeight / this.mVideoWidth;
                }
            }
        }
        TUIKitLog.i(TAG, "onMeasure width: " + width + " height: " + height + " rotation degree: " + this.mVideoRotationDegree);
        this.setMeasuredDimension(width, height);
        if ((this.mVideoRotationDegree + 180) % 180 != 0) {
            int[] size = ScreenUtil.scaledSize(widthSpecSize, heightSpecSize, height, width);
            TUIKitLog.i(TAG, "onMeasure scaled width: " + size[0] + " height: " + size[1]);
            this.setScaleX((float)size[0] / (float)height);
            this.setScaleY((float)size[1] / (float)width);
        }
    }

    public void setVideoURI(Uri uri) {
        this.mUri = uri;
        this.openVideo();
    }

    private void openVideo() {
        TUIKitLog.i(TAG, "openVideo: mUri: " + this.mUri.getPath() + " mSurface: " + this.mSurface);
        if (this.mSurface == null) {
            return;
        }
        this.stop_l();
        try {
            this.mMediaPlayer = new MediaPlayerProxy();
            this.mMediaPlayer.setOnPreparedListener(this.mOnPreparedListener);
            this.mMediaPlayer.setOnCompletionListener(this.mOnCompletionListener);
            this.mMediaPlayer.setOnErrorListener(this.mOnErrorListener);
            this.mMediaPlayer.setOnInfoListener(this.mOnInfoListener);
            this.mMediaPlayer.setOnVideoSizeChangedListener(this.mOnVideoSizeChangedListener);
            this.mMediaPlayer.setSurface(this.mSurface);
            this.mMediaPlayer.setDataSource(this.getContext(), this.mUri);
            this.mMediaPlayer.prepareAsync();
            this.mCurrentState = STATE_PREPARING;
        }
        catch (Exception ex) {
            TUIKitLog.w(TAG, ex.getMessage());
            this.mCurrentState = STATE_ERROR;
        }
    }

    public boolean start() {
        TUIKitLog.i(TAG, "start mCurrentState:" + this.mCurrentState);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.start();
            this.mCurrentState = STATE_PLAYING;
        }
        return true;
    }

    public boolean stop() {
        TUIKitLog.i(TAG, "stop mCurrentState:" + this.mCurrentState);
        this.stop_l();
        return true;
    }

    public boolean pause() {
        TUIKitLog.i(TAG, "pause mCurrentState:" + this.mCurrentState);
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.pause();
            this.mCurrentState = STATE_PAUSED;
        }
        return true;
    }

    public void stop_l() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = STATE_IDLE;
        }
    }

    public boolean isPlaying() {
        if (this.mMediaPlayer != null) {
            return this.mMediaPlayer.isPlaying();
        }
        return false;
    }

    public void setBackgroundDrawable(Drawable background) {
        if (Build.VERSION.SDK_INT < 24 && background != null) {
            super.setBackgroundDrawable(background);
        }
    }

    public void setOnClickListener(@Nullable View.OnClickListener l) {
        super.setOnClickListener(l);
    }
}

