/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.video;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.component.video.UIKitVideoView;
import com.tencent.qcloud.tim.uikit.component.video.proxy.IPlayer;
import com.tencent.qcloud.tim.uikit.utils.ImageUtil;
import com.tencent.qcloud.tim.uikit.utils.ScreenUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;

public class VideoViewActivity
extends Activity {
    private static final String TAG = VideoViewActivity.class.getSimpleName();
    private UIKitVideoView mVideoView;
    private int videoWidth = 0;
    private int videoHeight = 0;

    protected void onCreate(Bundle savedInstanceState) {
        TUIKitLog.i(TAG, "onCreate start");
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.setContentView(R.layout.activity_video_view);
        this.mVideoView = (UIKitVideoView)this.findViewById(R.id.video_play_view);
        String imagePath = this.getIntent().getStringExtra("camera_image_path");
        Uri videoUri = (Uri)this.getIntent().getParcelableExtra("camera_video_path");
        Bitmap firstFrame = ImageUtil.getBitmapFormPath(imagePath);
        if (firstFrame != null) {
            this.videoWidth = firstFrame.getWidth();
            this.videoHeight = firstFrame.getHeight();
            this.updateVideoView();
        }
        this.mVideoView.setVideoURI(videoUri);
        this.mVideoView.setOnPreparedListener(new IPlayer.OnPreparedListener(){

            @Override
            public void onPrepared(IPlayer mediaPlayer) {
                VideoViewActivity.this.mVideoView.start();
            }
        });
        this.mVideoView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoViewActivity.this.mVideoView.isPlaying()) {
                    VideoViewActivity.this.mVideoView.pause();
                } else {
                    VideoViewActivity.this.mVideoView.start();
                }
            }
        });
        this.findViewById(R.id.video_view_back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoViewActivity.this.mVideoView.stop();
                VideoViewActivity.this.finish();
            }
        });
        TUIKitLog.i(TAG, "onCreate end");
    }

    public void onConfigurationChanged(Configuration newConfig) {
        TUIKitLog.i(TAG, "onConfigurationChanged start");
        super.onConfigurationChanged(newConfig);
        this.updateVideoView();
        TUIKitLog.i(TAG, "onConfigurationChanged end");
    }

    private void updateVideoView() {
        int deviceHeight;
        int deviceWidth;
        TUIKitLog.i(TAG, "updateVideoView videoWidth: " + this.videoWidth + " videoHeight: " + this.videoHeight);
        if (this.videoWidth <= 0 && this.videoHeight <= 0) {
            return;
        }
        boolean isLandscape = true;
        if (this.getResources().getConfiguration().orientation == 1) {
            isLandscape = false;
        }
        if (isLandscape) {
            deviceWidth = Math.max(ScreenUtil.getScreenWidth((Context)this), ScreenUtil.getScreenHeight((Context)this));
            deviceHeight = Math.min(ScreenUtil.getScreenWidth((Context)this), ScreenUtil.getScreenHeight((Context)this));
        } else {
            deviceWidth = Math.min(ScreenUtil.getScreenWidth((Context)this), ScreenUtil.getScreenHeight((Context)this));
            deviceHeight = Math.max(ScreenUtil.getScreenWidth((Context)this), ScreenUtil.getScreenHeight((Context)this));
        }
        int[] scaledSize = ScreenUtil.scaledSize(deviceWidth, deviceHeight, this.videoWidth, this.videoHeight);
        TUIKitLog.i(TAG, "scaled width: " + scaledSize[0] + " height: " + scaledSize[1]);
        ViewGroup.LayoutParams params = this.mVideoView.getLayoutParams();
        params.width = scaledSize[0];
        params.height = scaledSize[1];
        this.mVideoView.setLayoutParams(params);
    }

    protected void onStop() {
        TUIKitLog.i(TAG, "onStop");
        super.onStop();
        if (this.mVideoView != null) {
            this.mVideoView.stop();
        }
    }
}

