/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.component.video.proxy;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.qcloud.tim.uikit.component.video.proxy.IPlayer;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class IjkMediaPlayerWrapper
implements IPlayer {
    private static final String TAG = IjkMediaPlayerWrapper.class.getSimpleName();
    private Class mMediaPlayerClass;
    private Object mMediaPlayerInstance;

    public IjkMediaPlayerWrapper() {
        try {
            this.mMediaPlayerClass = Class.forName("tv.danmaku.ijk.media.player.IjkMediaPlayer");
            this.mMediaPlayerInstance = this.mMediaPlayerClass.newInstance();
        }
        catch (Exception e) {
            TUIKitLog.i(TAG, "no IjkMediaPlayer: " + e.getMessage());
        }
    }

    @Override
    public void setOnPreparedListener(IPlayer.OnPreparedListener l) {
        this.invokeListener("OnPreparedListener", "setOnPreparedListener", l);
    }

    @Override
    public void setOnErrorListener(IPlayer.OnErrorListener l) {
        this.invokeListener("OnErrorListener", "setOnErrorListener", l);
    }

    @Override
    public void setOnCompletionListener(IPlayer.OnCompletionListener l) {
        this.invokeListener("OnCompletionListener", "setOnCompletionListener", l);
    }

    @Override
    public void setOnVideoSizeChangedListener(IPlayer.OnVideoSizeChangedListener l) {
        this.invokeListener("OnVideoSizeChangedListener", "setOnVideoSizeChangedListener", l);
    }

    @Override
    public void setOnInfoListener(IPlayer.OnInfoListener l) {
        this.invokeListener("OnInfoListener", "setOnInfoListener", l);
    }

    @Override
    public void setDisplay(SurfaceHolder sh) {
        this.invoke("setDisplay", sh);
    }

    @Override
    public void setSurface(Surface sh) {
        this.invoke("setSurface", sh);
    }

    @Override
    public void setDataSource(Context context, Uri uri) {
        this.invoke("setDataSource", context, uri);
    }

    @Override
    public void prepareAsync() {
        this.invoke("prepareAsync", new Object[0]);
    }

    @Override
    public void release() {
        this.invoke("release", new Object[0]);
    }

    @Override
    public void start() {
        this.invoke("start", new Object[0]);
    }

    @Override
    public void stop() {
        this.invoke("stop", new Object[0]);
    }

    @Override
    public void pause() {
        this.invoke("pause", new Object[0]);
    }

    @Override
    public boolean isPlaying() {
        return (Boolean)this.invoke("isPlaying", new Object[0]);
    }

    @Override
    public int getVideoWidth() {
        return (Integer)this.invoke("getVideoWidth", new Object[0]);
    }

    @Override
    public int getVideoHeight() {
        return (Integer)this.invoke("getVideoHeight", new Object[0]);
    }

    private Object invoke(String methodName, Object ... args) {
        try {
            Class[] classes = null;
            if (args != null && args.length != 0) {
                classes = new Class[args.length];
                for (int i = 0; i < args.length; ++i) {
                    classes[i] = args[i].getClass();
                    if (Context.class.isAssignableFrom(classes[i])) {
                        classes[i] = Context.class;
                        continue;
                    }
                    if (!Uri.class.isAssignableFrom(classes[i])) continue;
                    classes[i] = Uri.class;
                }
            } else {
                args = null;
            }
            Method methodInstance = this.mMediaPlayerClass.getMethod(methodName, classes);
            Object result = methodInstance.invoke(this.mMediaPlayerInstance, args);
            return result;
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, "invoke failed: " + methodName + " error: " + e.getCause());
            return null;
        }
    }

    private void invokeListener(String className, String methodName, Object outerListener) {
        try {
            Class<?> listenerClass = Class.forName("tv.danmaku.ijk.media.player.IMediaPlayer$" + className);
            Method method = this.mMediaPlayerClass.getMethod(methodName, listenerClass);
            ListenerHandler listenerHandler = new ListenerHandler(outerListener);
            Object listenerInstance = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{listenerClass}, (InvocationHandler)listenerHandler);
            method.invoke(this.mMediaPlayerInstance, listenerInstance);
        }
        catch (Exception e) {
            TUIKitLog.e(TAG, methodName + " failed: " + e.getMessage());
        }
    }

    private class ListenerHandler
    implements InvocationHandler {
        private Object mListener;

        private ListenerHandler(Object l) {
            this.mListener = l;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.mListener == null) {
                return false;
            }
            if (this.mListener instanceof IPlayer.OnInfoListener && TextUtils.equals((CharSequence)"onInfo", (CharSequence)method.getName())) {
                if ((Integer)args[1] == 10001) {
                    TUIKitLog.i(TAG, "IMediaPlayer.MEDIA_INFO_VIDEO_ROTATION_CHANGED");
                }
                ((IPlayer.OnInfoListener)this.mListener).onInfo(IjkMediaPlayerWrapper.this, (Integer)args[1], (Integer)args[2]);
            } else if (this.mListener instanceof IPlayer.OnVideoSizeChangedListener && TextUtils.equals((CharSequence)"onVideoSizeChanged", (CharSequence)method.getName())) {
                TUIKitLog.i(TAG, "width: " + args[1] + " height: " + args[2] + " sarNum: " + args[3] + " sarDen: " + args[4]);
                ((IPlayer.OnVideoSizeChangedListener)this.mListener).onVideoSizeChanged(IjkMediaPlayerWrapper.this, (Integer)args[1], (Integer)args[2]);
            } else if (this.mListener instanceof IPlayer.OnCompletionListener && TextUtils.equals((CharSequence)"onCompletion", (CharSequence)method.getName())) {
                ((IPlayer.OnCompletionListener)this.mListener).onCompletion(IjkMediaPlayerWrapper.this);
            } else if (this.mListener instanceof IPlayer.OnErrorListener && TextUtils.equals((CharSequence)"onError", (CharSequence)method.getName())) {
                ((IPlayer.OnErrorListener)this.mListener).onError(IjkMediaPlayerWrapper.this, (Integer)args[1], (Integer)args[2]);
            } else if (this.mListener instanceof IPlayer.OnPreparedListener && TextUtils.equals((CharSequence)"onPrepared", (CharSequence)method.getName())) {
                ((IPlayer.OnPreparedListener)this.mListener).onPrepared(IjkMediaPlayerWrapper.this);
            }
            return false;
        }
    }
}

