/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.ITitleBarLayout;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.modules.chat.C2CChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.chat.GroupChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.chat.base.AbsChatLayout;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatInfo;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyManagerActivity;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoActivity;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.io.Serializable;
import java.util.List;

public class ChatLayout
extends AbsChatLayout
implements GroupChatManagerKit.GroupNotifyHandler {
    private GroupInfo mGroupInfo;
    private GroupChatManagerKit mGroupChatManager;
    private C2CChatManagerKit mC2CChatManager;
    private boolean isGroup = false;

    public ChatLayout(Context context) {
        super(context);
    }

    public ChatLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public ChatLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    public void setChatInfo(ChatInfo chatInfo) {
        super.setChatInfo(chatInfo);
        if (chatInfo == null) {
            return;
        }
        this.isGroup = chatInfo.getType() != 1;
        if (this.isGroup) {
            this.mGroupChatManager = GroupChatManagerKit.getInstance();
            this.mGroupChatManager.setGroupHandler(this);
            GroupInfo groupInfo = new GroupInfo();
            groupInfo.setId(chatInfo.getId());
            groupInfo.setChatName(chatInfo.getChatName());
            this.mGroupChatManager.setCurrentChatInfo(groupInfo);
            this.mGroupInfo = groupInfo;
            this.loadChatMessages(null);
            this.loadApplyList();
            this.getTitleBar().getRightIcon().setImageResource(R.drawable.chat_group);
            this.getTitleBar().setOnRightClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (ChatLayout.this.mGroupInfo != null) {
                        Intent intent = new Intent(ChatLayout.this.getContext(), GroupInfoActivity.class);
                        intent.putExtra("group_id", ChatLayout.this.mGroupInfo.getId());
                        ChatLayout.this.getContext().startActivity(intent);
                    } else {
                        ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.wait_tip));
                    }
                }
            });
            this.mGroupApplyLayout.setOnNoticeClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Intent intent = new Intent(ChatLayout.this.getContext(), GroupApplyManagerActivity.class);
                    intent.putExtra("groupInfo", (Serializable)ChatLayout.this.mGroupInfo);
                    ChatLayout.this.getContext().startActivity(intent);
                }
            });
        } else {
            this.getTitleBar().getRightIcon().setImageResource(R.drawable.chat_c2c);
            this.mC2CChatManager = C2CChatManagerKit.getInstance();
            this.mC2CChatManager.setCurrentChatInfo(chatInfo);
            this.loadChatMessages(null);
        }
    }

    @Override
    public ChatManagerKit getChatManager() {
        if (this.isGroup) {
            return this.mGroupChatManager;
        }
        return this.mC2CChatManager;
    }

    private void loadApplyList() {
        this.mGroupChatManager.getProvider().loadGroupApplies(new IUIKitCallBack(){

            @Override
            public void onSuccess(Object data) {
                List applies = (List)data;
                if (applies != null && applies.size() > 0) {
                    ChatLayout.this.mGroupApplyLayout.getContent().setText((CharSequence)ChatLayout.this.getContext().getString(R.string.group_apply_tips, new Object[]{applies.size()}));
                    ChatLayout.this.mGroupApplyLayout.setVisibility(0);
                }
            }

            @Override
            public void onError(String module, int errCode, String errMsg) {
                ToastUtil.toastLongMessage("loadApplyList onError: " + errMsg);
            }
        });
    }

    @Override
    public void onGroupForceExit() {
        if (this.getContext() instanceof Activity) {
            ((Activity)this.getContext()).finish();
        }
    }

    @Override
    public void onGroupNameChanged(String newName) {
        this.getTitleBar().setTitle(newName, ITitleBarLayout.POSITION.MIDDLE);
    }

    @Override
    public void onApplied(int size) {
        if (size == 0) {
            this.mGroupApplyLayout.setVisibility(8);
        } else {
            this.mGroupApplyLayout.getContent().setText((CharSequence)this.getContext().getString(R.string.group_apply_tips, new Object[]{size}));
            this.mGroupApplyLayout.setVisibility(0);
        }
    }
}

