/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.qcloud.tim.uikit.modules.chat;

import com.google.gson.Gson;
import com.tencent.imsdk.v2.V2TIMCreateGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMGroupChangeInfo;
import com.tencent.imsdk.v2.V2TIMGroupInfo;
import com.tencent.imsdk.v2.V2TIMGroupMemberInfo;
import com.tencent.imsdk.v2.V2TIMGroupTipsElem;
import com.tencent.imsdk.v2.V2TIMManager;
import com.tencent.imsdk.v2.V2TIMMessage;
import com.tencent.imsdk.v2.V2TIMSendCallback;
import com.tencent.imsdk.v2.V2TIMValueCallback;
import com.tencent.qcloud.tim.uikit.R;
import com.tencent.qcloud.tim.uikit.TUIKit;
import com.tencent.qcloud.tim.uikit.base.IUIKitCallBack;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatInfo;
import com.tencent.qcloud.tim.uikit.modules.chat.base.ChatManagerKit;
import com.tencent.qcloud.tim.uikit.modules.conversation.ConversationManagerKit;
import com.tencent.qcloud.tim.uikit.modules.group.apply.GroupApplyInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfo;
import com.tencent.qcloud.tim.uikit.modules.group.info.GroupInfoProvider;
import com.tencent.qcloud.tim.uikit.modules.group.member.GroupMemberInfo;
import com.tencent.qcloud.tim.uikit.modules.message.LiveMessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageCustom;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfo;
import com.tencent.qcloud.tim.uikit.modules.message.MessageInfoUtil;
import com.tencent.qcloud.tim.uikit.utils.TUIKitConstants;
import com.tencent.qcloud.tim.uikit.utils.TUIKitLog;
import com.tencent.qcloud.tim.uikit.utils.ToastUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupChatManagerKit
extends ChatManagerKit {
    private static final String TAG = GroupChatManagerKit.class.getSimpleName();
    private static GroupChatManagerKit mKit;
    private GroupInfo mCurrentChatInfo;
    private List<GroupApplyInfo> mCurrentApplies = new ArrayList<GroupApplyInfo>();
    private List<GroupMemberInfo> mCurrentGroupMembers = new ArrayList<GroupMemberInfo>();
    private GroupNotifyHandler mGroupHandler;
    private GroupInfoProvider mGroupInfoProvider;

    private GroupChatManagerKit() {
        this.init();
    }

    public static GroupChatManagerKit getInstance() {
        if (mKit == null) {
            mKit = new GroupChatManagerKit();
        }
        return mKit;
    }

    private static void sendTipsMessage(String groupID, V2TIMMessage message, final IUIKitCallBack callBack) {
        V2TIMManager.getMessageManager().sendMessage(message, null, groupID, 0, false, null, (V2TIMSendCallback)new V2TIMSendCallback<V2TIMMessage>(){

            public void onProgress(int progress) {
            }

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "sendTipsMessage fail:" + code + "=" + desc);
            }

            public void onSuccess(V2TIMMessage v2TIMMessage) {
                TUIKitLog.i(TAG, "sendTipsMessage onSuccess");
                if (callBack != null) {
                    callBack.onSuccess(v2TIMMessage);
                }
            }
        });
    }

    public static void createGroupChat(final GroupInfo chatInfo, final IUIKitCallBack callBack) {
        V2TIMGroupInfo v2TIMGroupInfo = new V2TIMGroupInfo();
        v2TIMGroupInfo.setGroupType(chatInfo.getGroupType());
        v2TIMGroupInfo.setGroupName(chatInfo.getGroupName());
        v2TIMGroupInfo.setGroupAddOpt(chatInfo.getJoinType());
        ArrayList<V2TIMCreateGroupMemberInfo> v2TIMCreateGroupMemberInfoList = new ArrayList<V2TIMCreateGroupMemberInfo>();
        for (int i = 0; i < chatInfo.getMemberDetails().size(); ++i) {
            GroupMemberInfo groupMemberInfo = chatInfo.getMemberDetails().get(i);
            V2TIMCreateGroupMemberInfo v2TIMCreateGroupMemberInfo = new V2TIMCreateGroupMemberInfo();
            v2TIMCreateGroupMemberInfo.setUserID(groupMemberInfo.getAccount());
            v2TIMCreateGroupMemberInfoList.add(v2TIMCreateGroupMemberInfo);
        }
        V2TIMManager.getGroupManager().createGroup(v2TIMGroupInfo, v2TIMCreateGroupMemberInfoList, (V2TIMValueCallback)new V2TIMValueCallback<String>(){

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "createGroup failed, code: " + code + "|desc: " + desc);
                if (callBack != null) {
                    callBack.onError(TAG, code, desc);
                }
            }

            public void onSuccess(final String groupId) {
                chatInfo.setId(groupId);
                Gson gson = new Gson();
                MessageCustom messageCustom = new MessageCustom();
                messageCustom.version = TUIKitConstants.version;
                messageCustom.businessID = "group_create";
                messageCustom.opUser = V2TIMManager.getInstance().getLoginUser();
                messageCustom.content = TUIKit.getAppContext().getString(R.string.create_group);
                String data = gson.toJson((Object)messageCustom);
                V2TIMMessage createTips = MessageInfoUtil.buildGroupCustomMessage(data);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                GroupChatManagerKit.sendTipsMessage(groupId, createTips, new IUIKitCallBack(){

                    @Override
                    public void onSuccess(Object data) {
                        if (callBack != null) {
                            callBack.onSuccess(groupId);
                        }
                    }

                    @Override
                    public void onError(String module, int errCode, String errMsg) {
                        TUIKitLog.e(TAG, "sendTipsMessage failed, code: " + errCode + "|desc: " + errMsg);
                    }
                });
            }
        });
    }

    public void sendLiveGroupMessage(String groupID, LiveMessageInfo info, final IUIKitCallBack callBack) {
        Gson gson = new Gson();
        String data = gson.toJson((Object)info);
        MessageInfo messageInfo = MessageInfoUtil.buildCustomMessage(data);
        V2TIMManager.getMessageManager().sendMessage(messageInfo.getTimMessage(), null, groupID, 0, false, null, (V2TIMSendCallback)new V2TIMSendCallback<V2TIMMessage>(){

            public void onProgress(int progress) {
            }

            public void onError(int code, String desc) {
                TUIKitLog.e(TAG, "sendLiveGroupMessage fail:" + code + "=" + desc);
                if (callBack != null) {
                    callBack.onError("", code, desc);
                }
            }

            public void onSuccess(V2TIMMessage v2TIMMessage) {
                TUIKitLog.i(TAG, "sendLiveGroupMessage onSuccess");
                if (callBack != null) {
                    callBack.onSuccess(v2TIMMessage);
                }
            }
        });
    }

    @Override
    protected void init() {
        super.init();
        this.mGroupInfoProvider = new GroupInfoProvider();
    }

    public GroupInfoProvider getProvider() {
        return this.mGroupInfoProvider;
    }

    @Override
    public ChatInfo getCurrentChatInfo() {
        return this.mCurrentChatInfo;
    }

    @Override
    public void setCurrentChatInfo(ChatInfo info) {
        super.setCurrentChatInfo(info);
        this.mCurrentChatInfo = (GroupInfo)info;
        this.mCurrentApplies.clear();
        this.mCurrentGroupMembers.clear();
        this.mGroupInfoProvider.loadGroupInfo(this.mCurrentChatInfo);
    }

    @Override
    protected void addGroupMessage(MessageInfo msgInfo) {
        List modifyList;
        List memberInfos;
        V2TIMMessage v2TIMMessage;
        V2TIMGroupTipsElem groupTips = null;
        if (msgInfo.getMsgType() == 259 || msgInfo.getMsgType() == 260 || msgInfo.getMsgType() == 261 || msgInfo.getMsgType() == 262 || msgInfo.getMsgType() == 263) {
            v2TIMMessage = msgInfo.getTimMessage();
            if (v2TIMMessage.getElemType() != 9) {
                return;
            }
        } else {
            return;
        }
        groupTips = v2TIMMessage.getGroupTipsElem();
        if (msgInfo.getMsgType() == 259) {
            memberInfos = groupTips.getMemberList();
            if (memberInfos.size() > 0) {
                for (V2TIMGroupMemberInfo v2TIMGroupMemberInfo : memberInfos) {
                    GroupMemberInfo member = new GroupMemberInfo();
                    member.covertTIMGroupMemberInfo(v2TIMGroupMemberInfo);
                    this.mCurrentGroupMembers.add(member);
                }
            } else {
                GroupMemberInfo member = new GroupMemberInfo();
                member.covertTIMGroupMemberInfo(groupTips.getOpMember());
                this.mCurrentGroupMembers.add(member);
            }
            this.mCurrentChatInfo.setMemberDetails(this.mCurrentGroupMembers);
        } else if (msgInfo.getMsgType() == 260 || msgInfo.getMsgType() == 261) {
            memberInfos = groupTips.getMemberList();
            if (memberInfos.size() > 0) {
                block1: for (V2TIMGroupMemberInfo v2TIMGroupMemberInfo : memberInfos) {
                    String memberUserID = v2TIMGroupMemberInfo.getUserID();
                    for (int i = 0; i < this.mCurrentGroupMembers.size(); ++i) {
                        if (!this.mCurrentGroupMembers.get(i).getAccount().equals(memberUserID)) continue;
                        this.mCurrentGroupMembers.remove(i);
                        continue block1;
                    }
                }
            } else {
                V2TIMGroupMemberInfo memberInfo = groupTips.getOpMember();
                for (int i = 0; i < this.mCurrentGroupMembers.size(); ++i) {
                    if (!this.mCurrentGroupMembers.get(i).getAccount().equals(memberInfo.getUserID())) continue;
                    this.mCurrentGroupMembers.remove(i);
                    break;
                }
            }
            this.mCurrentChatInfo.setMemberDetails(this.mCurrentGroupMembers);
        } else if ((msgInfo.getMsgType() == 262 || msgInfo.getMsgType() == 263) && (modifyList = groupTips.getGroupChangeInfoList()).size() > 0) {
            V2TIMGroupChangeInfo modifyInfo = (V2TIMGroupChangeInfo)modifyList.get(0);
            int modifyType = modifyInfo.getType();
            if (modifyType == 1) {
                this.mCurrentChatInfo.setGroupName(modifyInfo.getValue());
                if (this.mGroupHandler != null) {
                    this.mGroupHandler.onGroupNameChanged(modifyInfo.getValue());
                }
            } else if (modifyType == 3) {
                this.mCurrentChatInfo.setNotice(modifyInfo.getValue());
            }
        }
    }

    public void notifyJoinGroup(String groupID, boolean isInvited) {
        if (isInvited) {
            ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.join_group_tip) + groupID);
        } else {
            ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.joined_tip) + groupID);
        }
    }

    public void notifyJoinGroupRefused(String groupID) {
        ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.reject_join_tip) + groupID);
    }

    public void notifyKickedFromGroup(String groupID) {
        ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.kick_group) + groupID);
        ConversationManagerKit.getInstance().deleteConversation(groupID, true);
        if (this.mCurrentChatInfo != null && groupID.equals(this.mCurrentChatInfo.getId())) {
            this.onGroupForceExit();
        }
    }

    public void notifyGroupDismissed(String groupID) {
        ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.dismiss_tip_before) + groupID + TUIKit.getAppContext().getString(R.string.dismiss_tip_after));
        if (this.mCurrentChatInfo != null && groupID.equals(this.mCurrentChatInfo.getId())) {
            this.onGroupForceExit();
        }
        ConversationManagerKit.getInstance().deleteConversation(groupID, true);
    }

    public void notifyGroupRESTCustomSystemData(String groupID, byte[] customData) {
        if (this.mCurrentChatInfo != null && groupID.equals(this.mCurrentChatInfo.getId())) {
            ToastUtil.toastLongMessage(TUIKit.getAppContext().getString(R.string.get_system_notice) + new String(customData));
        }
    }

    public void onGroupForceExit() {
        if (this.mGroupHandler != null) {
            this.mGroupHandler.onGroupForceExit();
        }
    }

    @Override
    public void destroyChat() {
        super.destroyChat();
        this.mCurrentChatInfo = null;
        this.mGroupHandler = null;
        this.mCurrentApplies.clear();
        this.mCurrentGroupMembers.clear();
    }

    public void setGroupHandler(GroupNotifyHandler mGroupHandler) {
        this.mGroupHandler = mGroupHandler;
    }

    public void onApplied(int unHandledSize) {
        if (this.mGroupHandler != null) {
            this.mGroupHandler.onApplied(unHandledSize);
        }
    }

    @Override
    protected boolean isGroup() {
        return true;
    }

    @Override
    protected void assembleGroupMessage(MessageInfo message) {
        message.setGroup(true);
        message.setFromUser(V2TIMManager.getInstance().getLoginUser());
    }

    public static interface GroupNotifyHandler {
        public void onGroupForceExit();

        public void onGroupNameChanged(String var1);

        public void onApplied(int var1);
    }
}

